/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSubAccountServiceImpl
implements OrgSubAccountService {
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    @Override
    public OrgSubAccount getMaster(Integer orgId) {
        OrgSubAccount account = this.orgSubAccountDao.getMasterByOrgId(orgId);
        return account;
    }

    @Override
    public List<OrgSubAccount> getSlaves(Integer orgId, PageDto pageDto) {
        List accounts = this.orgSubAccountDao.getSlavesByMasterOrgId(orgId, pageDto);
        return accounts;
    }

    @Override
    public List<OrgSubAccount> getMasterAndSlaves(Integer orgId, PageDto pageDto) {
        List accounts = this.orgSubAccountDao.getMasterAndSlaves(orgId, pageDto);
        return accounts;
    }

    @Override
    public Integer getSlaveCount(Integer orgId) {
        Integer count = this.orgSubAccountDao.getSlavesCountByMasterOrgId(orgId);
        return count;
    }

    @Override
    public void addOrgSubAccount(OrgSubAccount orgSubAccount) {
        this.orgSubAccountDao.save((Object)orgSubAccount, new String[0]);
    }

    @Override
    public OrgSubAccount getByOrgId(Integer orgId, String ... props) {
        OrgSubAccount subAccount = this.orgSubAccountDao.getByOrgId(orgId, props);
        return subAccount;
    }

    @Override
    public List<OrgSubAccount> getByOrgIds(Collection<Integer> orgIds, String ... props) {
        List subAccounts = this.orgSubAccountDao.getByOrgIds(orgIds, OrgSubAccountStatus.NORMAL.getCode(), props);
        return subAccounts;
    }

    @Override
    public OrgSubAccount getByOrgIdIgnoreDelStatus(Integer orgId) {
        OrgSubAccount subAccount = this.orgSubAccountDao.getByOrgIdIgnoreDelStatus(orgId);
        return subAccount;
    }

    @Override
    public void update(OrgSubAccount orgSubAccount) {
        this.orgSubAccountDao.update((Object)orgSubAccount, new String[0]);
    }

    @Override
    public OrgSubAccount getSlaveIgnoreStatus(Integer orgId, Integer masterId) {
        OrgSubAccount subAccount = this.orgSubAccountDao.getSlaveIgnoreStatus(orgId, masterId);
        return subAccount;
    }

    @Override
    public List<OrgSubAccount> getSlavesIgnoreStatus(Integer orgId, PageDto pageDto) {
        List accounts = this.orgSubAccountDao.getSlavesIgnoreStatus(orgId, pageDto);
        return accounts;
    }

    @Override
    public OrgSubAccount getByOrgIdIgnoreIsdel(Integer orgId) {
        OrgSubAccount subAccount = this.orgSubAccountDao.getByOrgIdIgnoreIsdel(orgId);
        return subAccount;
    }
}

