package com.baijia.tianxiao.sal.organization.index.service;

import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.sal.organization.dto.request.TxVisitorRequest;

import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/7
 * Time: 下午3:33
 * To change this template use File | Settings | File Templates.
 */
public interface TxVisitorService {

    void saveVisitor(TxVisitorRequest request);

    List<TxVisitor> getListByDate(Date startDate, Date endDate);

    List<TxVisitor> getBeforeAndUpdateMail(Date thisDate);

    Integer getActiveCount();

    List<TxVisitor> getByMobile(String mobile);

    boolean isOrgAccountValid(Integer orgId);

    void updateVisitor(TxVisitor txVisitor);

    void modifyPassword(String mobile, String encryptPwd);

    /**
     * 剩余天数
     * remainDay=1提前一天
     * remainDay=0已经过期
     * @param remainDay
     * @return
     */
    List<TxVisitor> getReleaseAccount(int remainDay);

}
