
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.constant;

import java.util.List;

import com.google.common.collect.Lists;

/**
 * @title RootPermission
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月3日
 * @version 1.0
 */

public enum RootPermission {
    XIAOQU(1,"校区管理"),
    SHEZHIGUIZE(2,"设置规则"),
    ZIXUN(3,"咨询管理"),
    XIANSUO(4,"线索管理"),
    XUEYUAN(5,"学员管理"),
    BANJI(6,"班级管理"),
    PAIKE(7,"排课管理"),
    QIANDAO(8,"签到管理"),
    CAIWU(9,"财务管理"),
    YINGXIAO(10,"营销管理"),
    ;
    private long code;
    private String label;
    
    RootPermission(long code, String label){
        this.code = code;
        this.label = label;
    }
    
    public long getCode() {
    
        return code;
    }
    public void setCode(long code) {
    
        this.code = code;
    }
    public String getLabel() {
    
        return label;
    }
    public void setLabel(String label) {
    
        this.label = label;
    }
    public static List<Long> allRootCode = Lists.newArrayList();
    static{
        for(RootPermission rootPermission : RootPermission.values()){
            allRootCode.add(rootPermission.getCode());
        }
    }
}

    