/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.service;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceExcelDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceInfoDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxFinanceRecordDto;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxTypeRecordDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFinanceExportService {
    private static final Logger log = LoggerFactory.getLogger(ExcelFinanceExportService.class);
    private static String HEADER_FORMAT = "@";
    private static String LEFT_FORMAT = "@ ";
    public static final String EXPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String UNIT_LESSON_MONEY_FORMULA = "IF(E%d>0,E%d*D%d/60,0)";
    public static final String LESSON_MONEY_FORMULA = "SUM(F%d:F%d)";
    public static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    private static CellStyle createCellStyle(Workbook workBook, String format) {
        CellStyle cellStyle = workBook.createCellStyle();
        DataFormat dataFormat = workBook.createDataFormat();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setDataFormat(dataFormat.getFormat(format));
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        return cellStyle;
    }

    private static CellStyle createLeftStyle(Workbook workBook, String format) {
        CellStyle cellStyle = workBook.createCellStyle();
        DataFormat dataFormat = workBook.createDataFormat();
        cellStyle.setAlignment((short)1);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setDataFormat(dataFormat.getFormat(format));
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        return cellStyle;
    }

    public static Sheet createFinanceRecordSheet(Workbook workbook, String sheetName, List<String> titles, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<TxFinanceRecordDto> recordDtos) {
        Sheet sheet = workbook.createSheet(sheetName);
        int columnSize = 0;
        for (ExportField field : exportFields) {
            columnSize += field.getExportFieldSize();
        }
        ExcelFinanceExportService.createLeftRow(sheet, cellStyleMap, titles, columnSize);
        int row = titles != null ? titles.size() : 0;
        ExcelFinanceExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        Map map = Maps.newHashMap();
        for (TxFinanceRecordDto dto : recordDtos) {
            TxFinanceExcelDto financeExcelDto;
            for (TxTypeRecordDto incomeDto : dto.getIncomeList()) {
                financeExcelDto = (TxFinanceExcelDto)((Object)map.get((int)incomeDto.getType()));
                if (financeExcelDto == null) {
                    financeExcelDto = new TxFinanceExcelDto();
                }
                financeExcelDto.setType(incomeDto.getType());
                financeExcelDto.setTypeStr(incomeDto.getTypeStr());
                financeExcelDto.setIncomeSum(financeExcelDto.getIncomeSum() + incomeDto.getTypeSum());
                financeExcelDto.setIncomeNum(financeExcelDto.getIncomeNum() + incomeDto.getTypeNum());
                financeExcelDto.setAllSum(financeExcelDto.getAllSum() + incomeDto.getTypeSum());
                map.put(Integer.valueOf(financeExcelDto.getType()), financeExcelDto);
            }
            for (TxTypeRecordDto expendDto : dto.getExpendList()) {
                financeExcelDto = (TxFinanceExcelDto)((Object)map.get((int)expendDto.getType()));
                if (financeExcelDto == null) {
                    financeExcelDto = new TxFinanceExcelDto();
                }
                financeExcelDto.setType(expendDto.getType());
                financeExcelDto.setTypeStr(expendDto.getTypeStr());
                financeExcelDto.setExpendSum(financeExcelDto.getExpendSum() - expendDto.getTypeSum());
                financeExcelDto.setExpendNum(financeExcelDto.getExpendNum() + expendDto.getTypeNum());
                financeExcelDto.setAllSum(financeExcelDto.getAllSum() - expendDto.getTypeSum());
                map.put(Integer.valueOf(financeExcelDto.getType()), financeExcelDto);
            }
        }
        int allIncomeNum = 0;
        double allIncomeSum = 0.0;
        int allExpendNum = 0;
        double allExpendSum = 0.0;
        double aaaSum = 0.0;
        for (TxFinanceExcelDto dto : map.values()) {
            Row dataRow = sheet.createRow(row++);
            ExcelFinanceExportService.createCell(dataRow, 0, dto.getTypeStr(), cellStyleMap, exportFields.get(0));
            ExcelFinanceExportService.createCell(dataRow, 1, dto.getIncomeNum(), cellStyleMap, exportFields.get(1));
            ExcelFinanceExportService.createCell(dataRow, 2, ArithUtil.round((double)dto.getIncomeSum(), (int)2), cellStyleMap, exportFields.get(2));
            ExcelFinanceExportService.createCell(dataRow, 3, dto.getExpendNum(), cellStyleMap, exportFields.get(3));
            ExcelFinanceExportService.createCell(dataRow, 4, ArithUtil.round((double)dto.getExpendSum(), (int)2), cellStyleMap, exportFields.get(4));
            ExcelFinanceExportService.createCell(dataRow, 5, ArithUtil.round((double)dto.getAllSum(), (int)2), cellStyleMap, exportFields.get(5));
            allIncomeNum += dto.getIncomeNum().intValue();
            allIncomeSum += dto.getIncomeSum().doubleValue();
            allExpendNum += dto.getExpendNum().intValue();
            allExpendSum += dto.getExpendSum().doubleValue();
            aaaSum += dto.getAllSum().doubleValue();
        }
        Row dataRow = sheet.createRow(row++);
        ExcelFinanceExportService.createCell(dataRow, 0, "\u5408\u8ba1", cellStyleMap, exportFields.get(0));
        ExcelFinanceExportService.createCell(dataRow, 1, allIncomeNum, cellStyleMap, exportFields.get(1));
        ExcelFinanceExportService.createCell(dataRow, 2, ArithUtil.round((double)allIncomeSum, (int)2), cellStyleMap, exportFields.get(2));
        ExcelFinanceExportService.createCell(dataRow, 3, allExpendNum, cellStyleMap, exportFields.get(3));
        ExcelFinanceExportService.createCell(dataRow, 4, ArithUtil.round((double)allExpendSum, (int)2), cellStyleMap, exportFields.get(4));
        ExcelFinanceExportService.createCell(dataRow, 5, ArithUtil.round((double)aaaSum, (int)2), cellStyleMap, exportFields.get(5));
        List tail = Lists.newArrayList();
        tail.add("#----------------------------------------\u8d26\u52a1\u6c47\u603b\u5217\u8868\u7ed3\u675f-------------------------------------");
        tail.add("#\u5bfc\u51fa\u65f6\u95f4\uff1a[" + DateUtil.getAllDayStr((Date)new Date()) + "]");
        ExcelFinanceExportService.createTailRow(row, sheet, cellStyleMap, tail, columnSize);
        return sheet;
    }

    public static Sheet createFinanceInfoSheet(Workbook workbook, String sheetName, List<String> titles, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, List<TxFinanceInfoDto> infoDtos) {
        Sheet sheet = workbook.createSheet(sheetName);
        int columnSize = 0;
        for (ExportField field : exportFields) {
            columnSize += field.getExportFieldSize();
        }
        ExcelFinanceExportService.createLeftRow(sheet, cellStyleMap, titles, columnSize);
        int row = titles != null ? titles.size() : 0;
        ExcelFinanceExportService.createHeaderRow(sheet, cellStyleMap, exportFields, row++);
        int incomeNum = 0;
        double incomeSum = 0.0;
        int expendNum = 0;
        double expendSum = 0.0;
        for (int n = infoDtos.size() - 1; n >= 0; --n) {
            TxFinanceInfoDto dto = infoDtos.get(n);
            Row infoRow = sheet.createRow(row);
            ExcelFinanceExportService.createCell(infoRow, 0, dto.getPurchaseId(), cellStyleMap, exportFields.get(0));
            ExcelFinanceExportService.createCell(infoRow, 1, dto.getOpTypeStr(), cellStyleMap, exportFields.get(1));
            ExcelFinanceExportService.createCell(infoRow, 2, dto.getOpInfo(), cellStyleMap, exportFields.get(2));
            ExcelFinanceExportService.createCell(infoRow, 3, DateUtil.getAllDayStr((Date)dto.getCreateTime()), cellStyleMap, exportFields.get(3));
            ExcelFinanceExportService.createCell(infoRow, 4, dto.getOpTo() != 2 ? Double.valueOf(ArithUtil.round((double)dto.getOpMoney(), (int)2)) : "", cellStyleMap, exportFields.get(4));
            ExcelFinanceExportService.createCell(infoRow, 5, dto.getOpTo() == 2 ? Double.valueOf(ArithUtil.round((double)dto.getOpMoney(), (int)2)) : "", cellStyleMap, exportFields.get(5));
            ExcelFinanceExportService.createCell(infoRow, 6, dto.getPayTypeStr(), cellStyleMap, exportFields.get(6));
            ExcelFinanceExportService.createCell(infoRow, 7, ArithUtil.round((double)dto.getBalance(), (int)2), cellStyleMap, exportFields.get(7));
            if (dto.getOpTo() == 2) {
                ++expendNum;
                expendSum += dto.getOpMoney().doubleValue();
            } else {
                ++incomeNum;
                incomeSum += dto.getOpMoney().doubleValue();
            }
            ++row;
        }
        List tail = Lists.newArrayList();
        tail.add("#-----------------------------------------\u4e1a\u52a1\u660e\u7ec6\u5217\u8868\u7ed3\u675f------------------------------------");
        tail.add("#\u6536\u5165\u5408\u8ba1\uff1a" + incomeNum + "\u7b14\uff0c\u6536\u5165\u91d1\u989d\u5171" + ArithUtil.round((double)incomeSum, (int)2) + "\u5143");
        tail.add("#\u652f\u51fa\u5408\u8ba1\uff1a" + expendNum + "\u7b14\uff0c\u652f\u51fa\u91d1\u989d\u5171" + ArithUtil.round((double)expendSum, (int)2) + "\u5143");
        tail.add("#\u5bfc\u51fa\u65f6\u95f4\uff1a[" + DateUtil.getAllDayStr((Date)new Date()) + "]");
        ExcelFinanceExportService.createTailRow(row, sheet, cellStyleMap, tail, columnSize);
        return sheet;
    }

    private static void mergeCell(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        CellRangeAddress rangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        sheet.addMergedRegion(rangeAddress);
        RegionUtil.setBorderBottom((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderTop((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderLeft((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
        RegionUtil.setBorderRight((int)1, (CellRangeAddress)rangeAddress, (Sheet)sheet, (Workbook)sheet.getWorkbook());
    }

    private static Cell createCell(Row row, int column, Object value, Map<String, CellStyle> cellStyleMap, ExportField exportField) {
        Cell cell = row.createCell(column);
        String localFormat = null;
        Object object = value = value != null ? value : exportField.getDefaultVal();
        if (value != null) {
            if (value instanceof Date) {
                row.getSheet().setColumnWidth(cell.getColumnIndex(), 5120);
                localFormat = EXPORT_DATE_FORMAT;
                cell.setCellValue((Date)value);
            } else if (value instanceof Number && ((Number)value).longValue() < Integer.MAX_VALUE) {
                cell.setCellType(0);
                if (value instanceof Double) {
                    localFormat = "0.00";
                    cell.setCellValue(((Number)value).doubleValue());
                } else {
                    localFormat = "0";
                    cell.setCellValue((double)((Number)value).longValue());
                }
            } else {
                cell.setCellType(1);
                cell.setCellValue(value.toString());
                localFormat = "@";
            }
        } else {
            cell.setCellValue("");
        }
        cell.setCellStyle(ExcelFinanceExportService.getCellStyle(row.getSheet().getWorkbook(), cellStyleMap, exportField.getFormat() != null ? exportField.getFormat() : localFormat));
        return cell;
    }

    private static CellStyle getCellStyle(Workbook workbook, Map<String, CellStyle> cellStyleMap, String format) {
        if (!cellStyleMap.containsKey(format)) {
            cellStyleMap.put(format, ExcelFinanceExportService.createCellStyle(workbook, format));
        }
        return cellStyleMap.get(format);
    }

    private static CellStyle getLeftCellStyle(Workbook workbook, Map<String, CellStyle> cellStyleMap, String format) {
        if (!cellStyleMap.containsKey(format)) {
            cellStyleMap.put(format, ExcelFinanceExportService.createLeftStyle(workbook, format));
        }
        return cellStyleMap.get(format);
    }

    private static void createHeaderRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<ExportField> exportFields, int row) {
        Row headerRow = sheet.createRow(row);
        int column = 0;
        CellStyle style = ExcelFinanceExportService.getCellStyle(sheet.getWorkbook(), cellStyleMap, HEADER_FORMAT);
        for (ExportField field : exportFields) {
            column = ExcelFinanceExportService.createHeaderCell(headerRow, style, field, column);
        }
    }

    private static int createHeaderCell(Row row, CellStyle style, ExportField field, int column) {
        if (CollectionUtils.isEmpty((Collection)field.getChildren())) {
            row.getSheet().setColumnWidth(column, field.getWidth());
            Cell cell = row.createCell(column++);
            cell.setCellStyle(style);
            cell.setCellValue(field.getName());
        } else {
            for (ExportField child : field.getChildren()) {
                column = ExcelFinanceExportService.createHeaderCell(row, style, child, column);
            }
        }
        return column;
    }

    private static void createLeftRow(Sheet sheet, Map<String, CellStyle> cellStyleMap, List<String> titles, int headerSize) {
        int row = 0;
        if (CollectionUtils.isNotEmpty(titles)) {
            for (String title : titles) {
                Row titleRow = sheet.createRow(row);
                Cell cell = titleRow.createCell(0);
                cell.setCellValue(title);
                cell.setCellStyle(ExcelFinanceExportService.getLeftCellStyle(sheet.getWorkbook(), cellStyleMap, LEFT_FORMAT));
                ExcelFinanceExportService.mergeCell(sheet, row, row, 0, headerSize - 1);
                ++row;
            }
        }
    }

    private static void createTailRow(int row, Sheet sheet, Map<String, CellStyle> cellStyleMap, List<String> titles, int headerSize) {
        if (CollectionUtils.isNotEmpty(titles)) {
            for (String title : titles) {
                Row titleRow = sheet.createRow(row);
                Cell cell = titleRow.createCell(0);
                cell.setCellValue(title);
                cell.setCellStyle(ExcelFinanceExportService.getLeftCellStyle(sheet.getWorkbook(), cellStyleMap, LEFT_FORMAT));
                ExcelFinanceExportService.mergeCell(sheet, row, row, 0, headerSize - 1);
                ++row;
            }
        }
    }

    public static void exportExcel(HttpServletResponse response, Workbook workBook, String excelFileName) {
        if (StringUtils.isBlank((CharSequence)excelFileName)) {
            excelFileName = System.currentTimeMillis() + ".xlsx";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(excelFileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + excelFileName);
        }
        try {
            workBook.write((OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error("export data catch error:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
    }
}

