/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.index.dto.OrgPhotoDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgPhotoServiceImpl
implements OrgPhotoService {
    private static final Logger log = LoggerFactory.getLogger(OrgPhotoServiceImpl.class);
    @Resource
    private OrgPhotoDao orgPhotoDao;
    @Resource
    private OrgStorageDao orgStorageDao;

    @Override
    public String getPhotoUrlByOrgIdAndCategory(@NonNull Long orgId, @NonNull OrgImgType imgType) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (imgType == null) {
            throw new NullPointerException("imgType");
        }
        log.info("get org photo by orgId:{},imgType:{}", (Object)orgId, (Object)imgType);
        List photoes = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        String photoUrl = imgType.getDefaultUrl();
        if (CollectionUtils.isNotEmpty((Collection)photoes)) {
            OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)((OrgPhoto)photoes.get(0)).getOrgStorageId(), new String[]{"fid", "sn", "mimeType"});
            photoUrl = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
        }
        log.info("get org photo url by orgId:{},imgType:{},url:{}", new Object[]{orgId, imgType, photoUrl});
        return photoUrl;
    }

    @Override
    public Map<String, Object> getPhotoByOrgIdAndCategory(Long orgId, @NonNull OrgImgType imgType) {
        if (imgType == null) {
            throw new NullPointerException("imgType");
        }
        HashMap map = Maps.newHashMap();
        log.info("get org photo by orgid = {},imgType = {}", (Object)orgId, (Object)imgType);
        List photoes = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        String photoUrl = imgType.getDefaultUrl();
        if (CollectionUtils.isNotEmpty((Collection)photoes)) {
            OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)((OrgPhoto)photoes.get(0)).getOrgStorageId(), new String[]{"id", "fid", "sn", "mimeType"});
            photoUrl = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            map.put("logoStorageId", storage.getId());
            map.put("logoUrl", photoUrl);
        }
        log.info("get org photo url by map = {}", (Object)map);
        return map;
    }

    @Override
    public int saveOrUpdateOrgPhoto(Long orgId, OrgImgType imgType, int logoId) {
        int count = this.orgPhotoDao.countOrgIdAndCategory(orgId.longValue(), imgType.getValue());
        if (count >= 50) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.ORG_INFO_PHOTO_SIZE);
        }
        if (logoId <= 0) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.ORG_INFO_PHOTO_ID);
        }
        log.info("updateOrgPhoto orgId = {},logoId={},imgType={}", new Object[]{orgId, logoId, imgType});
        List photoes = Lists.newArrayList();
        if (imgType.getValue() == OrgImgType.ORG_LOGO.getValue()) {
            photoes = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        }
        Date now = new Date();
        OrgPhoto orgPhoto = null;
        if (CollectionUtils.isNotEmpty((Collection)photoes)) {
            orgPhoto = (OrgPhoto)photoes.get(0);
            orgPhoto.setUpdateTime(now);
            orgPhoto.setOrgStorageId(Integer.valueOf(logoId));
        } else {
            orgPhoto = new OrgPhoto();
            orgPhoto.setOrgId(Integer.valueOf(orgId.intValue()));
            orgPhoto.setOrgStorageId(Integer.valueOf(logoId));
            orgPhoto.setAuditstatus(AuditStatus.PASS.getValue());
            orgPhoto.setCategory(imgType.getValue());
            orgPhoto.setGroupId(Integer.valueOf(imgType.getGroupId()));
            orgPhoto.setCreateTime(now);
            orgPhoto.setUpdateTime(now);
            orgPhoto.setIsdel(DataStatus.NORMAL.getValue());
        }
        log.debug("save and update orgPhoto =={}", (Object)orgPhoto);
        this.orgPhotoDao.saveOrUpdate((Object)orgPhoto, new String[0]);
        return orgPhoto.getId();
    }

    @Override
    public List<OrgPhotoDto> listAllPhotoByType(Long orgId, OrgImgType imgType) {
        List photoes = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        if (photoes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (OrgPhoto orgPhoto : photoes) {
            OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)orgPhoto.getOrgStorageId(), new String[]{"fid", "sn", "mimeType"});
            String photoUrl = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            orgPhoto.setLink(photoUrl);
            OrgPhotoDto orgPhotoDto = new OrgPhotoDto();
            orgPhotoDto.setId(orgPhoto.getId());
            orgPhotoDto.setOrgStorageId(orgPhoto.getOrgStorageId());
            orgPhotoDto.setLink(orgPhoto.getLink());
            result.add(orgPhotoDto);
        }
        return result;
    }

    @Override
    public void batchDeleteByIds(String ids) {
        String[] idstr = ids.split(",");
        ArrayList photoIds = Lists.newArrayList();
        for (String id : idstr) {
            photoIds.add(Integer.parseInt(id));
        }
        this.orgPhotoDao.delByIds((Collection)photoIds);
    }
}

