/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.service.OrgBaseService;
import com.baijia.tianxiao.util.storage.StorageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class OrgBaseServiceImpl
implements OrgBaseService {
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgPhotoDao orgPhotoDao;
    @Resource
    private OrgStorageDao orgStorageDao;

    @Override
    public OrgBaseInfoModel getOrgBaseInfoModel(Long orgId) {
        OrgBaseInfoModel model = new OrgBaseInfoModel();
        this.getAndSetBaseInfo(orgId, model);
        this.getAndSetLogo(orgId, model);
        return model;
    }

    public void getAndSetBaseInfo(Long orgId, OrgBaseInfoModel model) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        model.setShortName(orgInfo.getShortName());
        model.setExtension(orgInfo.getExtension());
    }

    public void getAndSetLogo(Long orgId, OrgBaseInfoModel model) {
        OrgImgType imgType = OrgImgType.ORG_LOGO;
        List photoes = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        String photoUrl = imgType.getDefaultUrl();
        if (CollectionUtils.isNotEmpty((Collection)photoes)) {
            OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)((OrgPhoto)photoes.get(0)).getOrgStorageId(), new String[]{"fid", "sn", "mimeType"});
            photoUrl = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
        }
        model.setLogo(photoUrl);
    }
}

