/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.index.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.dto.request.TxVisitorRequest;
import com.baijia.tianxiao.sal.organization.index.service.TxVisitorService;
import com.baijia.yunying.hag.service.HagService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TxVisitorServiceImpl
implements TxVisitorService {
    private static final Logger log = LoggerFactory.getLogger(TxVisitorServiceImpl.class);
    @Autowired
    private TxVisitorDao txVisitorDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired(required=false)
    private HagService hagService;

    @Override
    public void saveVisitor(TxVisitorRequest request) {
        log.info("save visitor request =={}", (Object)request);
        List exist = this.txVisitorDao.getByMobile(request.getMobile());
        if (CollectionUtils.isNotEmpty((Collection)exist)) {
            log.info("I don't save exist visitor! request:{}", (Object)request);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6b64\u624b\u673a\u53f7\u7801\u5df2\u5728\u7533\u8bf7\u5217\u8868\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019");
        }
        TxVisitor txVisitor = new TxVisitor();
        if (StringUtils.isEmpty((Object)request.getOrgName()) || request.getOrgName().length() > 32) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setOrgName(request.getOrgName());
        if (StringUtils.isEmpty((Object)request.getName()) || request.getName().length() > 10) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setName(request.getName());
        if (StringUtils.isEmpty((Object)request.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setMobile(request.getMobile());
        if (request.getProvinceId() == null || request.getCityId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setProvince(request.getProvince());
        txVisitor.setCity(request.getCity());
        txVisitor.setProvinceId(request.getProvinceId());
        txVisitor.setCityId(request.getCityId());
        if (!StringUtils.isEmpty((Object)request.getRemark()) && request.getRemark().length() > 200) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setRemark(request.getRemark());
        txVisitor.setSource(request.getSource());
        txVisitor.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        txVisitor.setCreateTime(new Date());
        txVisitor.setUpdateTime(new Date());
        txVisitor.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.txVisitorDao.save((Object)txVisitor, new String[0]);
        log.info("save visitor success =={}", (Object)txVisitor);
    }

    @Override
    public List<TxVisitor> getListByDate(Date startDate, Date endDate) {
        List list = this.txVisitorDao.listByTime(startDate, endDate);
        log.debug("get visitor startDate={},endDate={}, list =={}", new Object[]{startDate, endDate, list.size()});
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Integer getActiveCount() {
        Integer count = this.txVisitorDao.getActiveCount();
        return count;
    }

    @Override
    public List<TxVisitor> getByMobile(String mobile) {
        if (StringUtils.isEmpty((Object)mobile)) {
            return null;
        }
        List visitors = this.txVisitorDao.getByMobile(mobile);
        return visitors;
    }

    @Override
    public boolean isOrgAccountValid(Integer orgId) {
        boolean result = false;
        if (orgId != null) {
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            log.info("oorgAccountrgId:{}", (Object)orgAccount);
            if (orgAccount != null && this.hagService.hasPermission((Object)orgAccount.getNumber(), 0, "tianxiao_trial_account", new Object[0])) {
                result = true;
            }
        }
        return result;
    }
}

