/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.InitPermissionConf;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConstant;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthApplicationMenuService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxAccountPermissionServiceImpl
implements TxAccountPermissionService {
    private static final Logger log = LoggerFactory.getLogger(TxAccountPermissionServiceImpl.class);
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAuthApplicationMenuService txAuthApplicationMenuService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TXAccountService txAccountService;
    public static final Integer TX_ACCOUNT_TYPE_FORMAL = 0;
    public static final Integer TX_ACCOUNT_TYPE_TRAIL = 1;
    private static final List<PermissionDto> expermissinDefaultPermission = new ArrayList<PermissionDto>();

    @Override
    public List<PermissionDto> listAllAuthModules(Integer pType, Integer deviceType, Long uId, Integer uType) {
        List permissions = this.txAccountPermissionDao.listAllConfigs(pType, deviceType, Integer.valueOf(uId.intValue()), uType);
        if (GenericsUtils.isNullOrEmpty((Object)permissions)) {
            return Collections.emptyList();
        }
        List pIds = ListUtil.toKeyList((Collection)permissions, (String)"pId", TxAccountPermission.class);
        ImmutableMap permissionMaps = Maps.uniqueIndex((Iterable)permissions, (Function)new Function<TxAccountPermission, Long>(){

            public Long apply(TxAccountPermission arg0) {
                return (long)arg0.getPId();
            }
        });
        List<ApplicationAuthConfig> findApplicationMenus = this.txAuthApplicationMenuService.findApplicationMenus(pIds);
        if (GenericsUtils.isNullOrEmpty(findApplicationMenus)) {
            return Collections.emptyList();
        }
        ArrayList<PermissionDto> retPermissions = new ArrayList<PermissionDto>(findApplicationMenus.size());
        for (ApplicationAuthConfig config : findApplicationMenus) {
            TxAccountPermission permission = (TxAccountPermission)permissionMaps.get(config.getId());
            Integer type = 0;
            if (permission != null) {
                type = permission.getPType();
            }
            PermissionDto pd = new PermissionDto();
            pd.setName(config.getModuleName());
            pd.setTag(config.getModuleCode());
            pd.setType(type);
            retPermissions.add(pd);
        }
        return retPermissions;
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType) {
        return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_FORMAL);
    }

    private List<PermissionDto> toExperiecceAccountPermissions() {
        return expermissinDefaultPermission;
    }

    private List<PermissionDto> toTxPermissionDto(List<TxAccountPermission> permissions, Integer deviceType) {
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        ArrayList<TxAccountPermission> devicePermissions = new ArrayList<TxAccountPermission>();
        for (TxAccountPermission tap : permissions) {
            if (tap.getDeviceType() != deviceType) continue;
            devicePermissions.add(tap);
        }
        log.info("find all txAccountPermission with deviceType : {} are : {} ", (Object)deviceType, (Object)devicePermissions.size());
        ImmutableMap pIds = Maps.uniqueIndex(devicePermissions, (Function)new Function<TxAccountPermission, Integer>(){

            public Integer apply(TxAccountPermission arg0) {
                return arg0.getPId();
            }
        });
        List<TXPermission> allByPid = this.txPermissionService.getAllByPid(new ArrayList<Integer>(pIds.keySet()));
        ImmutableMap allByPidMap = Maps.uniqueIndex(allByPid, (Function)new Function<TXPermission, Integer>(){

            public Integer apply(TXPermission arg0) {
                return arg0.getId();
            }
        });
        ArrayList<PermissionDto> retDtos = new ArrayList<PermissionDto>();
        for (TxAccountPermission tap : devicePermissions) {
            Integer pId = tap.getPId();
            TXPermission tp = (TXPermission)allByPidMap.get(pId);
            if (tp == null) continue;
            PermissionDto dto = new PermissionDto();
            dto.setName(tp.getName());
            dto.setTag(String.valueOf(tp.getCode()));
            dto.setType(tap.getPType());
            retDtos.add(dto);
        }
        return retDtos;
    }

    @Override
    public List<TxAccountPermission> getAllPermissionsByUId(Integer uid) {
        List txAccountPermissions = this.txAccountPermissionDao.listAllConfigs(null, null, uid, Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
        if (CollectionUtils.isEmpty((Collection)txAccountPermissions)) {
            txAccountPermissions = Lists.newArrayList();
            this.initAccountPermissions(uid, txAccountPermissions);
        }
        return txAccountPermissions;
    }

    private void initAccountPermissions(Integer uid, List<TxAccountPermission> txAccountPermissions) {
        TxAccountPermission txAccountPermission;
        log.info(" pc has permissin are : {} ", InitPermissionConf.pcCodes);
        log.info(" app has permissin are : {} ", InitPermissionConf.appCodes);
        List<TXPermission> pcPermissions = this.txPermissionService.getTXPermissionsList(InitPermissionConf.pcCodes);
        List<TXPermission> appPermissions = this.txPermissionService.getTXPermissionsList(InitPermissionConf.appCodes);
        TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)uid, new String[0]);
        TXAccount txAccount = this.txAccountService.getByOrgId(txCascadeAccount.getOrgId());
        if (CollectionUtils.isNotEmpty(pcPermissions)) {
            for (TXPermission txPermission : pcPermissions) {
                txAccountPermission = new TxAccountPermission();
                txAccountPermission.setCreateTime(new Date());
                txAccountPermission.setDeviceType(Integer.valueOf(DeviceType.PC.getCode()));
                txAccountPermission.setPId(txPermission.getId());
                if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                    txAccountPermission.setPType(InitPermissionConf.employeeDef.get(txPermission.getCode()));
                }
                if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                    txAccountPermission.setPType(InitPermissionConf.managerDef.get(txPermission.getCode()));
                    long code = txPermission.getCode();
                    if ((code == TXPermissionConstant.CAMPUS_SETTING.getCode() || code == TXPermissionConstant.ACCOUNT_SETTING.getCode() || code == TXPermissionConstant.ZIJIN.getCode()) && txAccount != null) {
                        txAccountPermission.setPType(Integer.valueOf(TXPermissionHasType.OWN.getCode()));
                    }
                }
                txAccountPermission.setUId(uid);
                txAccountPermission.setUType(Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
                txAccountPermissions.add(txAccountPermission);
            }
        }
        if (CollectionUtils.isNotEmpty(appPermissions)) {
            for (TXPermission txPermission : appPermissions) {
                txAccountPermission = new TxAccountPermission();
                txAccountPermission.setCreateTime(new Date());
                txAccountPermission.setDeviceType(Integer.valueOf(DeviceType.APP.getCode()));
                txAccountPermission.setPId(txPermission.getId());
                if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                    txAccountPermission.setPType(InitPermissionConf.employeeDef.get(txPermission.getCode()));
                }
                if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                    txAccountPermission.setPType(InitPermissionConf.managerDef.get(txPermission.getCode()));
                }
                txAccountPermission.setUId(uid);
                txAccountPermission.setUType(Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
                txAccountPermissions.add(txAccountPermission);
            }
        }
        this.txAccountPermissionDao.saveAll(txAccountPermissions, new String[0]);
    }

    @Override
    public Map<Integer, TxAccountPermission> getPermissionMap(Integer uid) {
        HashMap data = Maps.newHashMap();
        List<TxAccountPermission> list = this.getAllPermissionsByUId(uid);
        for (TxAccountPermission txAccountPermission : list) {
            data.put(txAccountPermission.getPId(), txAccountPermission);
        }
        return data;
    }

    @Override
    public void saveAll(List<TxAccountPermission> txAccountPermissions) {
        this.txAccountPermissionDao.saveAll(txAccountPermissions, new String[0]);
    }

    @Override
    public void updateAll(List<TxAccountPermission> txAccountPermissions) {
        if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
            for (TxAccountPermission txAccountPermission : txAccountPermissions) {
                this.txAccountPermissionDao.update((Object)txAccountPermission, new String[0]);
            }
        }
    }

    @Override
    public boolean hasPermission(Long cascadeId, ApplicationType deviceType, TXPermissionConstant permission) {
        ArrayList<Long> codes = new ArrayList<Long>();
        codes.add(permission.getCode());
        List<TXPermission> permissionList = this.txPermissionService.getTXPermissionsList(codes);
        if (CollectionUtils.isEmpty(permissionList)) {
            return false;
        }
        TxAccountPermission txAccountPermission = this.txAccountPermissionDao.getTxAccountPermission(permissionList.get(0).getId(), deviceType.type, Integer.valueOf(cascadeId.intValue()));
        return txAccountPermission != null && txAccountPermission.getPType().equals(PermissionOperationType.CAN_USE.type);
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType, Integer accountTypeOfUser) {
        if (accountTypeOfUser == null) {
            accountTypeOfUser = TX_ACCOUNT_TYPE_FORMAL;
        }
        AuthorityDto authorityDto = new AuthorityDto();
        RoleType superRole = null;
        Long roleValue = null;
        String roleName = "";
        Integer uId = casCadeId;
        List<PermissionDto> permissionDtos = null;
        if (accountTypeOfUser == TX_ACCOUNT_TYPE_FORMAL) {
            if (casCadeId != null && (long)casCadeId.intValue() != 0L) {
                TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)casCadeId, new String[0]);
                if (tca == null) {
                    log.info("can not find any cascade account with cadcadeId : {} ", (Object)casCadeId);
                    return null;
                }
                Integer accountType = tca.getAccountType();
                superRole = RoleType.getRoleType((Integer)accountType);
            } else {
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()));
                if (osa == null) {
                    OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
                    if (accountById == null) {
                        log.info(" can not find any org account with orgId : {} ", (Object)orgId);
                        return null;
                    }
                    superRole = RoleType.PRESIDENT;
                } else {
                    Integer pId = osa.getPid();
                    superRole = 0 == pId ? RoleType.PRESIDENT : RoleType.BRANCH_SCH_PRESIDENT;
                }
                uId = orgId.intValue();
            }
            log.info("uId is :{} and roleType is : {} ", (Object)uId, (Object)roleName);
            List<TxAccountPermission> permissions = null;
            if (superRole != RoleType.PRESIDENT && superRole != RoleType.BRANCH_SCH_PRESIDENT) {
                permissions = this.getAllPermissionsByUId(uId);
                log.info("begin to txPermissionDto with : {} ", (Object)permissions.size());
                permissionDtos = this.toTxPermissionDto(permissions, deviceType);
            }
        } else if (accountTypeOfUser == TX_ACCOUNT_TYPE_TRAIL) {
            superRole = RoleType.PRESIDENT;
            permissionDtos = this.toExperiecceAccountPermissions();
        }
        roleValue = superRole.type.longValue();
        roleName = superRole.desc;
        authorityDto.setRole(roleValue);
        authorityDto.setRoleName(roleName);
        authorityDto.setHasPermissions(permissionDtos);
        return authorityDto;
    }

    static {
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6821\u9a8c\u8f93\u5165\u7684\u652f\u4ed8\u5bc6\u7801", "10601", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u63d0\u73b0", "10602", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6536\u6b3e\u9875\u9762", "10302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6dfb\u52a0\u673a\u6784\u7535\u8bdd", "4060302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u5220\u9664\u673a\u6784\u7535\u8bdd", "4060301", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u7f16\u8f91\u673a\u6784\u7535\u8bdd", "4060303", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801", "10603", 1));
    }
}

