/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgVideoDao;
import com.baijia.tianxiao.dal.org.dao.OrgVideoStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgVideo;
import com.baijia.tianxiao.dal.org.po.OrgVideoStorage;
import com.baijia.tianxiao.sal.organization.constant.VideoSrcType;
import com.baijia.tianxiao.sal.organization.org.dto.OrgVideoResponse;
import com.baijia.tianxiao.sal.organization.org.service.OrgVideoService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgVideoServiceImpl
implements OrgVideoService {
    private static final Logger log = LoggerFactory.getLogger(OrgVideoServiceImpl.class);
    @Autowired
    private OrgVideoDao orgVideoDao;
    @Autowired
    private OrgVideoStorageDao orgVideoStorageDao;

    @Override
    public List<OrgVideoResponse> loadOrgAllVideo(Integer org_id, PageDto pageDto) {
        List videos = this.orgVideoDao.searchOrgAllVideo(org_id, Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto, new String[0]);
        ArrayList<OrgVideoResponse> videoDtos = null;
        if (CollectionUtils.isNotEmpty((Collection)videos)) {
            List videoStorages = this.orgVideoStorageDao.searchOrgAllVideo(org_id, Integer.valueOf(VideoSrcType.ORG.getValue()), new String[0]);
            Map<Integer, OrgVideoStorage> storageMap = this.makeVidStorageMap(videoStorages);
            log.info("OrgVideoServiceImpl.loadOrgAllVideo: orgId:{}, video count:{}", (Object)org_id, (Object)videos.size());
            videoDtos = new ArrayList<OrgVideoResponse>();
            OrgVideoResponse dto = null;
            try {
                String preVideoLink = PropertiesReader.getValue((String)"wxm", (String)"video.link");
                for (OrgVideo po : videos) {
                    dto = new OrgVideoResponse();
                    dto.setId(po.getId());
                    dto.setVid(String.valueOf(po.getVid()));
                    dto.setvName(po.getVName());
                    dto.setAuditstatus(po.getAuditstatus());
                    dto.setOther(po.getOther());
                    dto.setReason(po.getReason());
                    OrgVideoStorage storage = storageMap.get(po.getVid());
                    if (storage == null) {
                        log.warn("OrgVideoServiceImpl.loadOrgAllVideo: vid:{} has no cover ,abort it", (Object)po.getVid());
                        continue;
                    }
                    log.info("org_id:{}, vid:{}, cover:{}", new Object[]{org_id, po.getVid(), storage.getImg()});
                    dto.setCover(storage.getImg());
                    dto.setVideo_unique(storage.getVideo_unique());
                    dto.setSource(storage.getSource());
                    dto.setLink(preVideoLink + dto.getVideo_unique());
                    videoDtos.add(dto);
                }
            }
            catch (Exception e) {
                log.error("loadAllVideo for {}", (Object)org_id, (Object)e);
                throw e;
            }
        }
        log.info("OrgVideoServiceImpl.loadOrgAllVideo: videoDtos:{}", videoDtos);
        return videoDtos;
    }

    private Map<Integer, OrgVideoStorage> makeVidStorageMap(List<OrgVideoStorage> videoStorages) {
        if (CollectionUtils.isEmpty(videoStorages)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrgVideoStorage storage : videoStorages) {
            map.put(storage.getVideo_id(), storage);
        }
        return map;
    }
}

