/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.sal.organization.finance.dto.response.FinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgFinanceAcountServiceImpl
implements OrgFinanceAccountService {
    private static final Logger log = LoggerFactory.getLogger(OrgFinanceAcountServiceImpl.class);
    @Resource
    private OrgFinanceAccountDao orgFinanceAccountDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;

    @Override
    public FinanceAccountDto getInfo(Long orgId) {
        OrgFinanceAccount account = this.orgFinanceAccountDao.getByOrgId(orgId, new String[0]);
        if (account == null) {
            return new FinanceAccountDto();
        }
        Long signupMoney = this.orgSignupInfoDao.sumByPurchaseStatus(orgId, (Collection)Lists.newArrayList((Object[])new Integer[]{PayResult.SUCCESS.getCode()}), (Collection)Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.PENDING.getCode(), SplitCourseResult.NOT_COMMIT.getCode()}), null, true);
        double withdrawMondy = this.orgFinanceAccountRecordDao.sumDrawcashMoney(orgId.longValue());
        return this.buildDto(account, signupMoney, withdrawMondy);
    }

    private FinanceAccountDto buildDto(OrgFinanceAccount account, Long signupMoney, double withdrawMondy) {
        FinanceAccountDto dto = new FinanceAccountDto();
        dto.setBalance(NumberUtil.get2Double((double)account.getBalance()));
        dto.setWithdrawMoney(NumberUtil.get2Double((double)withdrawMondy));
        dto.setSettleMoney(NumberUtil.get2Double((double)(account.getFreezeMoney() - withdrawMondy)));
        log.debug("signupMoney1={}", (Object)signupMoney);
        dto.setSignupMoney(signupMoney == null ? 0.0 : ArithUtil.div((double)signupMoney.longValue(), (double)100.0, (int)2));
        log.debug("signupMoney2={}", (Object)dto.getSignupMoney());
        dto.setAssureMoney(NumberUtil.get2Double((double)(account.getExpectedEarning() - dto.getSignupMoney())));
        dto.setFreezeMoney(NumberUtil.get2Double((double)(account.getFreezeMoney() + account.getExpectedEarning())));
        return dto;
    }
}

