/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.TeacherClassCourseStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.constant.ClassCourseStatus;
import com.baijia.tianxiao.dal.course.dao.ClassCoursePhotoDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgRecommendCourseDao;
import com.baijia.tianxiao.dal.course.dao.SubjectDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.ClassCoursePhoto;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroupRelate;
import com.baijia.tianxiao.dal.course.po.OrgRecommendCourse;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTemplateCourse;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.TemplatModuleType;
import com.baijia.tianxiao.sal.organization.dto.OptionalParams;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.dto.OrgRecommendCourseList;
import com.baijia.tianxiao.sal.organization.org.dto.init.DefaultTemplateData;
import com.baijia.tianxiao.sal.organization.org.dto.init.DefaultTemplateDataList;
import com.baijia.tianxiao.sal.organization.org.dto.k12.K12TemplateData;
import com.baijia.tianxiao.sal.organization.org.dto.k12.OrgHotCourseDto;
import com.baijia.tianxiao.sal.organization.org.dto.kaixue.KaixueTemplateDate;
import com.baijia.tianxiao.sal.organization.org.service.OrgIndexService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTemplateCourseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgIndexService")
public class OrgIndexServiceImpl
implements OrgIndexService {
    private static final Logger logger = LoggerFactory.getLogger(OrgIndexServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;
    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;
    @Autowired
    private TeacherClassCourseDao teacherClassCourseDao;
    @Autowired
    private OrgRecommendCourseDao orgRecommendCourseDao;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private SubjectDao subjectDao;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private ClassCoursePhotoDao classCoursePhotoDao;
    @Autowired
    private OrgTemplateCourseService orgTemplateCourseService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JSONObject render(Integer orgId, Boolean readOnly, OptionalParams params) throws BussinessException {
        String scheme = "default";
        JSONObject content = null;
        if (params.getTemplateId() == null) {
            OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
            if (usingTemplate != null) {
                params.setTemplateId(usingTemplate.getTemplateId());
            }
            if (usingTemplate == null) throw new BussinessException((UniverseErrorCode)OrgErrorCode.NO_TEMPLATE_SELECTED);
            String config = usingTemplate.getContent();
            OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)usingTemplate.getTemplateId(), new String[0]);
            if (template != null) {
                JSONObject templateJson = JSONObject.fromObject((Object)template.getContent());
                templateJson.put((Object)"config", (Object)JSONObject.fromObject((Object)config));
                content = templateJson;
            }
        } else {
            OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)params.getTemplateId(), new String[0]);
            if (template == null) {
                throw new BussinessException((UniverseErrorCode)OrgErrorCode.NO_TEMPLATE_SELECTED);
            }
            OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
            if (usingTemplate != null && usingTemplate.getTemplateId() == params.getTemplateId()) {
                String config = usingTemplate.getContent();
                content = JSONObject.fromObject((Object)template.getContent());
                content.put((Object)"config", (Object)JSONObject.fromObject((Object)config));
            } else {
                usingTemplate = this.orgHomepageConfigDao.getTemplateConf(orgId, params.getTemplateId());
                if (usingTemplate != null) {
                    String config = usingTemplate.getContent();
                    content = JSONObject.fromObject((Object)template.getContent());
                    content.put((Object)"config", (Object)JSONObject.fromObject((Object)config));
                } else {
                    content = JSONObject.fromObject((Object)template.getContent());
                }
            }
        }
        scheme = content.getString("scheme");
        return this.dispatch(orgId, scheme, content.toString(), readOnly, params);
    }

    private JSONObject dispatch(Integer orgId, String scheme, String content, Boolean readOnly, OptionalParams params) {
        JSONObject templateJson = null;
        if ("abroad".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperAbroadTemplate(orgId, content, params);
        } else if ("art".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperArtTemplate(orgId, content, params);
        } else if ("k12".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperK12Template(orgId, content, params, readOnly);
        } else if ("kaixue".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperKaixueTemplate(orgId, content, params, readOnly);
        } else if ("zaojiao".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperZaojiaoTemplate(orgId, content, params, readOnly);
        } else if ("default".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperDefaultTemplate(orgId, content, params);
        } else if ("life".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperK12Template(orgId, content, params, readOnly);
        } else if ("language".equalsIgnoreCase(scheme)) {
            templateJson = this.wrapperK12Template(orgId, content, params, readOnly);
        } else {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.TEMPLATE_NOT_EXISTS);
        }
        templateJson.put((Object)"scheme", (Object)scheme);
        templateJson.put((Object)"templateId", (Object)params.getTemplateId());
        templateJson.put((Object)"readOnly", (Object)(readOnly != false ? BizConf.TRUE.toString() : BizConf.FALSE.toString()));
        logger.info("dispatch.templateScheme:{}", (Object)templateJson.toString());
        return templateJson;
    }

    private JSONObject wrapperDefaultTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        DefaultTemplateData data = new DefaultTemplateData();
        List<DefaultTemplateDataList> subList = this.getAboutUsLinks(model.getNumber(), params.getMonkeySiteHost());
        data.setGrid(subList);
        JSONObject defaultJson = JSONObject.fromObject((Object)content);
        defaultJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        defaultJson.put((Object)"data", (Object)dataJson);
        return defaultJson;
    }

    private OrgBaseInfoModel getAndSetOrgInfoModel(Integer orgId, OptionalParams params) {
        OrgBaseInfoModel model = new OrgBaseInfoModel();
        this.getAndSetOrgNumber(orgId, model, params.getMonkeySiteHost());
        this.getAndSetSummary(orgId, model);
        this.getAndSetAddress(orgId, model);
        this.getAndSetTags(orgId, model);
        this.getAndSetOrgLogo(orgId, model, params.getImgServer());
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        if (usingTemplate != null) {
            model.setTemplateId(usingTemplate.getTemplateId());
        }
        model.setLinks(this.getFooterLinks(model.getNumber(), params.getMonkeySiteHost()));
        return model;
    }

    private JSONObject getFooterLinks(Integer number, String monkeySizeHost) {
        JSONObject links = new JSONObject();
        links.put((Object)"course", (Object)this.getLink("{host}/org/course/{number}", number, monkeySizeHost));
        links.put((Object)"brief", (Object)this.getLink("{host}/org/intro/{number}", number, monkeySizeHost));
        links.put((Object)"comment", (Object)this.getLink("{host}/org/comment/{number}", number, monkeySizeHost));
        links.put((Object)"album", (Object)this.getLink("{host}/org/photo/{number}", number, monkeySizeHost));
        links.put((Object)"branch", (Object)this.getLink("{host}/org/area/{number}", number, monkeySizeHost));
        links.put((Object)"teacher", (Object)this.getLink("{host}/org/teacher/{number}", number, monkeySizeHost));
        links.put((Object)"coupon", (Object)this.getLink("{host}/org/couponList?number={number}", number, monkeySizeHost));
        return links;
    }

    private JSONObject wrapperArtTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        JSONObject artJson = JSONObject.fromObject((Object)content);
        List<String> subjects = this.getOrgCourseSubject(orgId, model.getNumber(), BizConf.MAX_SUBJECT_DISPLAY);
        List<DefaultTemplateDataList> kinds = this.getCourseSubjects(subjects, BizConf.MAX_SUBJECT_DISPLAY, model, params);
        JSONObject dataJson = artJson.getJSONObject("data");
        dataJson.put((Object)"kinds", (Object)JSONArray.fromObject(kinds));
        artJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        artJson.put((Object)"data", (Object)dataJson);
        return artJson;
    }

    private JSONObject wrapperK12Template(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        K12TemplateData data = new K12TemplateData();
        List<OrgRecommendCourseList> courseList = this.getAndSetRecommentCourseList(orgId, params);
        data.setCourseList(courseList);
        List<DefaultTemplateDataList> grid = this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost());
        data.setGrid(grid);
        if (readOnly.booleanValue()) {
            if (grid != null && !grid.isEmpty()) {
                data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), grid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
            } else {
                data.setClassifyCourseList(Collections.emptyList());
            }
        } else {
            List<DefaultTemplateDataList> tempGrid = this.getTempGrids(orgId, grid);
            data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
        }
        JSONObject k12Json = JSONObject.fromObject((Object)content);
        k12Json.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        k12Json.put((Object)"data", (Object)dataJson);
        return k12Json;
    }

    private JSONObject wrapperKaixueTemplate(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        KaixueTemplateDate data = new KaixueTemplateDate();
        logger.info("params=={},", (Object)params);
        data.setMiaoshaList(this.convertToKaixue(params, this.orgTemplateCourseService.getByOrgIdTemplate(orgId, params.getTemplateId(), TemplatModuleType.MIAOSHA.getValue()), readOnly));
        data.setTehuiList(this.convertToKaixue(params, this.orgTemplateCourseService.getByOrgIdTemplate(orgId, params.getTemplateId(), TemplatModuleType.TEHUI.getValue()), readOnly));
        logger.info("data=={},", (Object)data);
        List<DefaultTemplateDataList> grid = this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost());
        List<DefaultTemplateDataList> tempGrid = this.getTempGrids(orgId, grid);
        data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
        JSONObject kaixueJson = JSONObject.fromObject((Object)content);
        kaixueJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        kaixueJson.put((Object)"data", (Object)dataJson);
        return kaixueJson;
    }

    private JSONObject wrapperZaojiaoTemplate(Integer orgId, String content, OptionalParams params, Boolean readOnly) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        K12TemplateData data = new K12TemplateData();
        List<DefaultTemplateDataList> grid = this.getOrgCourseSubjects(orgId, model.getNumber(), params.getMonkeySiteHost());
        List<DefaultTemplateDataList> tempGrid = this.getTempGrids(orgId, grid);
        data.setClassifyCourseList(this.getOrgHotCourseList(model.getNumber(), tempGrid, params.getImgServer(), params.getMonkeySiteHost(), readOnly));
        JSONObject zaojiaoJson = JSONObject.fromObject((Object)content);
        zaojiaoJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        JSONObject dataJson = JSONObject.fromObject((Object)((Object)data));
        zaojiaoJson.put((Object)"data", (Object)dataJson);
        return zaojiaoJson;
    }

    private List<DefaultTemplateDataList> getTempGrids(Integer orgId, List<DefaultTemplateDataList> grids) {
        List orgCourseGroupList;
        ArrayList tempGrids = Lists.newArrayList();
        HashMap existGrids = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(grids)) {
            for (DefaultTemplateDataList grid : grids) {
                if (grid.getCourseGroupId() == null) continue;
                existGrids.put(grid.getCourseGroupId(), grid);
            }
            if (existGrids.size() >= BizConf.MAX_COURSE_GROUP) {
                return grids;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(orgCourseGroupList = this.orgCourseGroupDao.getOrgCourseGroupList(orgId)))) {
            for (OrgCourseGroup group : orgCourseGroupList) {
                if (tempGrids.size() >= BizConf.MAX_COURSE_GROUP) break;
                if (!existGrids.containsKey(group.getId())) {
                    DefaultTemplateDataList item = new DefaultTemplateDataList();
                    item.setCourseGroupId(group.getId());
                    item.setName(group.getName());
                    tempGrids.add(item);
                    continue;
                }
                tempGrids.add(existGrids.get(group.getId()));
            }
        }
        logger.info("####################### tempGrids:{}", (Object)tempGrids);
        return tempGrids;
    }

    private List<DefaultTemplateDataList> getOrgCourseSubjects(Integer orgId, Integer number, String monkeySiteHost) {
        List orgCourseGroupList = this.orgCourseGroupDao.getOrgCourseGroupList(orgId);
        ArrayList gridList = Lists.newArrayList();
        String link = this.getLink("{host}/org/course/{number}", number, monkeySiteHost);
        DefaultTemplateDataList item = null;
        if (orgCourseGroupList != null && !orgCourseGroupList.isEmpty()) {
            for (OrgCourseGroup courseGroup : orgCourseGroupList) {
                boolean valid = this.isValidSubject(number, courseGroup.getId(), CourseType.CLASS.getCode());
                if (!valid) {
                    valid = this.isValidSubject(number, courseGroup.getId(), CourseType.ORG_COURSE.getCode());
                }
                if (valid) {
                    item = new DefaultTemplateDataList();
                    item.setLink(link);
                    item.setName(courseGroup.getName());
                    item.setCourseGroupId(courseGroup.getId());
                    gridList.add(item);
                }
                if (gridList.size() != BizConf.MAX_COURSE_GROUP.intValue()) continue;
                break;
            }
        }
        gridList.add(new DefaultTemplateDataList("\u540d\u5e08\u63a8\u8350", this.getLink("{host}/org/teacher/{number}", number, monkeySiteHost)));
        gridList.add(new DefaultTemplateDataList("\u5b66\u5458\u8bc4\u4ef7", this.getLink("{host}/org/comment/{number}", number, monkeySiteHost)));
        gridList.add(new DefaultTemplateDataList("\u6821\u533a\u67e5\u8be2", this.getLink("{host}/org/area/{number}", number, monkeySiteHost)));
        return gridList;
    }

    private boolean isValidSubject(Integer orgNumber, Integer courseGroupId, Integer courseType) {
        int count = 0;
        List courseIds = this.orgCourseGroupRelateDao.getCourseIdsByGroup(courseGroupId, courseType);
        if (courseIds != null && !courseIds.isEmpty()) {
            if (courseType.intValue() == CourseType.CLASS.getCode()) {
                count = this.teacherClassCourseDao.getValidClassCourseCountByIds(orgNumber, (Collection)courseIds);
            } else if (courseType.intValue() == CourseType.ORG_COURSE.getCode()) {
                count = this.orgCourseDao.getValidOrgCourseCount(orgNumber, (Collection)courseIds);
            }
        }
        return count > 0;
    }

    private String getLink(String url, Integer number, String monkeySizeHost) {
        return url.replaceAll("\\{host\\}", monkeySizeHost).replaceAll("\\{number\\}", number.toString());
    }

    private List<OrgRecommendCourseList> getAndSetRecommentCourseList(Integer orgId, OptionalParams params) {
        List recommendCourses = this.orgRecommendCourseDao.getRecommendCourseList(orgId);
        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        ArrayList data = Lists.newArrayList();
        if (recommendCourses != null && !recommendCourses.isEmpty()) {
            OrgRecommendCourseList subData = null;
            for (OrgRecommendCourse course : recommendCourses) {
                Storage storage;
                TeacherClassCourse po;
                Integer courseId = course.getCourseid();
                Integer courseType = course.getCourseType();
                subData = new OrgRecommendCourseList();
                if (courseType.intValue() == CourseType.CLASS.getCode()) {
                    po = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)courseId, new String[0]);
                    if (po.getStatus().intValue() != TeacherClassCourseStatus.ENROLLING.getStatus() || po.getBeginTime().getTime() <= System.currentTimeMillis()) continue;
                    subData.setCourseType(courseType);
                    subData.setName(po.getName());
                    subData.setNumber(po.getNumber());
                    subData.setPrice(po.getPrice().toString());
                    subData.setPreface("");
                    subData.setCourseId(po.getId());
                    if (po.getCover() != null) {
                        storage = this.getClassCourseStorage(po.getCover());
                        subData.setPreface(this.constructUrl(storage, imgServer));
                    }
                    subData.setLink("{host}/teacher/classCourseDetail/{number}".replace("{host}", monkeySite).replace("{number}", po.getNumber().toString()));
                    data.add(subData);
                    continue;
                }
                if (courseType.intValue() != CourseType.ORG_COURSE.getCode() || (po = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])).getStatus().intValue() != OrgCourseStatus.IN_PROGRESS.getCode()) continue;
                subData.setCourseType(courseType);
                subData.setName(po.getName());
                subData.setNumber(po.getNumber());
                subData.setPrice(po.getPrice().toString());
                subData.setPreface("");
                subData.setCourseId(po.getId());
                if (po.getCover() != null && (storage = (Storage)this.storageDao.getById((Serializable)po.getCover(), new String[0])) != null) {
                    subData.setPreface(this.constructUrl(storage, imgServer));
                }
                subData.setLink("{host}/org_class_course/detail/{number}".replace("{host}", monkeySite).replace("{number}", po.getNumber().toString()));
                data.add(subData);
            }
        }
        return data;
    }

    private Map<Long, OrgCourse> getAndCacheOrgCourseInfo(List<OrgRecommendCourse> recommendCourses) {
        ArrayList orgCourseIds = Lists.newArrayList();
        for (OrgRecommendCourse course : recommendCourses) {
            Long courseId = course.getCourseid().longValue();
            Integer courseType = course.getCourseType();
            if (courseType.intValue() != CourseType.ORG_COURSE.getCode()) continue;
            orgCourseIds.add(courseId);
        }
        return this.getOrgCourseCache(orgCourseIds);
    }

    private Map<Long, TeacherClassCourse> getAndCacheClassCourseInfo(List<OrgRecommendCourse> recommendCourses) {
        ArrayList classCourseIds = Lists.newArrayList();
        for (OrgRecommendCourse course : recommendCourses) {
            Long courseId = course.getCourseid().longValue();
            Integer courseType = course.getCourseType();
            if (courseType.intValue() != CourseType.CLASS.getCode()) continue;
            classCourseIds.add(courseId);
        }
        return this.getClassCourseCache(classCourseIds);
    }

    private Map<Long, OrgCourse> getOrgCourseCache(List<Long> ids) {
        return this.orgCourseDao.getOrgCourseMap(ids);
    }

    private Map<Long, TeacherClassCourse> getClassCourseCache(List<Long> ids) {
        return this.teacherClassCourseDao.getTeacherClassCourses(ids);
    }

    private List<String> getOrgCourseSubject(Integer orgId, Integer number, int limit) {
        List<String> subjects = this.getOrgCustomClassfication(orgId);
        logger.info("getOrgCourseSubject.orgId:{}, number:{}, limit:{}, subjects:{}", new Object[]{orgId, number, limit, subjects});
        return subjects;
    }

    private <T> Collection<Long> getPropertiesVals(List<T> objs, CourseType courseType, String cType, String courseId) {
        HashSet excludeIds = Sets.newHashSet();
        switch (courseType) {
            case CLASS: {
                for (T obj : objs) {
                    Integer type = (Integer)BaseUtils.getValue(obj, (String)cType);
                    if (type.intValue() != CourseType.CLASS.getCode()) continue;
                    excludeIds.add((Long)BaseUtils.getValue(obj, (String)courseId));
                }
                break;
            }
            case ORG_COURSE: {
                for (T obj : objs) {
                    Integer type = (Integer)BaseUtils.getValue(obj, (String)cType);
                    if (type.intValue() != CourseType.ORG_COURSE.getCode()) continue;
                    excludeIds.add((Long)BaseUtils.getValue(obj, (String)courseId));
                }
                break;
            }
        }
        return excludeIds;
    }

    private List<OrgHotCourseDto> getOrgHotCourseList(Integer orgNumber, List<DefaultTemplateDataList> grids, String imgServer, String monkeySite, Boolean readOnly) {
        ArrayList result = Lists.newArrayList();
        ArrayList subResult = null;
        OrgHotCourseDto subItem = null;
        for (DefaultTemplateDataList grid : grids) {
            List orgCourseIds;
            subItem = new OrgHotCourseDto();
            Integer courseGroupId = grid.getCourseGroupId();
            if (courseGroupId == null) continue;
            subItem.setGroupId(courseGroupId);
            List ids = this.orgCourseGroupRelateDao.getCourseIdsByGroup(courseGroupId, Integer.valueOf(CourseType.CLASS.getCode()));
            subResult = Lists.newArrayList();
            if (ids != null && !ids.isEmpty()) {
                subResult.addAll(this.getHotClassCourse(ids, imgServer, monkeySite));
            }
            if ((orgCourseIds = this.orgCourseGroupRelateDao.getCourseIdsByGroup(courseGroupId, Integer.valueOf(CourseType.ORG_COURSE.getCode()))) != null && !orgCourseIds.isEmpty()) {
                subResult.addAll(this.getHotOrgCourse(orgCourseIds, imgServer, monkeySite));
            }
            subItem.setName(grid.getName());
            if (subResult != null && !subResult.isEmpty()) {
                if (readOnly.booleanValue()) {
                    if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY) {
                        subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY));
                        result.add(subItem);
                    } else {
                        if (subResult.size() < BizConf.MAX_COURSE_DISPLAY / 2 || subResult.size() >= BizConf.MAX_COURSE_DISPLAY) continue;
                        subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY / 2));
                        result.add(subItem);
                    }
                } else if (subResult.size() >= BizConf.MAX_COURSE_DISPLAY) {
                    subItem.setList(subResult.subList(0, BizConf.MAX_COURSE_DISPLAY));
                    result.add(subItem);
                } else {
                    subItem.setList(subResult);
                    result.add(subItem);
                }
            } else {
                if (readOnly.booleanValue()) continue;
                result.add(subItem);
            }
            logger.info("<<<<------------------------------->>>>");
            logger.info("orgNumber:{}, courseGroupId:{}, ids:{}, orgCourseIds:{}, subResult:{}, result:{}", new Object[]{orgNumber, courseGroupId, ids, orgCourseIds, JSONArray.fromObject((Object)subResult).toString(), JSONArray.fromObject((Object)result).toString()});
            logger.info("<<<<------------------------------->>>>");
        }
        return result;
    }

    private List<OrgRecommendCourseList> getOrgHotCourseList(Integer orgId, Integer number, OptionalParams params) {
        OrgRecommendCourseList dto;
        int size;
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        ArrayList courses = Lists.newArrayList();
        List<OrgCourseGroupRelate> recommendCourseLists = this.getOrgCustomGroupCourse(orgId, pageDto);
        List<Object> classCourses = Lists.newArrayList();
        List<Object> orgCourses = Lists.newArrayList();
        if (recommendCourseLists != null && !recommendCourseLists.isEmpty()) {
            size = recommendCourseLists.size();
            if (BizConf.MAX_SUBJECT_DISPLAY > size) {
                pageDto.setPageSize(Integer.valueOf(BizConf.MAX_SUBJECT_DISPLAY - size));
                classCourses = this.getOrgTeacherClassCourseList(number, this.getPropertiesVals(recommendCourseLists, CourseType.CLASS, "courseType", "courseId"), pageDto);
                if (BizConf.MAX_SUBJECT_DISPLAY > size + classCourses.size()) {
                    orgCourses = this.getOrgCourseList(number, this.getPropertiesVals(recommendCourseLists, CourseType.ORG_COURSE, "courseType", "courseId"), pageDto);
                }
            }
        } else {
            pageDto.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
            classCourses = this.getOrgTeacherClassCourseList(number, null, pageDto);
            size = classCourses.size();
            if (classCourses != null && !classCourses.isEmpty() && BizConf.MAX_SUBJECT_DISPLAY > size) {
                pageDto.setPageSize(Integer.valueOf(BizConf.MAX_SUBJECT_DISPLAY - size));
                orgCourses = this.getOrgCourseList(number, null, pageDto);
            }
        }
        if (recommendCourseLists != null && !recommendCourseLists.isEmpty()) {
            for (OrgCourseGroupRelate orgCourseGroupRelate : recommendCourseLists) {
                dto = null;
                if (orgCourseGroupRelate.getCourseType().intValue() == CourseType.ORG_COURSE.getCode()) {
                    dto = this.getHotOrgCourse(orgCourseGroupRelate.getCourseId(), imgServer, monkeySite);
                } else if (orgCourseGroupRelate.getCourseType().intValue() == CourseType.CLASS.getCode()) {
                    dto = this.getHotClassCourse(orgCourseGroupRelate.getCourseId(), imgServer, monkeySite);
                }
                if (dto == null) continue;
                courses.add(dto);
            }
        }
        if (classCourses != null && !classCourses.isEmpty()) {
            for (TeacherClassCourse teacherClassCourse : classCourses) {
                dto = this.getHotClassCourse(teacherClassCourse.getId(), imgServer, monkeySite);
                if (dto == null) continue;
                courses.add(dto);
            }
        }
        if (orgCourses != null && !orgCourses.isEmpty()) {
            for (OrgCourse orgCourse : orgCourses) {
                dto = this.getHotOrgCourse(orgCourse.getId(), imgServer, monkeySite);
                if (dto == null) continue;
                courses.add(dto);
            }
        }
        return courses;
    }

    private OrgRecommendCourseList getHotOrgCourse(Long courseId, String imgServer, String monkeySite) {
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        OrgRecommendCourseList dto = null;
        if (orgCourse != null && orgCourse.getStatus().intValue() == OrgCourseStatus.IN_PROGRESS.getCode()) {
            Storage storage;
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setName(orgCourse.getName());
            dto.setNumber(orgCourse.getNumber());
            dto.setPrice(orgCourse.getPrice().toString());
            dto.setCourseId(orgCourse.getId());
            Integer cover = orgCourse.getCover();
            if (cover != null && (storage = this.getStorage(cover.longValue())) != null) {
                String url = this.constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink("{host}/org_class_course/detail/{number}".replace("{host}", monkeySite).replace("{number}", orgCourse.getNumber().toString()));
        }
        return dto;
    }

    private OrgRecommendCourseList getHotClassCourse(Long courseId, String imgServer, String monkeySite) {
        TeacherClassCourse classCourse = (TeacherClassCourse)this.teacherClassCourseDao.getById((Serializable)courseId, new String[0]);
        OrgRecommendCourseList dto = null;
        if (classCourse != null && classCourse.getStatus().intValue() == ClassCourseStatus.ENROLLING.getState() && classCourse.getBeginTime().getTime() > System.currentTimeMillis()) {
            dto = new OrgRecommendCourseList();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(classCourse.getName());
            dto.setNumber(classCourse.getNumber());
            dto.setPrice(classCourse.getPrice().toString());
            dto.setCourseId(classCourse.getId());
            Long cover = classCourse.getCover();
            if (cover != null) {
                Storage storage = this.getClassCourseStorage((long)cover);
                String url = this.constructUrl(storage, imgServer);
                dto.setPreface(url);
            }
            dto.setLink("{host}/teacher/classCourseDetail/{number}".replace("{host}", monkeySite).replace("{number}", classCourse.getNumber().toString()));
        }
        return dto;
    }

    private List<OrgRecommendCourseList> getHotClassCourse(List<Long> courseIds, String imgServer, String monkeySite) {
        ArrayList result = Lists.newArrayList();
        if (courseIds != null && !courseIds.isEmpty()) {
            for (Long courseId : courseIds) {
                OrgRecommendCourseList ret = this.getHotClassCourse(courseId, imgServer, monkeySite);
                if (ret == null) continue;
                result.add(ret);
            }
        }
        return result;
    }

    private List<OrgRecommendCourseList> getHotOrgCourse(List<Long> courseIds, String imgServer, String monkeySite) {
        ArrayList result = Lists.newArrayList();
        if (courseIds != null && !courseIds.isEmpty()) {
            for (Long courseId : courseIds) {
                OrgRecommendCourseList ret = this.getHotOrgCourse(courseId, imgServer, monkeySite);
                if (ret == null) continue;
                result.add(ret);
            }
        }
        return result;
    }

    private List<OrgCourseGroupRelate> getOrgCustomGroupCourse(Integer orgId, PageDto pageDto) {
        return this.orgCourseGroupRelateDao.getOrgCourseGroup(orgId, pageDto);
    }

    private List<TeacherClassCourse> getOrgTeacherClassCourseList(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto) {
        return this.teacherClassCourseDao.getOrgCourseList(orgNumber, excludeIds, pageDto);
    }

    private List<OrgCourse> getOrgCourseList(Integer orgNumber, Collection<Long> excludeIds, PageDto pageDto) {
        return this.orgCourseDao.getAndFilterOrgCourse(orgNumber, excludeIds, pageDto);
    }

    public List<DefaultTemplateDataList> getCourseSubjects(List<String> subjects, int limit, OrgBaseInfoModel model, OptionalParams params) {
        ArrayList data = Lists.newArrayList();
        DefaultTemplateDataList item = null;
        String courseUrl = "{host}/org/course/{number}".replace("{host}", params.getMonkeySiteHost()).replace("{number}", model.getNumber().toString());
        if (subjects != null && !subjects.isEmpty()) {
            int index = 0;
            for (String name : subjects) {
                item = new DefaultTemplateDataList();
                item.setName(name);
                item.setLink(courseUrl);
                data.add(item);
                if (++index != limit) continue;
                break;
            }
        } else {
            int index = 1;
            for (String link : BizConf.PHOTO_LINKS) {
                item = new DefaultTemplateDataList();
                item.setLink(courseUrl);
                item.setName("\u5206\u7c7b" + index);
                data.add(item);
                ++index;
            }
        }
        return data;
    }

    private Set<String> getClassCourseAndOrgCourseSubjects(Integer number) {
        List<Integer> classCourseSubjectIds = this.getTeacherClassCourseSubjects(number);
        List<Integer> orgCourseSubjectIds = this.getOrgCourseSubjects(number);
        HashSet result = Sets.newHashSet();
        HashSet subjectIds = Sets.newHashSet();
        subjectIds.addAll(classCourseSubjectIds);
        subjectIds.addAll(orgCourseSubjectIds);
        if (subjectIds != null && !subjectIds.isEmpty()) {
            List subLists = this.subjectDao.getSubjectNames((Collection)subjectIds, "name");
            result.addAll(subLists);
        }
        return result;
    }

    private List<String> getOrgCustomClassfication(Integer orgId) {
        PageDto page = new PageDto();
        page.setPageSize(BizConf.MAX_SUBJECT_DISPLAY);
        return this.orgCourseGroupDao.getDistinctSubject(orgId, page);
    }

    private List<Integer> getOrgCourseSubjects(Integer number) {
        return this.orgCourseDao.getOrgCourseSubjectIds(number);
    }

    private List<Integer> getTeacherClassCourseSubjects(Integer number) {
        return this.teacherClassCourseDao.getOrgDistinctSubject(number);
    }

    Storage getClassCourseStorage(Long storageId) {
        ClassCoursePhoto cover = (ClassCoursePhoto)this.classCoursePhotoDao.getById((Serializable)storageId, new String[0]);
        return (Storage)this.storageDao.getById((Serializable)cover.getStorageId(), new String[0]);
    }

    Storage getStorage(Long storageId) {
        return (Storage)this.storageDao.getById((Serializable)storageId, new String[0]);
    }

    private JSONObject wrapperAbroadTemplate(Integer orgId, String content, OptionalParams params) {
        OrgBaseInfoModel model = this.getAndSetOrgInfoModel(orgId, params);
        JSONObject abroadJson = JSONObject.fromObject((Object)content);
        abroadJson.put((Object)"orgInfo", (Object)JSONObject.fromObject((Object)((Object)model)));
        return abroadJson;
    }

    private void getAndSetOrgNumber(Integer orgId, OrgBaseInfoModel model, String host) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
        model.setNumber(orgAccount.getNumber());
        model.setDomain(host + "/i/" + model.getNumber());
        this.getAndSetOrgInfo(orgId, model);
        this.getAndSetOrgCourse(orgAccount.getNumber(), model);
    }

    private void getAndSetOrgInfo(Integer orgId, OrgBaseInfoModel model) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        if (orgInfo != null) {
            String _400_phone = orgInfo.getExtension();
            if (StringUtils.isNotBlank((CharSequence)_400_phone)) {
                model.setExtension("4000122166," + orgInfo.getExtension());
            } else {
                model.setExtension("4000122166");
            }
        } else {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
        model.setId(orgId);
        model.setShortName(orgInfo.getShortName());
    }

    private void getAndSetSummary(Integer orgId, OrgBaseInfoModel model) {
        OrgTxtMsg summary = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.SUMMARY.getValue());
        if (summary != null) {
            model.setBrief(summary.getValue());
        }
    }

    private void getAndSetAddress(Integer orgId, OrgBaseInfoModel model) {
        List branchs = this.orgBranchsDao.listBranchsByOrgId(orgId.intValue());
        if (branchs != null && !branchs.isEmpty()) {
            OrgBranchs branch = (OrgBranchs)branchs.get(0);
            if (branch != null) {
                branch.setProvince(branch.getProvince() == null ? "" : branch.getProvince());
                branch.setCounty(branch.getCounty() == null ? "" : branch.getCounty());
                branch.setDistrict(branch.getDistrict() == null ? "" : branch.getDistrict());
                branch.setAddress(branch.getAddress() == null ? "" : branch.getAddress());
                model.setAddress(branch.getProvince() + branch.getCounty() + branch.getDistrict() + branch.getAddress());
            } else {
                model.setAddress("");
            }
        } else {
            model.setAddress("");
        }
    }

    private void getAndSetTags(Integer orgId, OrgBaseInfoModel model) {
        String value;
        OrgTxtMsg tags = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.TAGS.getValue());
        if (tags != null && StringUtils.isNotBlank((CharSequence)(value = tags.getValue()))) {
            model.setTags(value.split("\\s+"));
        }
    }

    private void getAndSetOrgLogo(Integer orgId, OrgBaseInfoModel model, String imgServer) {
        List imgs = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), OrgImgType.ORG_LOGO.getValue());
        logger.info("getAndSetOrgLogo.orgId:{}, imgServer:{}, logogs:{}", new Object[]{orgId, imgServer, JSONArray.fromObject((Object)imgs).toString()});
        if (imgs != null && !imgs.isEmpty()) {
            OrgPhoto logo = (OrgPhoto)imgs.get(0);
            Integer storageId = logo.getOrgStorageId();
            OrgStorage storage = this.orgStorageDao.getById(storageId.intValue());
            if (storage != null) {
                model.setLogo(this.constructUrl(storage, imgServer));
            }
        } else {
            model.setLogo("http://www.genshuixue.com/asset/img/org/logo.jpg");
        }
    }

    private void getAndSetOrgCourse(Integer orgNumber, OrgBaseInfoModel model) {
        int classCourseCount = this.teacherClassCourseDao.getVliadClassCourseCount(orgNumber);
        int microCourseCount = this.orgCourseDao.getValidOrgCourseCount(orgNumber);
        model.setCourseCount(classCourseCount + microCourseCount);
    }

    public String constructUrl(OrgStorage storage, String imgServer) {
        logger.info("storage =={}", (Object)storage);
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = MIMEType.values()[storage.getMimeType() - 1].getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (StringUtils.isNotBlank((CharSequence)storage.getMimetype())) {
            surfix = storage.getMimetype().contains("/") ? storage.getMimetype().split("/")[1] : storage.getMimetype();
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    private List<DefaultTemplateDataList> getAboutUsLinks(Integer number, String monkeySiteHost) {
        DefaultTemplateDataList[] list = new DefaultTemplateDataList[]{new DefaultTemplateDataList("\u5173\u4e8e\u6211\u4eec", this.getRealAddress("{host}/org/intro/{number}", monkeySiteHost, number.toString())), new DefaultTemplateDataList("\u6700\u65b0\u8bfe\u7a0b", this.getRealAddress("{host}/org/course/{number}", monkeySiteHost, number.toString())), new DefaultTemplateDataList("\u8001\u5e08\u56e2\u961f", this.getRealAddress("{host}/org/teacher/{number}", monkeySiteHost, number.toString())), new DefaultTemplateDataList("\u5728\u7ebf\u9884\u7ea6", "javascript:;"), new DefaultTemplateDataList("\u5b66\u5458\u4e4b\u58f0", this.getRealAddress("{host}/org/comment/{number}", monkeySiteHost, number.toString())), new DefaultTemplateDataList("\u4f18\u60e0\u6d3b\u52a8", this.getRealAddress("{host}/org/couponList?number={number}", monkeySiteHost, number.toString()))};
        return Arrays.asList(list);
    }

    private String getRealAddress(String source, String monkeySiteHost, String number) {
        return source.replace("{host}", monkeySiteHost).replace("{number}", number);
    }

    @Override
    public OrgBaseInfoModel preview(Integer orgId, OptionalParams params) {
        return this.getAndSetOrgInfoModel(orgId, params);
    }

    private List<OrgRecommendCourseList> convertToKaixue(OptionalParams params, List<OrgTemplateCourse> list, boolean readonly) {
        String imgServer = params.getImgServer();
        String monkeySite = params.getMonkeySiteHost();
        ArrayList result = Lists.newArrayList();
        for (OrgTemplateCourse templateCourse : list) {
            OrgRecommendCourseList dto;
            if (templateCourse.getCourseType().intValue() == CourseType.CLASS.getCode()) {
                dto = this.getHotClassCourse((long)templateCourse.getCourseId(), imgServer, monkeySite);
                if (dto == null) continue;
                result.add(dto);
                continue;
            }
            if (templateCourse.getCourseType().intValue() != CourseType.ORG_COURSE.getCode() || (dto = this.getHotOrgCourse((long)templateCourse.getCourseId(), imgServer, monkeySite)) == null) continue;
            result.add(dto);
        }
        if (readonly && (result.size() == 1 || result.size() == 3)) {
            result.remove(list.size() - 1);
        }
        logger.info("convertToKaixue ==params={},result={}", (Object)params, (Object)result);
        return result;
    }
}

