/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.service.OrgHomepageConfigService;
import java.io.Serializable;
import java.sql.Timestamp;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgHomepageConfigServiceImpl
implements OrgHomepageConfigService {
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTemplate(Integer orgId, Integer templateId, String content) {
        if (!this.doBefore(orgId)) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
        OrgHomepageConfig conf = new OrgHomepageConfig();
        conf.setContent(content);
        conf.setOrgId(orgId);
        conf.setTemplateId(templateId);
        conf.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.orgHomepageConfigDao.save((Object)conf, Boolean.valueOf(false), new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editTemplate(Integer orgId, Integer templateId, String content, String type) throws BussinessException {
        if (this.doBefore(orgId)) {
            OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)templateId, new String[0]);
            if (template != null) {
                if ("scheme".equals(type)) {
                    this.setScheme(orgId, template);
                } else if ("theme".equals(type)) {
                    this.setTheme(orgId, template, content);
                } else if ("config".equals(type)) {
                    this.setConfig(orgId, template, content);
                }
            }
        } else {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
    }

    void setScheme(Integer orgId, OrgHomepageTemplate template) {
        OrgHomepageConfig conf = this.orgHomepageConfigDao.getTemplateConf(orgId, template.getId());
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        if (usingTemplate != null) {
            usingTemplate.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            usingTemplate.setStatus(Integer.valueOf(TemplateStatus.UNUSED.getCode()));
            this.orgHomepageConfigDao.update((Object)usingTemplate, new String[0]);
        }
        if (conf != null) {
            conf.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            conf.setStatus(Integer.valueOf(TemplateStatus.USING.getCode()));
            this.orgHomepageConfigDao.update((Object)conf, Boolean.valueOf(false), new String[]{"content", "status", "updateTime"});
        } else {
            conf = new OrgHomepageConfig();
            conf.setCreateTime(new Timestamp(System.currentTimeMillis()));
            conf.setOrgId(orgId);
            conf.setTemplateId(template.getId());
            conf.setContent(JSONObject.fromObject((Object)template.getContent()).getJSONObject("config").toString());
            conf.setStatus(Integer.valueOf(TemplateStatus.USING.getCode()));
            this.orgHomepageConfigDao.save((Object)conf, Boolean.valueOf(false), new String[]{"createTime", "orgId", "templateId", "content", "status"});
        }
    }

    void setTheme(Integer orgId, OrgHomepageTemplate template, String theme) {
        OrgHomepageConfig conf = this.orgHomepageConfigDao.getTemplateConf(orgId, template.getId());
        if (conf != null && conf.getStatus().intValue() == TemplateStatus.USING.getCode()) {
            String content = conf.getContent();
            JSONObject json = JSONObject.fromObject((Object)content);
            json.put((Object)"theme", (Object)theme);
            conf.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            conf.setContent(json.toString());
            this.orgHomepageConfigDao.update((Object)conf, Boolean.valueOf(false), new String[]{"updateTime", "content"});
        }
    }

    void setConfig(Integer orgId, OrgHomepageTemplate template, String config) {
        this.setScheme(orgId, template);
        OrgHomepageConfig conf = this.orgHomepageConfigDao.getTemplateConf(orgId, template.getId());
        if (conf != null && conf.getStatus().intValue() == TemplateStatus.USING.getCode()) {
            conf.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            conf.setContent(config);
            this.orgHomepageConfigDao.update((Object)conf, Boolean.valueOf(false), new String[]{"updateTime", "content"});
        }
    }

    @Override
    public OrgHomepageConfig getUsingTemplate(Integer orgId) {
        return this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
    }

    private boolean doBefore(Integer orgId) {
        return this.orgAccountDao.getById((Serializable)orgId, new String[0]) != null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearTemplateConfig(Integer orgId) {
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        if (usingTemplate != null) {
            usingTemplate.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            usingTemplate.setStatus(Integer.valueOf(TemplateStatus.UNUSED.getCode()));
            this.orgHomepageConfigDao.update((Object)usingTemplate, Boolean.valueOf(false), new String[]{"status", "updateTime"});
        }
    }
}

