/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.blackboard.dao.OrgBlackboardDao;
import com.baijia.tianxiao.dal.blackboard.po.Blackboard;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.enums.BlackBoardType;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBlackboardResponseDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgBlackboardService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgBlackboardServiceImpl
implements OrgBlackboardService {
    @Autowired
    private OrgBlackboardDao orgBlackboardDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    public List<OrgBlackboardResponseDto> getOrgBlackboardList(Long orgId, PageDto pageDto) {
        List blackboards = this.orgBlackboardDao.getOrgBlackboardList(orgId, pageDto, new String[0]);
        ArrayList data = Lists.newArrayList();
        if (blackboards != null && !blackboards.isEmpty()) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            for (Blackboard blackboard : blackboards) {
                OrgBlackboardResponseDto dto = this.copyFrom(blackboard, host, imgServer);
                if (dto == null) continue;
                data.add(dto);
            }
        }
        return data;
    }

    private OrgBlackboardResponseDto copyFrom(Blackboard blackboard, String host, String imgServer) {
        OrgBlackboardResponseDto dto = new OrgBlackboardResponseDto();
        Long id = blackboard.getId();
        dto.setActivityId(id);
        dto.setName(blackboard.getTitle());
        int type = blackboard.getBbType();
        dto.setTypeId(type);
        dto.setType(BlackBoardType.values()[type].getLabel());
        if (BlackBoardType.NOTICE.getType() == type) {
            dto.setLink("{host}/org/blackDetail?board_id={id}".replace("{host}", host).replace("{id}", id.toString()));
        } else {
            dto.setLink("{host}/org/activityDetail?board_id={id}".replace("{host}", host).replace("{id}", id.toString()));
        }
        int storageId = blackboard.getStorageId();
        OrgStorage storage = this.orgStorageDao.getById(storageId);
        if (storage != null) {
            dto.setUrl(OrgBlackboardServiceImpl.constructUrl(storage, imgServer));
        }
        return dto;
    }

    public static String constructUrl(OrgStorage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = MIMEType.values()[storage.getMimeType() - 1].getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    public OrgBlackboardResponseDto getOrgBlackboardDetail(Long orgId, Long id) {
        Blackboard blackboard = (Blackboard)this.orgBlackboardDao.getById((Serializable)id, new String[0]);
        OrgBlackboardResponseDto dto = null;
        if (blackboard != null) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            String imgServer = PropertiesReader.getValue((String)"wxm", (String)"img.server");
            dto = this.copyFrom(blackboard, host, imgServer);
        }
        return dto;
    }
}

