package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.sal.organization.todo.service.impl.TxBacklogServiceImpl;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.organization.utils.ExpressionPointcut;
import com.baijia.tianxiao.sal.organization.utils.MethodMatcher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Jun 15, 2016 9:41:07 AM
 * @desc :
 */
@Slf4j
public enum RequestSourceDesc implements MethodMatcher {

    COURSE_LIST("用于限制账户展示的课程") {

    },
    BACK_LOG_LIST("用于待办事项列表展示") {

    },
    CONSULT_LIST("用于限制线索数据的查询") {

    },
    STUDENT_LIST("用于限制学员数据的查询") {

    };

    private ThreadLocal<AccountRoleType> threadLocalRoleType = new ThreadLocal<>();
    protected TreeSet<String> sourcePaths = new TreeSet<>();
    public final String desc;

    private final List<RoleType> DEFAULT_ROLE_TYPES =
        Arrays.asList(RoleType.PRESIDENT, RoleType.BRANCH_SCH_PRESIDENT, RoleType.CHARAGE);

    protected Set<RoleType> canAccessRoleTypes = new HashSet<RoleType>();
    private Set<ClassAndMethod> hashCache = new HashSet<>();

    private RequestSourceDesc(String desc) {
        this.desc = desc;
        this.initRoleTypes();
        this.initSourcePath();
    }

    // 初始化能访问资源的角色
    protected void initRoleTypes() {
        this.canAccessRoleTypes.addAll(DEFAULT_ROLE_TYPES);
    }

    // 初始化对应的资源路径
    protected void initSourcePath() {
    }

    public boolean matches(Method method, Class<?> targetClass) {

        if (!this.hashCache.contains(new ClassAndMethod(targetClass, method))) {
            DataAuthority daForClass = targetClass.getAnnotation(DataAuthority.class);
            if (daForClass != null) {
                boolean canExecuteMatch = requestSourceCanMatch(daForClass);
                if (canExecuteMatch) {
                    generateSourcePath(targetClass, method);
                }
            }
            if (method != null) {
                DataAuthority daForMethod = method.getAnnotation(DataAuthority.class);
                if (daForMethod == null) {
                    method = null;
                } else {
                    boolean canMatcnMethod = this.requestSourceCanMatch(daForMethod);
                    if (!canMatcnMethod) {
                        return false;
                    } else {
                        generateSourcePath(targetClass, method);
                    }
                }
            }
        } else {
            System.out.println("targetClass and method has already init ");
        }

        if (GenericsUtils.isNullOrEmpty(this.sourcePaths)) {
            return false;
        }

        @SuppressWarnings("unchecked")
        TreeSet<String> copier = (TreeSet<String>) this.sourcePaths.clone();
        Iterator<String> descendingIterator = copier.descendingIterator();
        while (descendingIterator.hasNext()) {
            ExpressionPointcut ep = new ExpressionPointcut();
            String expression = descendingIterator.next();
            ep.setExpression(expression);
            System.out.println(expression);
            boolean matchTargetClass = ep.matches(targetClass);
            if (matchTargetClass) {
                if (method != null) {
                    boolean matchMethod = ep.matches(method, targetClass);
                    if (matchMethod) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean requestSourceCanMatch(DataAuthority daForClass) {
        if (daForClass == null) {
            return false;
        }
        List<RequestSourceDesc> rsds = new ArrayList<>(Arrays.asList(daForClass.resourceTypes()));
        return rsds.contains(this);
    }

    private void generateSourcePath(Class<?> targetClass, Method method) {
        boolean methodIsNull = method == null;
        String modifiersStr = "*";
        String methodMatchStr = "*(..)";
        String methodReturnType = "";
        if (!methodIsNull) {
            StringBuilder methodMatchBuilder = new StringBuilder();
            int modifiers = method.getModifiers();
            modifiersStr = Modifier.toString(modifiers);
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            methodMatchBuilder.append(methodName);
            if (GenericsUtils.notNullAndEmpty(parameterTypes)) {
                methodMatchBuilder.append("(");
                int i = 0;
                for (Class<?> paramClass : parameterTypes) {
                    methodMatchBuilder.append(paramClass.getName());
                    if (i != parameterTypes.length - 1) {
                        methodMatchBuilder.append(",");
                    }
                    i++;
                }
                methodMatchBuilder.append(")");
            } else {
                methodMatchBuilder.append("(..)");
            }
            methodMatchStr = methodMatchBuilder.toString();
            methodReturnType = method.getReturnType().getName();
        }
        String classPath = targetClass.getName();
        StringBuilder sb = new StringBuilder("execution(").append(modifiersStr).append(" ").append(methodReturnType)
            .append(" ").append(classPath).append(".").append(methodMatchStr).append(")");
        System.out.println("sb.toString : " + sb.toString());
        hashCache.add(new ClassAndMethod(targetClass, method));
        this.sourcePaths.add(sb.toString());
    }

    public boolean canAccess(Method method, Class<?> targetClass, RoleType roleType) {
        boolean canAccess = false;
        if (this.matches(method, targetClass)) {
            canAccess = this.canAccessRoleTypes.contains(roleType);
            canAccess = this.subAccessJudge(canAccess, roleType); // 在能够匹配的上之后，加上子类型的单独判断
        }
        return canAccess;
    }

    protected boolean subAccessJudge(boolean canAccess, RoleType roleType) {
        return canAccess;
    }

    public boolean canAccess(String methodName, Class<?> className, RoleType roleType, Class<?>...paramerTypes) {
        Method method = null;
        try {
            if (GenericsUtils.isNullOrEmpty(paramerTypes)) {
                paramerTypes = new Class<?>[0];
            }
            method = className.getDeclaredMethod(methodName, paramerTypes);
        } catch (NoSuchMethodException | SecurityException e) {
            System.out.println("can not find declarredMathod : " + methodName);
            return false;
        }
        boolean canAccess = this.canAccess(method, className, roleType);
        log.info(
            "current account going to visit method or class : {}.{} with roleType : {} ,and result permission is : {}",
            className.getName(), methodName, roleType, canAccess);
        return canAccess;
    }

    public boolean canAccess(String methodName, Class<?> className, Class<?>...paramerTypes) {
        AccountRoleType accountRoleType = this.threadLocalRoleType.get();
        if (accountRoleType == null) {
            // 如果没有地方设置了该值，说明不需要控制
            return true;
        }
        return this.canAccess(methodName, className, accountRoleType.getRoleType(), paramerTypes);
    }

    public void setAccountRoleType(AccountRoleType roleType) {
        this.threadLocalRoleType.set(roleType);
    }

    public void removeAccountRoleType() {
        this.threadLocalRoleType.remove();
    }

    public AccountRoleType getAccountRoleType() {
        return this.threadLocalRoleType.get();
    }

    static class ClassAndMethod {
        private Class<?> clazz;
        private Method method;

        public ClassAndMethod(Class<?> targetClass, Method method) {
            this.clazz = targetClass;
            this.method = method;
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((clazz == null) ? 0 : clazz.hashCode());
            result = prime * result + ((method == null) ? 0 : method.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            ClassAndMethod other = (ClassAndMethod) obj;
            if (clazz == null) {
                if (other.clazz != null)
                    return false;
            } else if (!clazz.equals(other.clazz))
                return false;
            if (method == null) {
                if (other.method != null)
                    return false;
            } else if (!method.equals(other.method))
                return false;
            return true;
        }
    }

    public static class testClass {
        public static void main(String[] args) throws NoSuchMethodException, SecurityException {
            Class<?> targetClass = TxBacklogServiceImpl.class;
            boolean canAccess = RequestSourceDesc.BACK_LOG_LIST.canAccess("getBacklogList", targetClass,
                RoleType.CHARAGE, new Class<?>[] { Long.class, int.class, PageDto.class });
            System.out.println("can access: " + canAccess);

            // canAccess = RequestSourceDesc.BACK_LOG_LIST.canAccess("getBacklogList", targetClass, RoleType.CHARAGE,
            // new Class<?>[] { Long.class, int.class, PageDto.class });
            // System.out.println("can access: " + canAccess);

        }
    }
}
