
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title TXCampusAccountServiceImpl
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月10日
 * @version 1.0
 */
@Service
public class OrgSubAccountServiceImpl implements OrgSubAccountService {

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    
    @Override
    public OrgSubAccount getMaster(Integer orgId) {
        OrgSubAccount account = orgSubAccountDao.getMasterByOrgId(orgId);
        return account;
    }

    @Override
    public List<OrgSubAccount> getSlaves(Integer orgId, PageDto pageDto) {
        List<OrgSubAccount> accounts = orgSubAccountDao.getSlavesByMasterOrgId(orgId, pageDto);
        return accounts;
    }

    @Override
    public Integer getSlaveCount(Integer orgId) {
        Integer count = orgSubAccountDao.getSlavesCountByMasterOrgId(orgId);
        return count;
    }

    @Override
    public void addOrgSubAccount(OrgSubAccount orgSubAccount) {
        this.orgSubAccountDao.save(orgSubAccount);
    }

    @Override
    public OrgSubAccount getByOrgId(Integer orgId) {
        OrgSubAccount subAccount = orgSubAccountDao.getByOrgId(orgId);
        return subAccount;
    }

    @Override
    public void update(OrgSubAccount orgSubAccount) {
        orgSubAccountDao.update(orgSubAccount);
    }

    @Override
    public OrgSubAccount getSlaveIgnoreStatus(Integer orgId, Integer masterId) {
        OrgSubAccount subAccount = orgSubAccountDao.getSlaveIgnoreStatus(orgId, masterId);
        return subAccount;
    }

    @Override
    public List<OrgSubAccount> getSlavesIgnoreStatus(Integer orgId, PageDto pageDto) {
        List<OrgSubAccount> accounts = orgSubAccountDao.getSlavesIgnoreStatus(orgId, pageDto);
        return accounts;
            
    }

}

    