/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.org.dto;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年5月18日
 * @desc
 */
@Data
@Slf4j
public class TxCascadeCredentialDto {
    private Integer userId;  //机构Number,子帐号id
    private String name;    //员工姓名
    private String avatarUrl;    //头像url
    private String initial;   //首字母
    private Integer userRole; //参看MsgUserRole
    private int userType = MsgUserType.ORG.getValue();
    private String userTypeString;  //身份类型描述
    private Integer cascadeId;//子账号ID
    private Integer credentialId;//登录认证ID
    
    public static TxCascadeCredentialDto getInstance(TXCascadeCredential txCascadCredential, TXCascadeAccount txCascadeAccount) {
        TxCascadeCredentialDto txCascadeCredentialDto = new TxCascadeCredentialDto();
        txCascadeCredentialDto.setUserId(txCascadeAccount.getId());
        txCascadeCredentialDto.setName(txCascadCredential.getName() == null ? txCascadCredential.getMobile() : txCascadCredential.getName());
        int userType = txCascadeAccount.getAccountType();
        txCascadeCredentialDto.setUserRole(userType);
        txCascadeCredentialDto.setUserTypeString(MsgUserRole.getByCode(userType).getDesc());
        String avatarUrl = null;
        avatarUrl = txCascadCredential.getAvatar();
        if(StringUtils.isNotEmpty(avatarUrl)){
            txCascadeCredentialDto.setAvatarUrl(avatarUrl);
        }else{
            txCascadeCredentialDto.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
        }
        return txCascadeCredentialDto;
    }

    public static TxCascadeCredentialDto getInstanceByOrgInfo(Integer role, OrgInfo orgInfo, Integer orgNumber, String logo) {
        TxCascadeCredentialDto txCascadeCredentialDto = new TxCascadeCredentialDto();
        txCascadeCredentialDto.setUserId(orgNumber);
        txCascadeCredentialDto.setName(orgInfo.getContacts() == null ? "" : orgInfo.getContacts());
        if(StringUtils.isNotEmpty(logo)){
            txCascadeCredentialDto.setAvatarUrl(logo);
        }else{
            txCascadeCredentialDto.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
        }
        txCascadeCredentialDto.setUserRole(role);
        txCascadeCredentialDto.setUserTypeString(MsgUserRole.getByCode(role).getDesc());
        return txCascadeCredentialDto;
    }

}
