/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @author gaodan
 * @createdate 2016年5月23日
* @desc 子帐号类型
 */
public enum CascadeType {
    STAFF(4,"普通员工"),
    MANAGER(3,"主管");
    
    private int value;
    private String desc;
    private CascadeType(int value, String desc){
        this.value = value;
        this.desc = desc;
    };
    
private static Map<Integer, CascadeType> mapping = Maps.newHashMap();
    
    static{
        for(CascadeType cut : CascadeType.values()){
            mapping.put(cut.value, cut);
        }
    }
    
    public static CascadeType getByType(Integer code) {
        return mapping.get(code);
    }

    public int getValue(){
        return value;
    }

    public String getDesc(){
        return desc;
    }

}
