/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXSaleClueRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.sal.organization.constant.TXSaleClueRuleValue;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TXSaleClueRuleServiceImpl
implements TXSaleClueRuleService {
    private static final Logger log = LoggerFactory.getLogger(TXSaleClueRuleServiceImpl.class);
    @Autowired
    private TXSaleClueRuleDao txSaleClueRuleDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public TXSaleClueRule getByOrgId(Integer orgId) {
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleDao.getByOrgId(orgId);
        if (txSaleClueRule == null) {
            txSaleClueRule = new TXSaleClueRule();
            txSaleClueRule.setClueAllot(Integer.valueOf(TXSaleClueRuleValue.CLUEALLOT_STAFF_CAN_HAVE.getCode()));
            txSaleClueRule.setClueTransValid(Integer.valueOf(TXSaleClueRuleValue.CLUETRANSVALID_PRIVATE.getCode()));
            txSaleClueRule.setCreateTime(new Date());
            txSaleClueRule.setMaxClueCount(Integer.valueOf(TXSaleClueRuleValue.MAXCLUECOUNT.getCode()));
            txSaleClueRule.setMaxClueDelay(Integer.valueOf(TXSaleClueRuleValue.MAXCLUEDELAY.getCode()));
            txSaleClueRule.setOrgId(orgId);
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            txSaleClueRule.setOrgNumber(orgAccount.getNumber());
            txSaleClueRule.setReturnClue(Integer.valueOf(TXSaleClueRuleValue.RETURNCLUE_CAN.getCode()));
        }
        return txSaleClueRule;
    }

    @Override
    public void saveTXSaleClueRule(TXSaleClueRule txSaleClueRule) {
        this.txSaleClueRuleDao.saveOrUpdate((Object)txSaleClueRule, new String[0]);
    }
}

