/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.sal.organization.todo.service.impl.TxBacklogServiceImpl;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.organization.utils.ExpressionPointcut;
import com.baijia.tianxiao.sal.organization.utils.MethodMatcher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RequestSourceDesc implements MethodMatcher
{
    COURSE_LIST("\u7528\u4e8e\u9650\u5236\u8d26\u6237\u5c55\u793a\u7684\u8bfe\u7a0b"){}
    ,
    BACK_LOG_LIST("\u7528\u4e8e\u5f85\u529e\u4e8b\u9879\u5217\u8868\u5c55\u793a"){}
    ,
    CONSULT_LIST("\u7528\u4e8e\u9650\u5236\u7ebf\u7d22\u6570\u636e\u7684\u67e5\u8be2"){}
    ,
    STUDENT_LIST("\u7528\u4e8e\u9650\u5236\u5b66\u5458\u6570\u636e\u7684\u67e5\u8be2"){};

    private static final Logger log;
    private ThreadLocal<AccountRoleType> threadLocalRoleType = new ThreadLocal();
    protected TreeSet<String> sourcePaths = new TreeSet();
    public final String desc;
    private final List<RoleType> DEFAULT_ROLE_TYPES = Arrays.asList(RoleType.PRESIDENT, RoleType.BRANCH_SCH_PRESIDENT, RoleType.CHARAGE);
    protected Set<RoleType> canAccessRoleTypes = new HashSet<RoleType>();
    private Set<ClassAndMethod> hashCache = new HashSet<ClassAndMethod>();

    private RequestSourceDesc(String desc) {
        this.desc = desc;
        this.initRoleTypes();
        this.initSourcePath();
    }

    protected void initRoleTypes() {
        this.canAccessRoleTypes.addAll(this.DEFAULT_ROLE_TYPES);
    }

    protected void initSourcePath() {
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        if (!this.hashCache.contains(new ClassAndMethod(targetClass, method))) {
            boolean canExecuteMatch;
            DataAuthority daForClass = targetClass.getAnnotation(DataAuthority.class);
            if (daForClass != null && (canExecuteMatch = this.requestSourceCanMatch(daForClass))) {
                this.generateSourcePath(targetClass, method);
            }
            if (method != null) {
                DataAuthority daForMethod = method.getAnnotation(DataAuthority.class);
                if (daForMethod == null) {
                    method = null;
                } else {
                    boolean canMatcnMethod = this.requestSourceCanMatch(daForMethod);
                    if (!canMatcnMethod) {
                        return false;
                    }
                    this.generateSourcePath(targetClass, method);
                }
            }
        } else {
            System.out.println("targetClass and method has already init ");
        }
        if (GenericsUtils.isNullOrEmpty(this.sourcePaths)) {
            return false;
        }
        TreeSet copier = (TreeSet)this.sourcePaths.clone();
        Iterator descendingIterator = copier.descendingIterator();
        while (descendingIterator.hasNext()) {
            ExpressionPointcut ep = new ExpressionPointcut();
            String expression = (String)descendingIterator.next();
            ep.setExpression(expression);
            System.out.println(expression);
            boolean matchTargetClass = ep.matches(targetClass);
            if (!matchTargetClass) continue;
            if (method != null) {
                boolean matchMethod = ep.matches(method, targetClass);
                if (!matchMethod) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean requestSourceCanMatch(DataAuthority daForClass) {
        if (daForClass == null) {
            return false;
        }
        ArrayList<RequestSourceDesc> rsds = new ArrayList<RequestSourceDesc>(Arrays.asList(daForClass.resourceTypes()));
        return rsds.contains(this);
    }

    private void generateSourcePath(Class<?> targetClass, Method method) {
        boolean methodIsNull = method == null;
        String modifiersStr = "*";
        String methodMatchStr = "*(..)";
        String methodReturnType = "";
        if (!methodIsNull) {
            StringBuilder methodMatchBuilder = new StringBuilder();
            int modifiers = method.getModifiers();
            modifiersStr = Modifier.toString(modifiers);
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            methodMatchBuilder.append(methodName);
            if (GenericsUtils.notNullAndEmpty(parameterTypes)) {
                methodMatchBuilder.append("(");
                int i = 0;
                for (Class<?> paramClass : parameterTypes) {
                    methodMatchBuilder.append(paramClass.getName());
                    if (i != parameterTypes.length - 1) {
                        methodMatchBuilder.append(",");
                    }
                    ++i;
                }
                methodMatchBuilder.append(")");
            } else {
                methodMatchBuilder.append("(..)");
            }
            methodMatchStr = methodMatchBuilder.toString();
            methodReturnType = method.getReturnType().getName();
        }
        String classPath = targetClass.getName();
        StringBuilder sb = new StringBuilder("execution(").append(modifiersStr).append(" ").append(methodReturnType).append(" ").append(classPath).append(".").append(methodMatchStr).append(")");
        System.out.println("sb.toString : " + sb.toString());
        this.hashCache.add(new ClassAndMethod(targetClass, method));
        this.sourcePaths.add(sb.toString());
    }

    public boolean canAccess(Method method, Class<?> targetClass, RoleType roleType) {
        boolean canAccess = false;
        if (this.matches(method, targetClass)) {
            canAccess = this.canAccessRoleTypes.contains(roleType);
            canAccess = this.subAccessJudge(canAccess, roleType);
        }
        return canAccess;
    }

    protected boolean subAccessJudge(boolean canAccess, RoleType roleType) {
        return canAccess;
    }

    public boolean canAccess(String methodName, Class<?> className, RoleType roleType, Class<?> ... paramerTypes) {
        Method method = null;
        try {
            if (GenericsUtils.isNullOrEmpty(paramerTypes)) {
                paramerTypes = new Class[]{};
            }
            method = className.getDeclaredMethod(methodName, paramerTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.out.println("can not find declarredMathod : " + methodName);
            return false;
        }
        boolean canAccess = this.canAccess(method, className, roleType);
        log.info("current account going to visit method or class : {}.{} with roleType : {} ,and result permission is : {}", new Object[]{className.getName(), methodName, roleType, canAccess});
        return canAccess;
    }

    public boolean canAccess(String methodName, Class<?> className, Class<?> ... paramerTypes) {
        AccountRoleType accountRoleType = this.threadLocalRoleType.get();
        if (accountRoleType == null) {
            return true;
        }
        return this.canAccess(methodName, className, accountRoleType.getRoleType(), paramerTypes);
    }

    public void setAccountRoleType(AccountRoleType roleType) {
        this.threadLocalRoleType.set(roleType);
    }

    public void removeAccountRoleType() {
        this.threadLocalRoleType.remove();
    }

    public AccountRoleType getAccountRoleType() {
        return this.threadLocalRoleType.get();
    }

    static {
        log = LoggerFactory.getLogger(RequestSourceDesc.class);
    }

    public static class testClass {
        public static void main(String[] args) throws NoSuchMethodException, SecurityException {
            Class<TxBacklogServiceImpl> targetClass = TxBacklogServiceImpl.class;
            boolean canAccess = BACK_LOG_LIST.canAccess("getBacklogList", targetClass, RoleType.CHARAGE, Long.class, Integer.TYPE, PageDto.class);
            System.out.println("can access: " + canAccess);
        }
    }

    static class ClassAndMethod {
        private Class<?> clazz;
        private Method method;

        public ClassAndMethod(Class<?> targetClass, Method method) {
            this.clazz = targetClass;
            this.method = method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassAndMethod other = (ClassAndMethod)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }
    }
}

