/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.dto;

import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxCascadeCredentialDto {
    private static final Logger log = LoggerFactory.getLogger(TxCascadeCredentialDto.class);
    private Integer userId;
    private String name;
    private String avatarUrl;
    private String initial;
    private Integer userRole;
    private int userType = MsgUserType.ORG.getValue();
    private String userTypeString;
    private Integer cascadeId;
    private Integer credentialId;

    public static TxCascadeCredentialDto getInstance(TXCascadeCredential txCascadCredential, TXCascadeAccount txCascadeAccount) {
        TxCascadeCredentialDto txCascadeCredentialDto = new TxCascadeCredentialDto();
        txCascadeCredentialDto.setUserId(txCascadeAccount.getId());
        txCascadeCredentialDto.setName(txCascadCredential.getName() == null ? txCascadCredential.getMobile() : txCascadCredential.getName());
        int userType = txCascadeAccount.getAccountType();
        txCascadeCredentialDto.setUserRole(userType);
        txCascadeCredentialDto.setUserTypeString(MsgUserRole.getByCode((Integer)userType).getDesc());
        String avatarUrl = null;
        avatarUrl = txCascadCredential.getAvatar();
        if (StringUtils.isNotEmpty((CharSequence)avatarUrl)) {
            txCascadeCredentialDto.setAvatarUrl(avatarUrl);
        } else {
            txCascadeCredentialDto.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
        }
        return txCascadeCredentialDto;
    }

    public static TxCascadeCredentialDto getInstanceByOrgInfo(Integer role, OrgInfo orgInfo, Integer orgNumber, String logo) {
        TxCascadeCredentialDto txCascadeCredentialDto = new TxCascadeCredentialDto();
        txCascadeCredentialDto.setUserId(orgNumber);
        txCascadeCredentialDto.setName(orgInfo.getContacts() == null ? "" : orgInfo.getContacts());
        if (StringUtils.isNotEmpty((CharSequence)logo)) {
            txCascadeCredentialDto.setAvatarUrl(logo);
        } else {
            txCascadeCredentialDto.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
        }
        txCascadeCredentialDto.setUserRole(role);
        txCascadeCredentialDto.setUserTypeString(MsgUserRole.getByCode((Integer)role).getDesc());
        return txCascadeCredentialDto;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getInitial() {
        return this.initial;
    }

    public Integer getUserRole() {
        return this.userRole;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getUserTypeString() {
        return this.userTypeString;
    }

    public Integer getCascadeId() {
        return this.cascadeId;
    }

    public Integer getCredentialId() {
        return this.credentialId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    public void setUserRole(Integer userRole) {
        this.userRole = userRole;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public void setUserTypeString(String userTypeString) {
        this.userTypeString = userTypeString;
    }

    public void setCascadeId(Integer cascadeId) {
        this.cascadeId = cascadeId;
    }

    public void setCredentialId(Integer credentialId) {
        this.credentialId = credentialId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxCascadeCredentialDto)) {
            return false;
        }
        TxCascadeCredentialDto other = (TxCascadeCredentialDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$avatarUrl = this.getAvatarUrl();
        String other$avatarUrl = other.getAvatarUrl();
        if (this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl)) {
            return false;
        }
        String this$initial = this.getInitial();
        String other$initial = other.getInitial();
        if (this$initial == null ? other$initial != null : !this$initial.equals(other$initial)) {
            return false;
        }
        Integer this$userRole = this.getUserRole();
        Integer other$userRole = other.getUserRole();
        if (this$userRole == null ? other$userRole != null : !((Object)this$userRole).equals(other$userRole)) {
            return false;
        }
        if (this.getUserType() != other.getUserType()) {
            return false;
        }
        String this$userTypeString = this.getUserTypeString();
        String other$userTypeString = other.getUserTypeString();
        if (this$userTypeString == null ? other$userTypeString != null : !this$userTypeString.equals(other$userTypeString)) {
            return false;
        }
        Integer this$cascadeId = this.getCascadeId();
        Integer other$cascadeId = other.getCascadeId();
        if (this$cascadeId == null ? other$cascadeId != null : !((Object)this$cascadeId).equals(other$cascadeId)) {
            return false;
        }
        Integer this$credentialId = this.getCredentialId();
        Integer other$credentialId = other.getCredentialId();
        return !(this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxCascadeCredentialDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $avatarUrl = this.getAvatarUrl();
        result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
        String $initial = this.getInitial();
        result = result * 59 + ($initial == null ? 43 : $initial.hashCode());
        Integer $userRole = this.getUserRole();
        result = result * 59 + ($userRole == null ? 43 : ((Object)$userRole).hashCode());
        result = result * 59 + this.getUserType();
        String $userTypeString = this.getUserTypeString();
        result = result * 59 + ($userTypeString == null ? 43 : $userTypeString.hashCode());
        Integer $cascadeId = this.getCascadeId();
        result = result * 59 + ($cascadeId == null ? 43 : ((Object)$cascadeId).hashCode());
        Integer $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        return result;
    }

    public String toString() {
        return "TxCascadeCredentialDto(userId=" + this.getUserId() + ", name=" + this.getName() + ", avatarUrl=" + this.getAvatarUrl() + ", initial=" + this.getInitial() + ", userRole=" + this.getUserRole() + ", userType=" + this.getUserType() + ", userTypeString=" + this.getUserTypeString() + ", cascadeId=" + this.getCascadeId() + ", credentialId=" + this.getCredentialId() + ")";
    }
}

