/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.sal.organization.finance.dto.response.FinanceAccountDto;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrgFinanceAcountServiceImpl
implements OrgFinanceAccountService {
    @Resource
    private OrgFinanceAccountDao orgFinanceAccountDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;

    @Override
    public FinanceAccountDto getInfo(Long orgId) {
        OrgFinanceAccount account = this.orgFinanceAccountDao.getByOrgId(orgId, new String[0]);
        Long signupMoney = this.orgSignupInfoDao.sumByPurchaseStatus(orgId, (Collection)Lists.newArrayList((Object[])new Integer[]{PayResult.SUCCESS.getCode()}), (Collection)Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.PENDING.getCode(), SplitCourseResult.NOT_COMMIT.getCode()}), null, true);
        double withdrawMondy = this.orgFinanceAccountRecordDao.sumDrawcashMoney(orgId.longValue());
        return this.buildDto(account, signupMoney, withdrawMondy);
    }

    private FinanceAccountDto buildDto(OrgFinanceAccount account, Long signupMoney, double withdrawMondy) {
        FinanceAccountDto dto = new FinanceAccountDto();
        dto.setBalance(account.getBalance());
        dto.setWithdrawMoney(withdrawMondy);
        dto.setSettleMoney(account.getFreezeMoney() - withdrawMondy);
        dto.setSignupMoney(signupMoney == null ? 0.0 : (double)(signupMoney / 100L));
        dto.setAssureMoney(account.getExpectedEarning() - dto.getSettleMoney());
        dto.setFreezeMoney(account.getFreezeMoney() + dto.getSignupMoney());
        return dto;
    }
}

