
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.msg.service.impl;

import java.util.Date;

import javax.annotation.Resource;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.msg.po.TxSms;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;

import lombok.extern.slf4j.Slf4j;

/**
 * @title SmsServiceImpl
 * @desc TODO
 * @author cxm
 * @date 2016年1月18日
 * @version 1.0
 */
@Service
@Slf4j
public class CommonSmsServiceImpl implements CommonSmsService {

    @Resource
    private TxSmsDao txSmsDao;

    @Override
    public boolean sendSms(Long sender, Integer senderRole, Long receiver, Integer receiverRole, String mobile,
        SmsMessageType smsType, String smsContent) {
        if (!ParamValidateUtils.validateMobile(mobile) || StringUtils.isBlank(smsContent)) {
            log.warn("send sms error,mobile:{},content:{}", mobile, smsContent);
            return false;
        }
        Preconditions.checkArgument(sender != null, "sender id is null");
        Preconditions.checkArgument(receiver != null, "receiver id is null");

        Preconditions.checkArgument(senderRole != null, "senderRole id is null");
        Preconditions.checkArgument(receiverRole != null, "receiverRole id is null");
        Preconditions.checkArgument(smsType != null, "smsType id is null");

        TxSms sms = new TxSms();
        sms.setCreateTime(new Date());
        sms.setMessageType(smsType.getCode());
        sms.setMobile(mobile);
        sms.setReceiverId(receiver);
        sms.setReceiverRole(receiverRole);
        sms.setSenderId(sender);
        sms.setSenderRole(senderRole);
        sms.setContent(smsContent);

        boolean sendResult = false;
        try {
            sendResult =
                SmsSendUtil.sendSms(mobile, smsContent, SmsMessageType.TIANXIAO_NOTIFY.getCode(), sender.intValue(), UserRole.ORGANIZATION.getRole(), true);
            sms.setSendResult(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue());
            txSmsDao.save(sms);
            return sendResult;
        } catch (Exception e) {
            log.warn("save sms record catch error:", e);
            return false;
        }
    }

}
