
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.msg.service.impl;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.msg.dao.TxSmsCountDao;
import com.baijia.tianxiao.dal.msg.po.TxSmsCount;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.google.common.base.Preconditions;

import lombok.extern.slf4j.Slf4j;

/**
 * @title MsgSendServiceImpl
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
@Service
@Slf4j
public class MsgSendServiceImpl implements MsgSendService {

    @Resource
    private WechatMsgRenderService wechatMsgSenderService;

    @Resource
    private CommonSmsService smsService;

    @Resource
    private TxSmsCountDao txSmsCountDao;

    @Override
    public boolean sendMsg(SendMsgRequest request) throws MsgSendException {
        Preconditions.checkNotNull(request);
        Preconditions.checkArgument(request.getSenderId() != null, "sender id is null");
        Preconditions.checkArgument(request.getReceiverId() != null, "receiver id is null");
        Preconditions.checkArgument(request.getOrgId() != null, "orgId id is null");

        Preconditions.checkArgument(request.getSenderRole() != null, "senderRole id is null");
        Preconditions.checkArgument(request.getReceiverRole() != null, "receiverRole id is null");
        boolean sendResult = false;
        log.info("try to send msg by request:{}", request);
        if (StringUtils.isNoneBlank(request.getWeixinOpenId()) && request.getWechatTemplateId() != null) {
            log.info("try to send msg by wechat:{}", request.getWechatParams());
            try {
                request.getWechatParams().put("touser", request.getWeixinOpenId());
                sendResult = wechatMsgSenderService
                    .sendMsg(request.getOrgId(), wechatMsgSenderService.render(request.getWechatTemplateId(), request.getWechatParams()));
                log.info("send msg result:{} by wechat:{}", sendResult, request.getWechatParams());
                if (sendResult) {
                    return true;
                }
            } catch (Exception e) {
                log.warn("send by wechat catch error,receiver id is:{},error is:{} ",request.getReceiverId(), e);
            }
        }
        if (!sendResult && StringUtils.isNoneBlank(request.getSmsContent())
            && StringUtils.isNoneBlank(request.getMobile())) {
            log.info("try to send msg by sms mobile:{},content:{}", request.getMobile(), request.getSmsContent());

            SmsMessageType msgType = request.getSmsMsgType();
            if (msgType == null) {
                msgType = SmsMessageType.TIANXIAO_NOTIFY;
            }
            if (request.isCountSms()) {
                try {
                    TxSmsCount smsCount = txSmsCountDao.decreaseSmsCount(request.getOrgId());
                    log.info("send sms left sms count:{}", smsCount);
                } catch (Exception e) {
                    log.warn("sms count is not enough:", e);
                    return false;
                }
            }

            sendResult = smsService.sendSms(request.getSenderId(), request.getSenderRole().getCode(),
                request.getReceiverId(), request.getReceiverRole().getCode(), request.getMobile(),
                request.getSmsMsgType(), request.getSmsContent());
            log.info("send sms msg receiver id is:{},result:{}", request.getReceiverId(),sendResult);
        }

        return sendResult;
    }

}
