/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.msg.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.SmsSendResult;
import com.baijia.tianxiao.dal.msg.dao.TxSmsDao;
import com.baijia.tianxiao.dal.msg.po.TxSms;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonSmsServiceImpl
implements CommonSmsService {
    private static final Logger log = LoggerFactory.getLogger(CommonSmsServiceImpl.class);
    @Resource
    private TxSmsDao txSmsDao;

    @Override
    public boolean sendSms(Long sender, Integer senderRole, Long receiver, Integer receiverRole, String mobile, SmsMessageType smsType, String smsContent) {
        if (!ParamValidateUtils.validateMobile((String)mobile) || StringUtils.isBlank((CharSequence)smsContent)) {
            log.warn("send sms error,mobile:{},content:{}", (Object)mobile, (Object)smsContent);
            return false;
        }
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender id is null");
        Preconditions.checkArgument((receiver != null ? 1 : 0) != 0, (Object)"receiver id is null");
        Preconditions.checkArgument((senderRole != null ? 1 : 0) != 0, (Object)"senderRole id is null");
        Preconditions.checkArgument((receiverRole != null ? 1 : 0) != 0, (Object)"receiverRole id is null");
        Preconditions.checkArgument((smsType != null ? 1 : 0) != 0, (Object)"smsType id is null");
        TxSms sms = new TxSms();
        sms.setCreateTime(new Date());
        sms.setMessageType(Integer.valueOf(smsType.getCode()));
        sms.setMobile(mobile);
        sms.setReceiverId(receiver);
        sms.setReceiverRole(receiverRole);
        sms.setSenderId(sender);
        sms.setSenderRole(senderRole);
        sms.setContent(smsContent);
        boolean sendResult = false;
        try {
            sendResult = SmsSendUtil.sendSms((String)mobile, (String)smsContent, (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)sender.intValue(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true);
            sms.setSendResult(sendResult ? SmsSendResult.SUCCESS.getValue() : SmsSendResult.FAILED.getValue());
            this.txSmsDao.save((Object)sms, new String[0]);
            return sendResult;
        }
        catch (Exception e) {
            log.warn("save sms record catch error:", (Throwable)e);
            return false;
        }
    }
}

