/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.kexiao.service.impl;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.finance.dao.TxTransferClassInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxTransferClassInfo;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sal.kexiao.dto.LessonKexiaoStatisticsDto;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoStatisticsService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KexiaoStatisticsServiceImpl
implements KexiaoStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoStatisticsServiceImpl.class);
    private static final int HOUR = 60;
    private static final int HALF_HOUR = 30;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupCourseLessonDao orgSignupCourseLessonDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private TxTransferClassInfoDao txTransferClassInfoDao;

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfOrg(Collection<Long> orgIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List signupList = this.orgSignupCourseDao.getSignupCourseSuccessedList(orgIds, null, null);
        this.filterSignupList(signupList);
        if (CollectionUtils.isNotEmpty((Collection)signupList)) {
            Map<Long, List<OrgSignupCourse>> signupOrgMap = signupList.stream().collect(Collectors.groupingBy(OrgSignupCourse::getOrgId));
            result = this.calculateSignupStatisticsOfGroup(signupOrgMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfClass(Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List signupList = this.orgSignupCourseDao.getSignupCourseSuccessedList(null, classIds, null);
        this.filterSignupList(signupList);
        if (CollectionUtils.isNotEmpty((Collection)signupList)) {
            Map<Long, List<OrgSignupCourse>> signupClassMap = signupList.stream().collect(Collectors.groupingBy(OrgSignupCourse::getClassId));
            result = this.calculateSignupStatisticsOfGroup(signupClassMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfStudentClass(Long userId, Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List signupList = this.orgSignupCourseDao.getSignupCourseSuccessedList(null, classIds, (Collection)Sets.newHashSet((Object[])new Long[]{userId}));
        this.filterSignupList(signupList);
        if (CollectionUtils.isNotEmpty((Collection)signupList)) {
            Map<Long, List<OrgSignupCourse>> signupClassMap = signupList.stream().collect(Collectors.groupingBy(OrgSignupCourse::getClassId));
            result = this.calculateSignupStatisticsOfGroup(signupClassMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfStudent(Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List signupList = this.orgSignupCourseDao.getSignupCourseSuccessedList(null, null, userIds);
        this.filterSignupList(signupList);
        if (CollectionUtils.isNotEmpty((Collection)signupList)) {
            Map<Long, List<OrgSignupCourse>> signupStudentMap = signupList.stream().collect(Collectors.groupingBy(OrgSignupCourse::getUserId));
            result = this.calculateSignupStatisticsOfGroup(signupStudentMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfClassStudent(Long classId, Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List signupList = this.orgSignupCourseDao.getSignupCourseSuccessedList(null, (Collection)Sets.newHashSet((Object[])new Long[]{classId}), userIds);
        this.filterSignupList(signupList);
        if (CollectionUtils.isNotEmpty((Collection)signupList)) {
            Map<Long, List<OrgSignupCourse>> signupStudentMap = signupList.stream().collect(Collectors.groupingBy(OrgSignupCourse::getUserId));
            result = this.calculateSignupStatisticsOfGroup(signupStudentMap);
        }
        return result;
    }

    private Map<Long, LessonKexiaoStatisticsDto> calculateSignupStatisticsOfGroup(Map<Long, List<OrgSignupCourse>> signupMap) {
        HashMap result = Maps.newHashMap();
        if (MapUtils.isNotEmpty(signupMap)) {
            for (Long id : signupMap.keySet()) {
                List<OrgSignupCourse> orgSignupList = signupMap.get(id);
                LessonKexiaoStatisticsDto kexiaoStatisticsDto = new LessonKexiaoStatisticsDto();
                for (OrgSignupCourse signup : orgSignupList) {
                    this.upLessonCountAndMoney(kexiaoStatisticsDto, signup.getChargeUnit(), false, signup.getLessonCount().intValue(), signup.getTotalPayPrice());
                }
                result.put(id, kexiaoStatisticsDto);
            }
        }
        return result;
    }

    private void filterSignupList(List<OrgSignupCourse> signupList) {
        if (CollectionUtils.isNotEmpty(signupList)) {
            signupList = signupList.stream().filter(o -> o.getLessonCount() > 0).collect(Collectors.toList());
        }
    }

    private void upLessonCountAndMoney(LessonKexiaoStatisticsDto kexiaoStatisticsDto, Integer chargeUnitInt, boolean ignoreDuration, long count, long money) {
        Preconditions.checkArgument((kexiaoStatisticsDto != null ? 1 : 0) != 0, (Object)"\u8bfe\u6d88\u7edf\u8ba1\u53c2\u6570\u4e3a\u7a7a");
        ChargeUnit chargeUnit = ChargeUnit.getByCode((int)chargeUnitInt);
        Long minutes = 0L;
        Long times = 0L;
        Long minutesMoney = 0L;
        Long timesMoney = 0L;
        if (ChargeUnit.isByDuration((Integer)chargeUnitInt)) {
            minutesMoney = money;
            if (ignoreDuration) {
                minutes = count;
            } else {
                switch (chargeUnit) {
                    case BY_HOUR: {
                        minutes = count * 60L;
                        break;
                    }
                    case BY_HALF_HOUR: {
                        minutes = count * 30L;
                        break;
                    }
                    case BY_MINUTE: {
                        minutes = count;
                    }
                }
            }
        } else {
            times = count;
            timesMoney = money;
        }
        kexiaoStatisticsDto.addFromMinutesAndTimes(minutes, minutesMoney, times, timesMoney);
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfOrg(Collection<Long> orgIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List lessonList = this.orgSignupCourseLessonDao.getLessonFreeList(orgIds, null, null);
        if (CollectionUtils.isNotEmpty((Collection)lessonList)) {
            Map<Long, List<OrgSignupCourseLesson>> lessonFreeOrgMap = lessonList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getOrgId));
            result = this.calculateLessonFreeStatisticsOfGroup(lessonFreeOrgMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfClass(Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List lessonList = this.orgSignupCourseLessonDao.getLessonFreeList(null, classIds, null);
        if (CollectionUtils.isNotEmpty((Collection)lessonList)) {
            Map<Long, List<OrgSignupCourseLesson>> lessonFreeClassMap = lessonList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getClassId));
            result = this.calculateLessonFreeStatisticsOfGroup(lessonFreeClassMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfStudentClass(Long userId, Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List lessonList = this.orgSignupCourseLessonDao.getLessonFreeList(null, classIds, (Collection)Sets.newHashSet((Object[])new Long[]{userId}));
        if (CollectionUtils.isNotEmpty((Collection)lessonList)) {
            Map<Long, List<OrgSignupCourseLesson>> lessonFreeClassMap = lessonList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getClassId));
            result = this.calculateLessonFreeStatisticsOfGroup(lessonFreeClassMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfStudent(Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List lessonList = this.orgSignupCourseLessonDao.getLessonFreeList(null, null, userIds);
        if (CollectionUtils.isNotEmpty((Collection)lessonList)) {
            Map<Long, List<OrgSignupCourseLesson>> lessonFreeStudentMap = lessonList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getUserId));
            result = this.calculateLessonFreeStatisticsOfGroup(lessonFreeStudentMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfClassStudent(Long classId, Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List lessonList = this.orgSignupCourseLessonDao.getLessonFreeList(null, (Collection)Sets.newHashSet((Object[])new Long[]{classId}), userIds);
        if (CollectionUtils.isNotEmpty((Collection)lessonList)) {
            Map<Long, List<OrgSignupCourseLesson>> lessonFreeStudentMap = lessonList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getUserId));
            result = this.calculateLessonFreeStatisticsOfGroup(lessonFreeStudentMap);
        }
        return result;
    }

    private Map<Long, LessonKexiaoStatisticsDto> calculateLessonFreeStatisticsOfGroup(Map<Long, List<OrgSignupCourseLesson>> lessonFreeMap) {
        HashMap result = Maps.newHashMap();
        if (MapUtils.isNotEmpty(lessonFreeMap)) {
            for (Long id : lessonFreeMap.keySet()) {
                List<OrgSignupCourseLesson> lessonFreeList = lessonFreeMap.get(id);
                LessonKexiaoStatisticsDto kexiaoStatisticsDto = new LessonKexiaoStatisticsDto();
                for (OrgSignupCourseLesson lessonFree : lessonFreeList) {
                    this.upLessonCountAndMoney(kexiaoStatisticsDto, lessonFree, false);
                }
                result.put(id, kexiaoStatisticsDto);
            }
        }
        return result;
    }

    private void upLessonCountAndMoney(LessonKexiaoStatisticsDto kexiaoStatisticsDto, OrgSignupCourseLesson studentLesson, boolean calculateMoney) {
        Preconditions.checkArgument((kexiaoStatisticsDto != null ? 1 : 0) != 0, (Object)"\u8bfe\u6d88\u7edf\u8ba1\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((studentLesson != null ? 1 : 0) != 0, (Object)"\u5b66\u5458\u8bfe\u8282\u53c2\u6570\u4e3a\u7a7a");
        Integer minutes = 0;
        Integer times = 0;
        Long minutesMoney = 0L;
        Long timesMoney = 0L;
        if (ChargeUnit.isByDuration((Integer)studentLesson.getChargeUnit())) {
            minutes = studentLesson.getLessonDuration();
            if (calculateMoney) {
                minutesMoney = studentLesson.getAmount();
            }
        } else {
            times = 1;
            if (calculateMoney) {
                timesMoney = studentLesson.getAmount();
            }
        }
        kexiaoStatisticsDto.addFromMinutesAndTimes(minutes.intValue(), minutesMoney, times.intValue(), timesMoney);
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfOrg(Collection<Long> orgIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List kexiaoList = this.orgSignupCourseLessonDao.getKexiaoFinishedList(orgIds, null, null);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoList)) {
            Map<Long, List<OrgSignupCourseLesson>> kexiaoMap = kexiaoList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getOrgId));
            result = this.calculateKexiaoFinishedStatisticsOfGroup(kexiaoMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfClass(Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List kexiaoList = this.orgSignupCourseLessonDao.getKexiaoFinishedList(null, classIds, null);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoList)) {
            Map<Long, List<OrgSignupCourseLesson>> kexiaoMap = kexiaoList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getClassId));
            result = this.calculateKexiaoFinishedStatisticsOfGroup(kexiaoMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfStudentClass(Long userId, Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List kexiaoList = this.orgSignupCourseLessonDao.getKexiaoFinishedList(null, classIds, (Collection)Sets.newHashSet((Object[])new Long[]{userId}));
        if (CollectionUtils.isNotEmpty((Collection)kexiaoList)) {
            Map<Long, List<OrgSignupCourseLesson>> kexiaoMap = kexiaoList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getClassId));
            result = this.calculateKexiaoFinishedStatisticsOfGroup(kexiaoMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfStudent(Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List kexiaoList = this.orgSignupCourseLessonDao.getKexiaoFinishedList(null, null, userIds);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoList)) {
            Map<Long, List<OrgSignupCourseLesson>> kexiaoMap = kexiaoList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getUserId));
            result = this.calculateKexiaoFinishedStatisticsOfGroup(kexiaoMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfClassStudent(Long classId, Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List kexiaoList = this.orgSignupCourseLessonDao.getKexiaoFinishedList(null, (Collection)Sets.newHashSet((Object[])new Long[]{classId}), userIds);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoList)) {
            Map<Long, List<OrgSignupCourseLesson>> kexiaoMap = kexiaoList.stream().collect(Collectors.groupingBy(OrgSignupCourseLesson::getUserId));
            result = this.calculateKexiaoFinishedStatisticsOfGroup(kexiaoMap);
        }
        return result;
    }

    private Map<Long, LessonKexiaoStatisticsDto> calculateKexiaoFinishedStatisticsOfGroup(Map<Long, List<OrgSignupCourseLesson>> kexiaoMap) {
        HashMap result = Maps.newHashMap();
        if (MapUtils.isNotEmpty(kexiaoMap)) {
            for (Long id : kexiaoMap.keySet()) {
                List<OrgSignupCourseLesson> kexiaoList = kexiaoMap.get(id);
                LessonKexiaoStatisticsDto kexiaoStatisticsDto = new LessonKexiaoStatisticsDto();
                for (OrgSignupCourseLesson kexiaoRecord : kexiaoList) {
                    this.upLessonCountAndMoney(kexiaoStatisticsDto, kexiaoRecord, true);
                }
                result.put(id, kexiaoStatisticsDto);
            }
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfOrg(Collection<Long> orgIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List refundList = this.orgSignupRefundDao.getRefundList(orgIds, null, null);
        if (CollectionUtils.isNotEmpty((Collection)refundList)) {
            Map<Long, List<OrgSignupRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(OrgSignupRefund::getOrgId));
            result = this.calculateRefundStatisticsOfGroup(refundMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfClass(Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List refundList = this.orgSignupRefundDao.getRefundList(null, classIds, null);
        if (CollectionUtils.isNotEmpty((Collection)refundList)) {
            Map<Long, List<OrgSignupRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(OrgSignupRefund::getClassId));
            result = this.calculateRefundStatisticsOfGroup(refundMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfStudentClass(Long userId, Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List refundList = this.orgSignupRefundDao.getRefundList(null, classIds, (Collection)Sets.newHashSet((Object[])new Long[]{userId}));
        if (CollectionUtils.isNotEmpty((Collection)refundList)) {
            Map<Long, List<OrgSignupRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(OrgSignupRefund::getClassId));
            result = this.calculateRefundStatisticsOfGroup(refundMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfStudent(Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List refundList = this.orgSignupRefundDao.getRefundList(null, null, userIds);
        if (CollectionUtils.isNotEmpty((Collection)refundList)) {
            Map<Long, List<OrgSignupRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(OrgSignupRefund::getUserId));
            result = this.calculateRefundStatisticsOfGroup(refundMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfClassStudent(Long classId, Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List refundList = this.orgSignupRefundDao.getRefundList(null, (Collection)Sets.newHashSet((Object[])new Long[]{classId}), userIds);
        if (CollectionUtils.isNotEmpty((Collection)refundList)) {
            Map<Long, List<OrgSignupRefund>> refundMap = refundList.stream().collect(Collectors.groupingBy(OrgSignupRefund::getUserId));
            result = this.calculateRefundStatisticsOfGroup(refundMap);
        }
        return result;
    }

    private Map<Long, LessonKexiaoStatisticsDto> calculateRefundStatisticsOfGroup(Map<Long, List<OrgSignupRefund>> refundMap) {
        HashMap result = Maps.newHashMap();
        if (MapUtils.isNotEmpty(refundMap)) {
            for (Long id : refundMap.keySet()) {
                List<OrgSignupRefund> refundList = refundMap.get(id);
                LessonKexiaoStatisticsDto kexiaoStatisticsDto = new LessonKexiaoStatisticsDto();
                for (OrgSignupRefund refund : refundList) {
                    this.upLessonCountAndMoney(kexiaoStatisticsDto, refund.getChargeUnit(), true, refund.getRefundLessonCount(), refund.getRefundPrice() + refund.getRefundFee());
                }
                result.put(id, kexiaoStatisticsDto);
            }
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfOrg(Collection<Long> orgIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List transferList = this.txTransferClassInfoDao.getTransferSuccessList(orgIds, null, null);
        if (CollectionUtils.isNotEmpty((Collection)transferList)) {
            Map<Long, List<TxTransferClassInfo>> transferMap = transferList.stream().collect(Collectors.groupingBy(TxTransferClassInfo::getOrgId));
            result = this.calculateTransferStatisticsOfGroup(transferMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfClass(Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List transferList = this.txTransferClassInfoDao.getTransferSuccessList(null, classIds, null);
        if (CollectionUtils.isNotEmpty((Collection)transferList)) {
            Map<Long, List<TxTransferClassInfo>> transferMap = transferList.stream().collect(Collectors.groupingBy(TxTransferClassInfo::getTransferOutClassId));
            result = this.calculateTransferStatisticsOfGroup(transferMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfStudentClass(Long userId, Collection<Long> classIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List transferList = this.txTransferClassInfoDao.getTransferSuccessList(null, classIds, (Collection)Sets.newHashSet((Object[])new Long[]{userId}));
        if (CollectionUtils.isNotEmpty((Collection)transferList)) {
            Map<Long, List<TxTransferClassInfo>> transferMap = transferList.stream().collect(Collectors.groupingBy(TxTransferClassInfo::getTransferOutClassId));
            result = this.calculateTransferStatisticsOfGroup(transferMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfStudent(Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List transferList = this.txTransferClassInfoDao.getTransferSuccessList(null, null, userIds);
        if (CollectionUtils.isNotEmpty((Collection)transferList)) {
            Map<Long, List<TxTransferClassInfo>> transferMap = transferList.stream().collect(Collectors.groupingBy(TxTransferClassInfo::getUserId));
            result = this.calculateTransferStatisticsOfGroup(transferMap);
        }
        return result;
    }

    @Override
    public Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfClassStudent(Long classId, Collection<Long> userIds) {
        Map<Object, Object> result = Maps.newHashMap();
        List transferList = this.txTransferClassInfoDao.getTransferSuccessList(null, (Collection)Sets.newHashSet((Object[])new Long[]{classId}), userIds);
        if (CollectionUtils.isNotEmpty((Collection)transferList)) {
            Map<Long, List<TxTransferClassInfo>> transferMap = transferList.stream().collect(Collectors.groupingBy(TxTransferClassInfo::getUserId));
            result = this.calculateTransferStatisticsOfGroup(transferMap);
        }
        return result;
    }

    private Map<Long, LessonKexiaoStatisticsDto> calculateTransferStatisticsOfGroup(Map<Long, List<TxTransferClassInfo>> transferMap) {
        HashMap result = Maps.newHashMap();
        if (MapUtils.isNotEmpty(transferMap)) {
            for (Long id : transferMap.keySet()) {
                List<TxTransferClassInfo> transferList = transferMap.get(id);
                LessonKexiaoStatisticsDto kexiaoStatisticsDto = new LessonKexiaoStatisticsDto();
                for (TxTransferClassInfo transfer : transferList) {
                    this.upLessonCountAndMoney(kexiaoStatisticsDto, transfer.getChargeUnit(), true, transfer.getLessonCount().intValue(), transfer.getLessonMoney());
                }
                result.put(id, kexiaoStatisticsDto);
            }
        }
        return result;
    }
}

