package com.baijia.tianxiao.sal.kexiao.utils;

import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.SignStatus;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/12/19.
 */
@Slf4j
public class KexiaoUtil {
    public static LessonStatus getKexiaoStatus(int value, int rule) {
        int byteCode = 0;
        // 1，签到；2，请假；3，旷课
        if (value == SignStatus.SIGNED.getCode()) {
            byteCode = 1;
        } else if (value == SignStatus.LEAVE.getCode()) {
            byteCode = 2;
        } else if (value == SignStatus.ABSENT.getCode()) {
            byteCode = 4;
        } else {
            log.info("[Kexiao] UnSign.sign={}", value);
        }
        int result = byteCode & rule;
        if (result > 0) {
            return LessonStatus.FINISHED;
        } else {
            return LessonStatus.UN_START;
        }
    }
}
