package com.baijia.tianxiao.sal.kexiao.service.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.TxCourseGroupKexiaoDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.course.po.TxCourseGroupKexiao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.kexiao.service.TxCourseGroupKexiaoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

@Service
@Slf4j
public class TxCourseGroupKexiaoServiceImpl implements TxCourseGroupKexiaoService {

    @Autowired
    private TxCourseGroupKexiaoDao txCourseGroupKexiaoDao;

    @Autowired
    private OrgCourseGroupDao courseGroupDao;

    @Autowired
    private OrgCourseGroupRelateDao courseGroupRelateDao;

    @Autowired
    private OrgStudentKexiaoRecordDao studentKexiaoRecordDao;

    @Autowired
    private OrgCourseDao courseDao;

    @Autowired
    private OrgAccountDao accountDao;

    @Override
    public void syncHistoryData(Long orgId) {
        List<OrgCourseGroup> groupList = courseGroupDao.getOrgCourseGroupList(orgId.intValue());

        OrgAccount account = accountDao.getById(orgId);
        List<OrgCourse> courseList = courseDao.getCoursesByOrgNumber(account.getNumber().longValue(),null,"id");
        Set<Long> unGroupIds = new HashSet<>();
        for (OrgCourse course:courseList){
            unGroupIds.add(course.getId());
        }
        for (OrgCourseGroup group:groupList){
            List<Long> courseIds = courseGroupRelateDao.getCourseIdsByGroup(group.getId(),null);
            if(courseIds==null || courseIds.size()<1){
                continue;
            }
            unGroupIds.removeAll(courseIds);
            Map<String,Long> kexiaoMap = studentKexiaoRecordDao.getRecordByDay(courseIds);
            for (String key:kexiaoMap.keySet()){
                Long amount = kexiaoMap.get(key);
                TxCourseGroupKexiao groupKexiao = new TxCourseGroupKexiao();
                groupKexiao.setCourseTypeId(group.getId().longValue());
                groupKexiao.setCourseTypeName(group.getName());
                groupKexiao.setCreateTime(new Date());
                groupKexiao.setKexiao(amount);
                groupKexiao.setOrgId(orgId);
                try {
                    groupKexiao.setStartTime(DateUtils.parseDate(key,"yyyyy-MM-dd"));
                } catch (ParseException e) {
                    log.error("[OrgCourseGroup] sync error.{}",e);
                }
                txCourseGroupKexiaoDao.save(groupKexiao);
            }
        }
        if(unGroupIds.size()>0){
            Map<String,Long> kexiaoMap = studentKexiaoRecordDao.getRecordByDay(unGroupIds);
            for (String key:kexiaoMap.keySet()){
                Long amount = kexiaoMap.get(key);
                TxCourseGroupKexiao groupKexiao = new TxCourseGroupKexiao();
                groupKexiao.setCourseTypeId(-1L);
                groupKexiao.setCourseTypeName("未分类");
                groupKexiao.setCreateTime(new Date());
                groupKexiao.setKexiao(amount);
                groupKexiao.setOrgId(orgId);
                try {
                    groupKexiao.setStartTime(DateUtils.parseDate(key,"yyyyy-MM-dd"));
                } catch (ParseException e) {
                    log.error("[OrgCourseGroup] sync error.{}",e);
                }
                txCourseGroupKexiaoDao.save(groupKexiao);
            }
        }
    }

    @Override
    public void syncDataByTime(Long orgId, Date startTime, Date endTime) {

    }
}
