package com.baijia.tianxiao.sal.kexiao.service.impl;

import com.baijia.tianxiao.constant.KexiaoChangeEvent;
import com.baijia.tianxiao.dal.org.dao.KexiaoChangeLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.kexiao.dto.*;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by liuxp on 16/12/19.
 */
@Service
@Slf4j
public class KexiaoChangeLogServiceImpl implements KexiaoChangeLogService {

    @Autowired
    private KexiaoChangeLogDao changeLogDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;

    @Override
    public void addBatchSignLog(Long orgId, Collection<Long> userIds, Collection<Long> classLessonIds, int status) {
        log.info("[ChangeLog] Batch sign.userIds={},classLessonIds={},status={}",userIds,classLessonIds,status);
        if (userIds == null || userIds.size() < 1) {
            return;
        }
        if (classLessonIds == null || classLessonIds.size() < 1) {
            return;
        }
        Date date = new Date();
        List<KexiaoChangeLog> changeLogList = new ArrayList<>();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(KexiaoChangeEvent.BATCH_SIGN.getType());
        changeLog.setOrgId(orgId);
        BatchSignInfo batchSign = new BatchSignInfo(userIds, classLessonIds, status);
        Gson gson = new Gson();
        changeLog.setInfo(gson.toJson(batchSign));
        changeLogList.add(changeLog);
        changeLogDao.batchInsertChangeLogs(changeLogList);
    }

    @Override
    public void addFastSignLog(Long orgId, Collection<Long> classLessonIds, Map<Long, Integer> stuStatus) {
        log.info("[ChangeLog] Fast sign.classLessonIds={},stuStatus={}",classLessonIds,stuStatus);
        if (stuStatus == null || stuStatus.size() < 1) {
            return;
        }
        if (classLessonIds == null || classLessonIds.size() < 1) {
            return;
        }
        Date date = new Date();
        List<KexiaoChangeLog> changeLogList = new ArrayList<>();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(KexiaoChangeEvent.FAST_SIGN.getType());
        changeLog.setOrgId(orgId);
        FastSignInfo fastSign = new FastSignInfo(classLessonIds, stuStatus);
        Gson gson = new Gson();
        changeLog.setInfo(gson.toJson(fastSign));
        changeLogList.add(changeLog);
        changeLogDao.batchInsertChangeLogs(changeLogList);
    }

    @Override
    public void addLessonStartedLog(Collection<Long> lessonIds, Integer status) {
        log.info("[ChangeLog] Lesson started.lessonIds={},status={}",lessonIds,status);
        if (lessonIds == null || lessonIds.size() < 1) {
            return;
        }
        List<OrgStudentLesson> lessons = studentLessonDao.getOrgStudentLessonsByLessonIds(lessonIds, "id", "startStatus", "orgId");
        Map<Long, List<Long>> map = new HashMap<>();
        for (OrgStudentLesson lesson : lessons) {
            List<Long> list = map.get(lesson.getOrgId());
            if (list == null) {
                list = new ArrayList<>();
                map.put(lesson.getOrgId(),list);
            }
            list.add(lesson.getId());
        }

        List<KexiaoChangeLog> logs = new ArrayList<>();

        for (Long orgId : map.keySet()) {
            List<Long> list = map.get(orgId);
            Date date = new Date();
            KexiaoChangeLog changeLog = new KexiaoChangeLog();
            changeLog.setCreateTime(date);
            changeLog.setEventType(KexiaoChangeEvent.START.getType());
            changeLog.setOrgId(orgId);
            LessonStartInfo lessonStart = new LessonStartInfo(list, status);
            Gson gson = new Gson();
            changeLog.setInfo(gson.toJson(lessonStart));
            logs.add(changeLog);
        }

        changeLogDao.batchInsertChangeLogs(logs);
    }

    @Override
    public void addRuleChangedLog(OrgCourseConsumeRule rule) {
        log.info("[ChangeLog] Change Rule.OrgCourseConsumeRule={}",rule);
        if(rule==null){
            return;
        }
        Date date = new Date();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(KexiaoChangeEvent.KEXIAO_REUL.getType());
        changeLog.setOrgId(rule.getOrgId());
        Gson gson = new Gson();
        ChangeLogInfo extend = new RuleChangeInfo(rule.getRuleValue(), rule.getId(), rule.getCourseId());
        changeLog.setInfo(gson.toJson(extend));
        changeLogDao.save(changeLog);
    }

    @Override
    public void addSignUpInfoLog(List<OrgSignupCourse> courseList) {
        log.info("[ChangeLog] Add SignUp info.OrgSignupCourseList={}",courseList);
        if (courseList == null || courseList.size() < 1) {
            return;
        }
        Date date = new Date();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(KexiaoChangeEvent.ADD_SIGNUP_INFO.getType());
        changeLog.setOrgId(courseList.get(0).getOrgId());
        Gson gson = new Gson();
        SignUpCourseInfo info = new SignUpCourseInfo();
        info.addSignUpCouse(courseList);
        changeLog.setInfo(gson.toJson(info));
        changeLogDao.save(changeLog);
    }

    @Override
    public void addDelLessonsLog(Long orgId, Collection<Long> classLessonIds) {
        log.info("[ChangeLog] Del Lesson.classLessonIds={}",classLessonIds);
        if (classLessonIds == null || classLessonIds.size() < 1) {
            return;
        }
        ClassLessonInfo info = new ClassLessonInfo(classLessonIds);
        KexiaoChangeLog changeLog = constructLog(orgId,KexiaoChangeEvent.DEL_LESSON,info);
        changeLogDao.save(changeLog);
    }

    @Override
    public void addDelStuLessonsLog(Long orgId, Collection<Long> stuLessonIds) {
        log.info("[ChangeLog] Del Student Lesson.stuLessonIds={}",stuLessonIds);
        if (stuLessonIds == null || stuLessonIds.size() < 1) {
            return;
        }
        StudentLessonInfo info = new StudentLessonInfo(stuLessonIds);
        KexiaoChangeLog changeLog = constructLog(orgId,KexiaoChangeEvent.DEL_STUDENT_LESSON,info);
        changeLogDao.save(changeLog);
    }

    @Override
    public void addModifyStuLessonsLog(Long orgId, Collection<Long> stuLessonIds) {
        log.info("[ChangeLog] Modify Student Lesson.stuLessonIds={}",stuLessonIds);
        if (stuLessonIds == null || stuLessonIds.size() < 1) {
            return;
        }
        StudentLessonInfo info = new StudentLessonInfo(stuLessonIds);
        KexiaoChangeLog changeLog = constructLog(orgId,KexiaoChangeEvent.STUDENT_LESSON_CHANGE,info);
        changeLogDao.save(changeLog);
    }

    @Override
    public void addCancelSignLog(Long orgId, Collection<Long> stuLessonIds) {
        log.info("[ChangeLog] Cancel Sign.stuLessonIds={}",stuLessonIds);
        if (stuLessonIds == null || stuLessonIds.size() < 1) {
            return;
        }
        StudentLessonInfo info = new StudentLessonInfo(stuLessonIds);
        KexiaoChangeLog changeLog = constructLog(orgId,KexiaoChangeEvent.CANCEL_SIGN,info);
        changeLogDao.save(changeLog);
    }

    private KexiaoChangeLog constructLog(Long orgId,KexiaoChangeEvent event,ChangeLogInfo info){
        Date date = new Date();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(event.getType());
        changeLog.setOrgId(orgId);
        Gson gson = new Gson();
        changeLog.setInfo(gson.toJson(info));
        return changeLog;
    }
}
