package com.baijia.tianxiao.sal.kexiao.service;

import com.baijia.tianxiao.sal.kexiao.dto.LessonKexiaoStatisticsDto;

import java.util.Collection;
import java.util.Map;

/**
 * @author : fulinyu
 * @title : KexiaoStatisticsService
 * @description : 课消相关统计(按校区/班级/学员统计报名,超排,退费,转出,已消数据).设计为只根据ids统计,至于筛选逻辑,需在其它service实现到相关ids的映射
 * @date : 2017年8月23日
 */
public interface KexiaoStatisticsService {

    /**
     * 获取校区的报名统计
     *
     * @param orgIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfOrg(Collection<Long> orgIds);

    /**
     * 获取班级的报名统计
     *
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfClass(Collection<Long> classIds);

    /**
     * 获取学员在班级的报名统计
     * @param userId
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfStudentClass(Long userId, Collection<Long> classIds);

    /**
     * 获取学员的报名统计
     *
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfStudent(Collection<Long> userIds);

    /**
     * 获取班级学员的报名统计
     * @param classId
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getSignupCourseStatisticsMapOfClassStudent(Long classId, Collection<Long> userIds);


    /**
     * 获取校区的超排(赠送)统计
     *
     * @param orgIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfOrg(Collection<Long> orgIds);

    /**
     * 获取班级的超排(赠送)统计
     *
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfClass(Collection<Long> classIds);

    /**
     * 获取学员在班级的超排(赠送)统计
     * @param userId
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfStudentClass(Long userId, Collection<Long> classIds);

    /**
     * 获取学员的超排(赠送)统计
     *
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfStudent(Collection<Long> userIds);

    /**
     * 获取班级学员的超排(赠送)统计
     * @param classId
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getLessonFreeMapOfClassStudent(Long classId, Collection<Long> userIds);

    /**
     * 获取校区的已消统计
     *
     * @param orgIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfOrg(Collection<Long> orgIds);

    /**
     * 获取班级的已消统计
     *
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfClass(Collection<Long> classIds);

    /**
     * 获取学员在班级的已消统计
     * @param userId
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfStudentClass(Long userId, Collection<Long> classIds);

    /**
     * 获取学员的已消统计
     *
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfStudent(Collection<Long> userIds);

    /**
     * 获取班级学员的已消统计
     * @param classId
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getKexiaoFinishedMapOfClassStudent(Long classId, Collection<Long> userIds);

    /**
     * 获取校区的退费统计
     *
     * @param orgIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfOrg(Collection<Long> orgIds);

    /**
     * 获取班级的退费统计
     *
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfClass(Collection<Long> classIds);

    /**
     * 获取学员在班级的退费统计
     * @param userId
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfStudentClass(Long userId, Collection<Long> classIds);

    /**
     * 获取学员的退费统计
     *
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfStudent(Collection<Long> userIds);

    /**
     * 获取班级学员的退费统计
     * @param classId
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getRefundMapOfClassStudent(Long classId, Collection<Long> userIds);

    /**
     * 获取校区的转班统计
     *
     * @param orgIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfOrg(Collection<Long> orgIds);

    /**
     * 获取班级的转班统计
     *
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfClass(Collection<Long> classIds);

    /**
     * 获取学员在班级的转班统计
     * @param userId
     * @param classIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfStudentClass(Long userId, Collection<Long> classIds);

    /**
     * 获取学员的转班统计
     *
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfStudent(Collection<Long> userIds);

    /**
     * 获取班级学员的转班统计
     * @param classId
     * @param userIds
     * @return
     */
    Map<Long, LessonKexiaoStatisticsDto> getTransferMapOfClassStudent(Long classId, Collection<Long> userIds);

}
