package com.baijia.tianxiao.sal.kexiao.dto;

import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

import java.util.List;
import java.util.Map;

/**
 * @author : fulinyu
 * @title : LessonKexiaoStatisticsDto
 * @description : 课节课消统计类[数量及金额](用于统计:报名,超排(赠送),退费,转出,已消等相关信息)
 * @date : 2017年8月23日
 */
@Data
public class LessonKexiaoStatisticsDto {

    /**
     * 分钟数及金额(金额的单位为分)
     */
    private Long minutes = 0l;
    private Long minutesMoneyLong = 0l;

    /**
     * 次数及金额(金额的单位为分)
     */
    private Long times = 0l;
    private Long timesMoneyLong = 0l;


    public static boolean isZeroMap(Map<Long, LessonKexiaoStatisticsDto> dtoMap) {
        if (MapUtils.isEmpty(dtoMap)) {
            return true;
        }
        for (Long id : dtoMap.keySet()) {
            if (!LessonKexiaoStatisticsDto.isZero(dtoMap.get(id))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isZeroList(List<LessonKexiaoStatisticsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return true;
        }
        for (LessonKexiaoStatisticsDto dto : dtoList) {
            if (!LessonKexiaoStatisticsDto.isZero(dto)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(LessonKexiaoStatisticsDto dto) {
        if (dto == null) {
            return true;
        }
        if (dto.getMinutes() == 0 && dto.getMinutesMoneyLong() == 0 && dto.getTimes() == 0 && dto.getTimesMoneyLong() == 0) {
            return true;
        }
        return false;
    }

    public void addFromMinutes(long minutes, long minutesMoneyLong) {
        this.minutes = this.minutes + minutes;
        this.minutesMoneyLong = this.minutesMoneyLong + minutesMoneyLong;
    }

    public void addFromTimes(long times, long timesMoneyLong) {
        this.times = this.times + times;
        this.timesMoneyLong = this.timesMoneyLong + timesMoneyLong;
    }

    public void addFromMinutesAndTimes(long minutes, long minutesMoneyLong, long times, long timesMoneyLong) {
        this.addFromMinutes(minutes, minutesMoneyLong);
        this.addFromTimes(times, timesMoneyLong);
    }

    public void add(LessonKexiaoStatisticsDto dto) {
        if (!LessonKexiaoStatisticsDto.isZero(dto)) {
            this.addFromMinutesAndTimes(dto.getMinutes(), dto.getMinutesMoneyLong(), dto.getTimes(), dto.getTimesMoneyLong());
        }
    }
}
