/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.kexiao.service.impl;

import com.baijia.tianxiao.constant.KexiaoChangeEvent;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.org.dao.KexiaoChangeLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.KexiaoChangeLog;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.sal.kexiao.dto.BatchSignInfo;
import com.baijia.tianxiao.sal.kexiao.dto.FastSignInfo;
import com.baijia.tianxiao.sal.kexiao.dto.LessonStartInfo;
import com.baijia.tianxiao.sal.kexiao.dto.RuleChangeInfo;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoMonitorService;
import com.baijia.tianxiao.sal.kexiao.utils.KexiaoUtil;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KexiaoMonitorServiceImpl
implements KexiaoMonitorService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoMonitorServiceImpl.class);
    @Autowired
    private KexiaoChangeLogDao changeLogDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgStudentKexiaoRecordDao kexiaoRecordDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgLessonSignDao lessonSignDao;

    @Override
    public void validate(Long orgId, Date startTime, Date endTime) {
        List changeLogs = this.changeLogDao.selectByTime(orgId, startTime, endTime, new String[0]);
        HashSet<Long> stuLessonIds = new HashSet<Long>();
        HashSet<Long> courseIds = new HashSet<Long>();
        Gson gson = new Gson();
        if (changeLogs != null && changeLogs.size() > 0) {
            block6: for (KexiaoChangeLog changeLog : changeLogs) {
                KexiaoChangeEvent event = KexiaoChangeEvent.getByType((int)changeLog.getEventType());
                switch (event) {
                    case KEXIAO_REUL: {
                        RuleChangeInfo ruleChange = (RuleChangeInfo)gson.fromJson(changeLog.getInfo(), RuleChangeInfo.class);
                        courseIds.add(ruleChange.getCourseId());
                        continue block6;
                    }
                    case START: {
                        LessonStartInfo start = (LessonStartInfo)gson.fromJson(changeLog.getInfo(), LessonStartInfo.class);
                        stuLessonIds.addAll(start.getStuLessonIds());
                    }
                    case BATCH_SIGN: {
                        BatchSignInfo batchSign = (BatchSignInfo)gson.fromJson(changeLog.getInfo(), BatchSignInfo.class);
                        List batchSignLessons = this.studentLessonDao.getByLessonIdsStudentIds(batchSign.getClassLessonIds(), batchSign.getUserIds(), new String[]{"id"});
                        List ids = ListUtil.toKeyList((Collection)batchSignLessons, (String)"id", OrgStudentLesson.class);
                        stuLessonIds.addAll(ids);
                        continue block6;
                    }
                    case FAST_SIGN: {
                        FastSignInfo sign = (FastSignInfo)gson.fromJson(changeLog.getInfo(), FastSignInfo.class);
                        List lessons = this.studentLessonDao.getByLessonIdsStudentIds(sign.getClassLessonIds(), sign.getStuStatus().keySet(), new String[]{"id"});
                        List lessonIds = ListUtil.toKeyList((Collection)lessons, (String)"id", OrgStudentLesson.class);
                        stuLessonIds.addAll(lessonIds);
                        continue block6;
                    }
                }
                log.warn("[Kexiao] KexiaoChangeLog={}", (Object)changeLog);
                throw new RuntimeException("KexiaoChangeEvent error");
            }
        }
        if (courseIds.size() > 0) {
            this.validateByCourseId(orgId, courseIds);
        }
        if (stuLessonIds.size() > 0) {
            this.validateByLessonIds(orgId, stuLessonIds);
        }
    }

    private void validateByCourseId(Long orgId, Set<Long> courseIds) {
        List classLessons = this.classLessonDao.getLessonByCourseIds(courseIds, Integer.valueOf(0), new String[]{"id"});
        List lessonIds = ListUtil.toKeyList((Collection)classLessons, (String)"id", OrgClassLesson.class);
        List lessons = this.studentLessonDao.getOrgStudentLessonsByLessonIds((Collection)lessonIds, new String[0]);
        this.validateLessonStatus(orgId, lessons);
    }

    private void validateByLessonIds(Long orgId, Set<Long> stuLessonIds) {
        List studentLessons = this.studentLessonDao.getByIds(stuLessonIds, new String[0]);
        this.validateLessonStatus(orgId, studentLessons);
    }

    private void validateLessonStatus(Long orgId, List<OrgStudentLesson> studentLessons) {
        List stuLessonIds = ListUtil.toKeyList(studentLessons, (String)"id", OrgStudentLesson.class);
        List classLessonIds = ListUtil.toKeyList(studentLessons, (String)"lessonId", OrgStudentLesson.class);
        List classLessons = this.classLessonDao.getByIds((Collection)classLessonIds, new String[0]);
        Map classLessonMap = CollectionHelper.toIdMap((Collection)classLessons);
        List courseIds = ListUtil.toKeyList((Collection)classLessons, (String)"courseId", OrgClassLesson.class);
        List rules = this.courseConsumeRuleDao.queryConsumRuleListByCourseIds(orgId, (Collection)courseIds, new String[0]);
        Map ruleMap = CollectionHelper.toKeyMap((Collection)rules, (String)"courseId");
        List lessonSigns = this.lessonSignDao.getByStudentLessonIds((Collection)stuLessonIds, new String[0]);
        Map signMap = CollectionHelper.toKeyMap((Collection)lessonSigns, (String)"lessonId");
        List records = this.kexiaoRecordDao.getByStuLessonIds(orgId, (Collection)stuLessonIds, new String[0]);
        Map recordMap = CollectionHelper.toKeyMap((Collection)records, (String)"studentLessonId");
        for (OrgStudentLesson studentLesson : studentLessons) {
            OrgLessonSign sign;
            OrgClassLesson classLesson = (OrgClassLesson)classLessonMap.get(studentLesson.getLessonId());
            OrgCourseConsumeRule rule = (OrgCourseConsumeRule)ruleMap.get(classLesson.getCourseId());
            LessonStatus status = rule == null || rule.getRuleValue() == 0 ? (classLesson.getStartTime().compareTo(new Date()) > 0 ? LessonStatus.UN_START : LessonStatus.FINISHED) : ((sign = (OrgLessonSign)signMap.get(studentLesson.getId())) != null ? KexiaoUtil.getKexiaoStatus(sign.getStatus(), rule.getRuleValue()) : LessonStatus.UN_START);
            OrgStudentKexiaoRecord record = (OrgStudentKexiaoRecord)recordMap.get(studentLesson.getId());
            if (record == null) {
                if (status == LessonStatus.UN_START) continue;
                log.error("[Kexiao]Kexiao status is error.expect status={},current status={}", (Object)status, (Object)LessonStatus.UN_START);
                continue;
            }
            if (status == LessonStatus.FINISHED) continue;
            log.error("[Kexiao]Kexiao status is error.expect status={},current status={}", (Object)status, (Object)LessonStatus.FINISHED);
        }
    }
}

