package com.baijia.tianxiao.sal.kexiao.service;

import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/12/6.
 */
public interface KexiaoChangeLogService {

    /**
     * 课程开始日志
     */
    public void addLessonStartedLog(Collection<Long> stuLessonIds,Integer status);

    /**
     * 课消规则变化日志
     */
    public void addRuleChangedLog(OrgCourseConsumeRule rule);

    /**
     * 补充报名信息日志
     */
    public void addSignUpInfoLog(List<OrgSignupCourse> courseList);

    /**
     * 批量签到
     * @param orgId
     * @param userIds
     * @param classLessonIds
     * @param status
     */
    public void addBatchSignLog(Long orgId,Collection<Long> userIds,Collection<Long> classLessonIds,int status);

    /**
     * 快速签到
     * @param orgId
     * @param classLessonIds
     * @param stuStatus
     */
    public void addFastSignLog(Long orgId,Collection<Long> classLessonIds,Map<Long,Integer> stuStatus);

    /**
     * 删除课节
     * @param orgId
     * @param classLessonIds
     */
    public void addDelLessonsLog(Long orgId,Collection<Long> classLessonIds);

    /**
     * 删除学生课节
     * @param orgId
     * @param stuLessonIds
     */
    public void addDelStuLessonsLog(Long orgId,Collection<Long> stuLessonIds);

    /**
     * 修改学生课节
     * @param orgId
     * @param stuLessonIds
     */
    public void addModifyStuLessonsLog(Long orgId,Collection<Long> stuLessonIds);

    /**
     * 取消签到
     * @param orgId
     * @param stuLessonIds
     */
    public void addCancelSignLog(Long orgId,Collection<Long> stuLessonIds);

}
