/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.kexiao.service.impl;

import com.baijia.tianxiao.constant.KexiaoChangeEvent;
import com.baijia.tianxiao.dal.org.dao.KexiaoChangeLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.KexiaoChangeLog;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sal.kexiao.dto.BatchSignInfo;
import com.baijia.tianxiao.sal.kexiao.dto.ChangeLogInfo;
import com.baijia.tianxiao.sal.kexiao.dto.ClassLessonInfo;
import com.baijia.tianxiao.sal.kexiao.dto.FastSignInfo;
import com.baijia.tianxiao.sal.kexiao.dto.LessonStartInfo;
import com.baijia.tianxiao.sal.kexiao.dto.RuleChangeInfo;
import com.baijia.tianxiao.sal.kexiao.dto.SignUpCourseInfo;
import com.baijia.tianxiao.sal.kexiao.dto.StudentLessonInfo;
import com.baijia.tianxiao.sal.kexiao.service.KexiaoChangeLogService;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KexiaoChangeLogServiceImpl
implements KexiaoChangeLogService {
    private static final Logger log = LoggerFactory.getLogger(KexiaoChangeLogServiceImpl.class);
    @Autowired
    private KexiaoChangeLogDao changeLogDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;

    @Override
    public void addBatchSignLog(Long orgId, Collection<Long> userIds, Collection<Long> classLessonIds, int status) {
        log.info("[ChangeLog] Batch sign.userIds={},classLessonIds={},status={}", new Object[]{userIds, classLessonIds, status});
        if (userIds == null || userIds.size() < 1) {
            return;
        }
        if (classLessonIds == null || classLessonIds.size() < 1) {
            return;
        }
        Date date = new Date();
        ArrayList<KexiaoChangeLog> changeLogList = new ArrayList<KexiaoChangeLog>();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(Integer.valueOf(KexiaoChangeEvent.BATCH_SIGN.getType()));
        changeLog.setOrgId(orgId);
        BatchSignInfo batchSign = new BatchSignInfo(userIds, classLessonIds, status);
        Gson gson = new Gson();
        changeLog.setInfo(gson.toJson((Object)batchSign));
        changeLogList.add(changeLog);
        this.changeLogDao.batchInsertChangeLogs(changeLogList);
    }

    @Override
    public void addFastSignLog(Long orgId, Collection<Long> classLessonIds, Map<Long, Integer> stuStatus) {
        log.info("[ChangeLog] Fast sign.classLessonIds={},stuStatus={}", classLessonIds, stuStatus);
        if (stuStatus == null || stuStatus.size() < 1) {
            return;
        }
        if (classLessonIds == null || classLessonIds.size() < 1) {
            return;
        }
        Date date = new Date();
        ArrayList<KexiaoChangeLog> changeLogList = new ArrayList<KexiaoChangeLog>();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(Integer.valueOf(KexiaoChangeEvent.FAST_SIGN.getType()));
        changeLog.setOrgId(orgId);
        FastSignInfo fastSign = new FastSignInfo(classLessonIds, stuStatus);
        Gson gson = new Gson();
        changeLog.setInfo(gson.toJson((Object)fastSign));
        changeLogList.add(changeLog);
        this.changeLogDao.batchInsertChangeLogs(changeLogList);
    }

    @Override
    public void addLessonStartedLog(Collection<Long> lessonIds, Integer status) {
        log.info("[ChangeLog] Lesson started.lessonIds={},status={}", lessonIds, (Object)status);
        if (lessonIds == null || lessonIds.size() < 1) {
            return;
        }
        List lessons = this.studentLessonDao.getOrgStudentLessonsByLessonIds(lessonIds, new String[]{"id", "startStatus", "orgId"});
        HashMap<Long, ArrayList<Long>> map = new HashMap<Long, ArrayList<Long>>();
        for (OrgStudentLesson lesson : lessons) {
            ArrayList<Long> list = (ArrayList<Long>)map.get(lesson.getOrgId());
            if (list == null) {
                list = new ArrayList<Long>();
                map.put(lesson.getOrgId(), list);
            }
            list.add(lesson.getId());
        }
        ArrayList<KexiaoChangeLog> logs = new ArrayList<KexiaoChangeLog>();
        for (Long orgId : map.keySet()) {
            List list = (List)map.get(orgId);
            Date date = new Date();
            KexiaoChangeLog changeLog = new KexiaoChangeLog();
            changeLog.setCreateTime(date);
            changeLog.setEventType(Integer.valueOf(KexiaoChangeEvent.START.getType()));
            changeLog.setOrgId(orgId);
            LessonStartInfo lessonStart = new LessonStartInfo(list, status);
            Gson gson = new Gson();
            changeLog.setInfo(gson.toJson((Object)lessonStart));
            logs.add(changeLog);
        }
        this.changeLogDao.batchInsertChangeLogs(logs);
    }

    @Override
    public void addRuleChangedLog(OrgCourseConsumeRule rule) {
        log.info("[ChangeLog] Change Rule.OrgCourseConsumeRule={}", (Object)rule);
        if (rule == null) {
            return;
        }
        Date date = new Date();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(Integer.valueOf(KexiaoChangeEvent.KEXIAO_REUL.getType()));
        changeLog.setOrgId(rule.getOrgId());
        Gson gson = new Gson();
        RuleChangeInfo extend = new RuleChangeInfo(rule.getRuleValue(), rule.getId(), rule.getCourseId());
        changeLog.setInfo(gson.toJson((Object)extend));
        this.changeLogDao.save((Object)changeLog, new String[0]);
    }

    @Override
    public void addSignUpInfoLog(List<OrgSignupCourse> courseList) {
        log.info("[ChangeLog] Add SignUp info.OrgSignupCourseList={}", courseList);
        if (courseList == null || courseList.size() < 1) {
            return;
        }
        Date date = new Date();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(Integer.valueOf(KexiaoChangeEvent.ADD_SIGNUP_INFO.getType()));
        changeLog.setOrgId(courseList.get(0).getOrgId());
        Gson gson = new Gson();
        SignUpCourseInfo info = new SignUpCourseInfo();
        info.addSignUpCouse(courseList);
        changeLog.setInfo(gson.toJson((Object)info));
        this.changeLogDao.save((Object)changeLog, new String[0]);
    }

    @Override
    public void addDelLessonsLog(Long orgId, Collection<Long> classLessonIds) {
        log.info("[ChangeLog] Del Lesson.classLessonIds={}", classLessonIds);
        if (classLessonIds == null || classLessonIds.size() < 1) {
            return;
        }
        ClassLessonInfo info = new ClassLessonInfo(classLessonIds);
        KexiaoChangeLog changeLog = this.constructLog(orgId, KexiaoChangeEvent.DEL_LESSON, info);
        this.changeLogDao.save((Object)changeLog, new String[0]);
    }

    @Override
    public void addDelStuLessonsLog(Long orgId, Collection<Long> stuLessonIds) {
        log.info("[ChangeLog] Del Student Lesson.stuLessonIds={}", stuLessonIds);
        if (stuLessonIds == null || stuLessonIds.size() < 1) {
            return;
        }
        StudentLessonInfo info = new StudentLessonInfo(stuLessonIds);
        KexiaoChangeLog changeLog = this.constructLog(orgId, KexiaoChangeEvent.DEL_STUDENT_LESSON, info);
        this.changeLogDao.save((Object)changeLog, new String[0]);
    }

    @Override
    public void addModifyStuLessonsLog(Long orgId, Collection<Long> stuLessonIds) {
        log.info("[ChangeLog] Modify Student Lesson.stuLessonIds={}", stuLessonIds);
        if (stuLessonIds == null || stuLessonIds.size() < 1) {
            return;
        }
        StudentLessonInfo info = new StudentLessonInfo(stuLessonIds);
        KexiaoChangeLog changeLog = this.constructLog(orgId, KexiaoChangeEvent.STUDENT_LESSON_CHANGE, info);
        this.changeLogDao.save((Object)changeLog, new String[0]);
    }

    @Override
    public void addCancelSignLog(Long orgId, Collection<Long> stuLessonIds) {
        log.info("[ChangeLog] Cancel Sign.stuLessonIds={}", stuLessonIds);
        if (stuLessonIds == null || stuLessonIds.size() < 1) {
            return;
        }
        StudentLessonInfo info = new StudentLessonInfo(stuLessonIds);
        KexiaoChangeLog changeLog = this.constructLog(orgId, KexiaoChangeEvent.CANCEL_SIGN, info);
        this.changeLogDao.save((Object)changeLog, new String[0]);
    }

    private KexiaoChangeLog constructLog(Long orgId, KexiaoChangeEvent event, ChangeLogInfo info) {
        Date date = new Date();
        KexiaoChangeLog changeLog = new KexiaoChangeLog();
        changeLog.setCreateTime(date);
        changeLog.setEventType(Integer.valueOf(event.getType()));
        changeLog.setOrgId(orgId);
        Gson gson = new Gson();
        changeLog.setInfo(gson.toJson((Object)info));
        return changeLog;
    }
}

