package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.solr.constant.ConsultConstant;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.PCStudentOrderEnum;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.dal.solr.utils.SolrUtil;
import com.baijia.tianxiao.sal.elastic.service.TxConsultUserQueryService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class TxConsultUserQuerySeviceImpl extends AbstractEsBaseServiceImpl implements TxConsultUserQueryService {
    @Autowired
    private CustomFieldDao customFieldDao;
    private static final Long ONE_DAY_TIME = 86400000L;

    private final static Set<String> KEYWORD_FIELD = new HashSet<>();

    static {
        KEYWORD_FIELD.add("parent_name");
        KEYWORD_FIELD.add("tag");
        KEYWORD_FIELD.add("_parent_name");
        KEYWORD_FIELD.add("school");
        KEYWORD_FIELD.add("name");
    }

    protected boolean isKeywordField(String key) {
        return KEYWORD_FIELD.contains(key);
    }

    @Override
    public List<ConsulterListDto> searchConsultFromEs(ConsulterListQueryParam param, PageDto pageDto) {
        log.info("[ES] consult query param={}", param);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();

        queryBuilder = queryBuilder
                .must(QueryBuilders.matchPhraseQuery("org_id", param.getOrgId()))
                .must(QueryBuilders.matchPhraseQuery("del_status", 0))
                .must(QueryBuilders.matchPhraseQuery("student_id",0))
                .must(QueryBuilders.matchPhraseQuery("is_consulter",1));

        if (param.getConsulterType() != ConsultConstant.INVALID) {
            if (param.getCascadeIdSet() != null && param.getCascadeIdSet().size() > 0) {
                queryBuilder.must(QueryBuilders.termsQuery("cascade_id", param.getCascadeIdSet()));
            }
        }else{
            if(param.getInvalidDayNum()!=null){

            }
        }

        // 筛选线索的有效性
        if (param.getIsInvalid() != null) {
            queryBuilder.must(getMatchQuery("is_invalid", param.getIsInvalid()));
        }

        if (StringUtils.isNotBlank(param.getKeyFieldName()) && StringUtils.isNotBlank(param.getKeyword())) {
            String name = toEsField(param.getKeyFieldName());
            String query = param.getKeyword();
            if (name.equals("")) {
                if (param.getKeyFieldName().startsWith("customField")) {
                    String numStr = param.getKeyFieldName().replace("customField", "");
                    CustomField field =
                        this.customFieldDao.getCustomFieldById(param.getOrgId(), Long.parseLong(numStr));
                    Integer type = field.getType();
                    String searchNamePre = "custom_field" + "." + numStr;
                    String searchName = "";

                    if (type == 1) {
                        searchName = searchNamePre + "." + "content.keyword";
                    }
                    queryBuilder = queryBuilder.must(QueryBuilders.wildcardQuery(searchName, "*" + query + "*"));
                }
            } else {
                if (isKeywordField(name)) {
                    name = name + ".keyword";
                }
                queryBuilder = queryBuilder.must(QueryBuilders.wildcardQuery(name, "*" + query + "*"));
            }
        }

        if (StringUtils.isBlank(param.getKeyFieldName())) {
            if (StringUtils.isNotBlank(param.getKeyword())) {
                BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
                shouldBuilder.should().add(getWildcardQuery("name.keyword", param.getKeyword()));
                if (NumberUtils.isDigits(param.getKeyword()) && param.getKeyword().length() >= 3) {
                    shouldBuilder.should().add(getWildcardQuery("_mobile", param.getKeyword()));
                }
                shouldBuilder.should().add(getWildcardQuery("tag.keyword", param.getKeyword()));
                queryBuilder.must(shouldBuilder);
            }
        }
        if (GenericsUtils.notNullAndEmpty(param.getSex())) {
            queryBuilder = queryBuilder.must(QueryBuilders.matchPhraseQuery("sex", param.getSex()));
        }

        if (param.getConsultStatus() != null) {
            int consultstatus = param.getConsultStatus();
            queryBuilder = queryBuilder.must(QueryBuilders.matchPhraseQuery("consult_status", consultstatus));
        }
        if (GenericsUtils.notNullAndEmpty(param.getLastRemindTimeState())) {
            int lastRemindTimeStatus = param.getLastRemindTimeState();
            param.setDateFieldKey("lastRemindTime");
            TimeType timeType=TimeType.getTimeTypeByCode(lastRemindTimeStatus);
            TimeRange timeRange=timeType.timeRange();
            param.setStart(timeRange.getStartTime());
            param.setEnd(timeRange.getEndTime());
        }
        if (GenericsUtils.notNullAndEmpty(param.getRecentBrowseDayNum())) {
            param.setDateFieldKey("lastBrowseTime");
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, -7);
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            Date start = calendar.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            Date end = calendarEnd.getTime();
            param.setStart(start);
            param.setEnd(end);

        }
        if (GenericsUtils.notNullAndEmpty(param.getRemindDayNum())) {
            param.setDateFieldKey("lastRemindTime");
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, -7);
            calendar.set(Calendar.HOUR_OF_DAY, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            Date start = calendar.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            Date end = calendarEnd.getTime();
            param.setStart(start);
            param.setEnd(end);

        }
        if (GenericsUtils.notNullAndEmpty(param.getMinRemainingDay())
            || GenericsUtils.notNullAndEmpty(param.getMaxRemainingDay())) {
            param.setDateFieldKey("FinallyHoldTime");

            if(GenericsUtils.notNullAndEmpty(param.getMinRemainingDay())&&param.getMinRemainingDay()==1) {
               param.setMinRemainingDay("0");
            }
            Date date = new Date();
            if(GenericsUtils.notNullAndEmpty(param.getMinRemainingDay())) {

                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtil.getStartOfDayAccurateToMillSeconde(date));
                calendar.add(Calendar.DATE, param.getMinRemainingDay());
                Date start = calendar.getTime();
                param.setStart(start);
            }

            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.setTime(DateUtil.getStartOfDayAccurateToMillSeconde(date));
            calendarEnd.add(Calendar.DATE, param.getMaxRemainingDay()+1);
            Date end = calendarEnd.getTime();
            if(GenericsUtils.isNullOrEmpty(param.getMinRemainingDay())){
                param.setStart(new Date(0));
            }

            param.setEnd(end);

        }

        // 按时间筛选
        if (param.getDateFieldKey() != null) {
            String dateFieldKey = ClientUtils.escapeQueryChars(param.getDateFieldKey());
            String keyFieldName = toEsField(dateFieldKey);
            if (!keyFieldName.equals("")) {// 系统字段
                queryBuilder.must(getTimestampRangeQueryBuilder(keyFieldName, param.getStart(), param.getEnd()));
            } else {
                String customDateKey =
                    "custom_field." + param.getDateFieldKey().replace("customField", "") + ".content";
                queryBuilder.must(getTimestampRangeQueryBuilder(customDateKey, param.getStart(), param.getEnd()));
            }
        }

        if (param.getConsultSource() != null) {
            queryBuilder =
                queryBuilder.must(QueryBuilders.matchPhraseQuery("consult_source", param.getConsultSource()));
        }
        if (GenericsUtils.notNullAndEmpty(param.getCascadeForSearch())) {
            queryBuilder = queryBuilder.must(QueryBuilders.matchPhraseQuery("cascade_id", param.getCascadeForSearch()));
        }
        if (GenericsUtils.notNullAndEmpty(param.getIntentLevel())) {
            queryBuilder = queryBuilder.must(QueryBuilders.matchPhraseQuery("intension_level", param.getIntentLevel()));
        }
        if (param.getBirthMonth() != null && param.getBirthMonth() > 0) {
            queryBuilder = queryBuilder.must(QueryBuilders.matchPhraseQuery("birthMonth", param.getBirthMonth()));

        }
        if (param.getBirthDayOfMonth() != null && param.getBirthDayOfMonth() > 0) {
            queryBuilder =
                queryBuilder.must(QueryBuilders.matchPhraseQuery("birthDayOfMonth", param.getBirthDayOfMonth()));
        }
        if (param.getBirthYear() != null && param.getBirthYear() > 0) {
            queryBuilder = queryBuilder.must(QueryBuilders.matchQuery("birthYear", param.getBirthYear()));
        }

        if (StringUtils.isNotBlank(param.getSelectFieldKey()) && param.getSelectFieldValue() != null) {
            String selectKey = param.getSelectFieldKey().replace("customField", "");

            queryBuilder = queryBuilder
                .must(getMatchQuery(getCustomFieldKey(selectKey, param.getOrgId()), param.getSelectFieldValue()));
        }
        SortBuilder sortBuilder = null;
        if (param.isPinyinSort()) {
            sortBuilder = SortBuilders.fieldSort("pinyin.keyword").order(SortOrder.ASC);
        } else {
            sortBuilder = SortBuilders.fieldSort("last_remind_time").order(SortOrder.DESC);
        }
        if (GenericsUtils.notNullAndEmpty(param.getPropName())) {
            String orderName = toEsField(param.getPropName());
            if (orderName.equals("pinyin")) {
                orderName = orderName + ".keyword";
            }
            if (param.getSortType() == 0) {
                sortBuilder = SortBuilders.fieldSort(orderName).order(SortOrder.ASC);
            }
            if (param.getSortType() == 1) {
                sortBuilder = SortBuilders.fieldSort(orderName).order(SortOrder.DESC);
            }
        }

        log.info("[ES] consult user query param={}", queryBuilder.toString());

        SearchResponse searchResponse = getClient().prepareSearch("consult_users").setTypes("consult_user")
            .setQuery(queryBuilder).addSort(sortBuilder).setFrom((pageDto.getPageNum() - 1) * pageDto.getPageSize())
            .setSize(pageDto.getPageSize()).execute().actionGet();
        SearchHits hits = searchResponse.getHits();

        log.info("[ES] consult query size={}", hits.getTotalHits());

        pageDto.setCount((int) hits.getTotalHits());

        SearchHit[] searchHits = hits.hits();
        List<ConsulterListDto> list = new ArrayList<>();
        for (SearchHit hit : searchHits) {
            String consultJson = hit.getSourceAsString();
            try {
                Map consultMap = JacksonUtil.str2Obj(consultJson, new TypeReference<Map<String, Object>>() {
                });

                ConsulterListDto consulterListDto = mapToConsult(consultMap);
                list.add(consulterListDto);
            } catch (IOException e) {
                log.error("json transport fail{}", consultJson);
            }
        }
        return list;
    }

    private String toEsField(String fieldname) {
        if (fieldname.equals("name")) {
            return "name";
        } else if (fieldname.equals("mobile")) {
            return "_mobile";
        } else if (fieldname.equals("parentName")) {
            return "_parent_name";
        } else if (fieldname.equals("parentMobile")) {
            return "_parent_mobile";
        } else if (fieldname.equals("tag")) {
            return "tag";
        } else if (fieldname.equals("nextRemindTime")) {
            return "next_remind_time";
        } else if (fieldname.equals("lastFollowTime")) {
            return "last_follow_time";
        } else if (fieldname.equals("createTime")) {
            return "create_time";
        } else if (fieldname.equals("updateTime")) {
            return "update_time";
        } else if (fieldname.equals("birthday")) {
            return "birthday";
        } else if (fieldname.equals("intensionLevelStr")) {
            return "intension_level";
        } else if (fieldname.equals("cascadeId")) {
            return "cascade_id";
        } else if (fieldname.equals("cascadeIdStr")) {
            return "cascade_id";
        } else if ("birthdayStr".equals(fieldname)) {
            return "birthday";
        } else if ("createTimeStr".equals(fieldname)) {
            return "create_time";
        } else if ("lastRemindTime".equals(fieldname)) {
            return "last_remind_time";
        } else if ("lastRemindTimeStr".equals(fieldname)) {
            return "last_remind_time";
        } else if ("lastBrowseTime".equals(fieldname)) {
            return "last_browse_time";
        } else if("FinallyHoldTime".equals(fieldname)){
            return "finally_hold_time";
        }else {
            return "";
        }
    }

    private ConsulterListDto mapToConsult(Map map) {
        ConsulterListDto consulterListDto = new ConsulterListDto();
        if (GenericsUtils.notNullAndEmpty(map.get("_mobile"))) {
            consulterListDto.setMobile(map.get("_mobile").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("cascade_id"))) {
            consulterListDto.setCascadeId(Integer.parseInt(map.get("cascade_id").toString()));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("address"))) {
            consulterListDto.setAddress(map.get("address").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("birthday"))) {
            String birth = map.get("birthday").toString();
            Long birthNum = Long.parseLong(birth);
            Date birthday = null;
            if (birthNum > 0) {
                birthday = new Date(Long.parseLong(birth));
            }
            consulterListDto.setBirthday(birthday);

        }
        if (GenericsUtils.notNullAndEmpty(map.get("consult_source"))) {
            consulterListDto.setConsultSource(Integer.parseInt(map.get("consult_source").toString()));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("consult_status"))) {
            consulterListDto.setConsultStatus(Integer.parseInt(map.get("consult_status").toString()));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("create_time"))) {
            String createTime = map.get("create_time").toString();
            consulterListDto.setCreateTime(new Date(Long.parseLong(createTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("degree_class"))) {
            consulterListDto.setDegreeClass(map.get("degree_class").toString());

        }
        if (GenericsUtils.notNullAndEmpty(map.get("id"))) {
            consulterListDto.setId(Long.parseLong(map.get("id").toString()));
        }

        if (GenericsUtils.notNullAndEmpty(map.get("intension_level"))) {
            consulterListDto.setIntensionLevel(Integer.parseInt(map.get("intension_level").toString()));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("is_invalid"))) {
            consulterListDto.setIsInvalid(Integer.parseInt(map.get("is_invalid").toString()));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("mail"))) {
            consulterListDto.setMail(map.get("mail").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("name"))) {
            consulterListDto.setName(map.get("name").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("last_remind_time"))) {
            String lastRemindTime = map.get("last_remind_time").toString();
            if (Long.parseLong(lastRemindTime) > 0) {
                consulterListDto.setLastRemindTime(new Date(Long.parseLong(lastRemindTime)));
            }
        }
        if (GenericsUtils.notNullAndEmpty(map.get("next_remind_time"))) {
            String nextRemindTime = map.get("next_remind_time").toString();
            if (Long.parseLong(nextRemindTime) > 0) {
                consulterListDto.setNextRemindTime(new Date(Long.parseLong(nextRemindTime)));
            }
        }
        if (GenericsUtils.notNullAndEmpty(map.get("last_follow_time"))) {
            String lastFollowTime = map.get("last_follow_time").toString();
            if (Long.parseLong(lastFollowTime) > 0) {
                consulterListDto.setLastFollowTime(new Date(Long.parseLong(lastFollowTime)));
            }
        }
        if (GenericsUtils.notNullAndEmpty(map.get("finally_hold_time"))) {
            String finallyHoldTimeStr = map.get("finally_hold_time").toString();
            if (Long.parseLong(finallyHoldTimeStr) > 0) {
                Date finallyHoldTime=new Date(Long.parseLong(finallyHoldTimeStr));
                Integer lessDayNum = 0;
                Date now=new Date();
                if (finallyHoldTime != null && finallyHoldTime.after(now)) {
                    if (DateUtil.getStartOfDayAccurateToMillSeconde(finallyHoldTime)
                            .equals(DateUtil.getStartOfDayAccurateToMillSeconde(now))) {
                        lessDayNum = 1;
                    } else {
                        lessDayNum = (int) ((DateUtil.getStartOfDayAccurateToMillSeconde(finallyHoldTime).getTime()
                                - DateUtil.getStartOfDayAccurateToMillSeconde(now).getTime()) / ONE_DAY_TIME);
                    }
                    if (lessDayNum == 0) {
                        lessDayNum = 1;
                    }
                }
                log.info("lessDayNum is : {} for finallyHoldTime : {} ", lessDayNum, finallyHoldTime);
                consulterListDto.setTimeRemaining(lessDayNum);

            }
        }
        if (GenericsUtils.notNullAndEmpty(map.get("update_time"))) {
            String updateTime = map.get("update_time").toString();
            consulterListDto.setUpdateTime(new Date(Long.parseLong(updateTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("_parent_mobile"))) {
            consulterListDto.setParentMobile(map.get("_parent_mobile").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("_parent_name"))) {
            consulterListDto.setParentName(map.get("_parent_name").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("qq"))) {
            consulterListDto.setQq(map.get("qq").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("relatives"))) {
            consulterListDto.setRelatives(Integer.parseInt(map.get("relatives").toString()));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("school"))) {
            consulterListDto.setSchool(map.get("school").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("sex"))) {
            consulterListDto.setSex(Integer.parseInt(map.get("sex").toString()));
        }

        return consulterListDto;
    }

    // 得到上季度的第一个月

}
