package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.elastic.service.StudentLessonStatDataImportService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service
@Slf4j
public class StudentLessonStatDataImportServiceImpl extends AbstractEsBaseServiceImpl
        implements StudentLessonStatDataImportService {

    @Autowired
    private OrgStudentLessonDao studentLessonDao;

    @Autowired
    private KexiaoApiService kexiaoApiService;

    @Autowired
    private OrgStudentDao studentDao;

    @Override
    public void importByOrgId(Long orgId) {

        long time = System.currentTimeMillis();
        BulkProcessor bulkProcessor = getDefaultBulkProcessor();

        PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(3000);
        List<OrgStudent> students = studentDao.getStudents(orgId, "", 1, page, "id", "userId");
        while (students.size() > 0) {
            List<Long> userIds = ListUtil.toKeyList(students, "userId", OrgStudent.class);
            Map<Long, KexiaoStudentStat> statMap = kexiaoApiService.queryUserKexiaoStat(orgId, userIds);
            for (OrgStudent student : students) {
                bulkProcessor.add(
                        new IndexRequest()
                                .index("statistics")
                                .type("lessonStat")
                                .source(toMap(student, statMap.get(student.getUserId())))
                                .id(student.getId().toString())
                );
            }
            page.setPageNum(page.getPageNum() + 1);
            students = studentDao.getByPage(page);
        }

        bulkProcessor.flush();
        bulkProcessor.close();
        log.info("import {} data costs:{}", page.getCount(), System.currentTimeMillis() - time);
    }

    @Override
    public void fullImport() {

    }

    private Map<String, Object> toMap(OrgStudent student, KexiaoStudentStat stat) {
        Map<String, Object> ret = new HashMap<>();
        ret.put("studentId", student.getId());
        if (stat != null) {
            ret.put("userId", stat.getUserId());
            ret.put("leftAmount", stat.getLeftAmount());//剩余学费
            ret.put("kexiaoCount", stat.getKexiaoNormalCount() + stat.getKexiaoFreeCount());//已上课次
            ret.put("arrangeCount", stat.getArrangeNormalCount() + stat.getArrangeFreeCount());//已排课次
            ret.put("totalCount", stat.getTotalCount());//总课次
            ret.put("kexiaoTime", stat.getKexiaoNormalTime() + stat.getKexiaoFreeTime());//已上课时
            ret.put("arrangeTime", stat.getArrangeNormalTime() + stat.getArrangeFreeTime());//已排课时
            ret.put("totalTime", stat.getTotalTime());//总课时
            ret.put("accountAmount", stat.getLeftAmount());//账户余额
        }
        return ret;
    }
}
