
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentQueryService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;

import com.google.common.collect.Lists;

import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Mar 8, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Service
@Slf4j
public class OrgTeacherDocumentQueryServiceImpl extends AbstractEsBaseServiceImpl
    implements OrgTeacherDocumentQueryService {

    // @Autowired(required = false)
    // private MongoDBOperator mongoDBOperator;

    @SuppressWarnings("unchecked")
    @Override
    public List<Map<String, Object>> listByQuery(Integer orgId, Integer useStatus, Integer countType, Integer orderType,
        String searchKey, PageDto pageDto) {
        if (pageDto == null) {
            pageDto = new PageDto();
            pageDto.setPageNum(1);
            pageDto.setPageSize(100);
        }
        log.info("es with params -- orgID:{}", orgId);

        BoolQueryBuilder builder = new BoolQueryBuilder();
        builder.must(new TermQueryBuilder("orgId", orgId));
        if (useStatus != null) {
            builder.must(new TermQueryBuilder("useStatus", useStatus));
        } else {
            builder.must(new TermsQueryBuilder("useStatus", Lists.newArrayList(0, 1).toArray()));
        }
        if (StringUtils.isNotBlank(searchKey)) {
            builder.must(new BoolQueryBuilder().should(getWildcardQuery("name.keyword", searchKey))
                .should(getWildcardQuery("mobile.keyword", searchKey)));
        }

        String sortValue = getSolrRule(countType);

        SearchRequestBuilder srq = getClient().prepareSearch("teachers").setTypes("teacher").setQuery(builder)
            .addSort(sortValue, null != orderType && orderType == 2 ? SortOrder.DESC : SortOrder.ASC)
            .setFrom(pageDto.firstNum()).setSize(pageDto.getPageSize());

        SearchResponse response = srq.execute().actionGet();

        SearchHits hits = response.getHits();

        pageDto.setCount((int) hits.getTotalHits());

        List<Map<String, Object>> mapList = Lists.newArrayList();
        for (SearchHit hit : hits.getHits()) {
            Map<String, Object> val = hit.getSource();
            mapList.add(val);
        }
        log.info("search result size is :{} ", mapList.size());
        return mapList;
    }

    public String getSolrRule(Integer countType) {
        String field;
        switch (countType) {
            case 0:
                field = "createTime";
                break;
            case 1:
                field = "finishedClassTime";
                break;
            case 2:
                field = "hasSignupStudentCount";
                break;
            case 3:
                field = "scoreNum";
                break;
            case 4:
                field = "pauseTime";
                break;
            default:
                field = "createTime";
        }
        return field;
    }

    @Override
    public List<Map<String, Object>> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds,
        Boolean...isIdQuery) {

        boolean isId = (GenericsUtils.notNullAndEmpty(isIdQuery) ? isIdQuery[0] : true); // 默认是走ID查询
        String queryField = isId ? "orgTeacherId" : "teacherUserId";

        SearchRequestBuilder srq = getClient().prepareSearch("teachers").setTypes("teacher")
            .setQuery(new BoolQueryBuilder().must(new TermQueryBuilder("orgId", orgId))
                .must(new TermsQueryBuilder(queryField, teacherIds.toArray())));

        SearchResponse response = srq.execute().actionGet();

        SearchHits hits = response.getHits();

        List<Map<String, Object>> mapList = Lists.newArrayList();
        for (SearchHit hit : hits.getHits()) {
            Map<String, Object> val = hit.getSource();
            mapList.add(val);
        }
        return mapList;
    }

}
