package com.baijia.tianxiao.sal.elastic.service.impl;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.UserLastFollowTime;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;

import com.baijia.tianxiao.sal.elastic.service.ConsultUserDataImportService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class ConsultUserDataImportServiceImpl extends AbstractEsBaseServiceImpl implements ConsultUserDataImportService{
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxStudentTagDao tagDao;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private TxStudentCommentDao studentCommentDao;
    final long daytime=24L*60L*60L*1000L;
    @Override
    public void importByOrgId(Long orgId) {
        long time = System.currentTimeMillis();
        BulkProcessor bulkProcessor = getDefaultBulkProcessor();

      PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(3000);
        List<TxConsultUser> consultUsers =null;
        if(orgId==null) {
            consultUsers = consultUserDao.getByPage(page);
        }else {
            consultUsers = consultUserDao.getConsultUserByOrgIdAndPage(orgId,page);
        }

        while (consultUsers.size() > 0){
            List<Long> consultUserIds = ListUtil.toKeyList(consultUsers,"id",TxConsultUser.class);
            //List<Long> userIds = ListUtil.toKeyList(consultUsers,"userId",TxConsultUser.class);
            Map<Long, List<CustomFieldValue>> valueMap = customFieldValueDao
                   .batchGetValueMap(null,false,consultUserIds,null);
            List<TxStudentTag> tags = tagDao.getTags(consultUserIds,null, StudentType.CONSULT_USER.getCode(),null);
            Map<Long,List<TxStudentTag>> studentTags = toMap(tags,StudentType.CONSULT_USER);
            for(TxConsultUser consultUser:consultUsers){
                Map map=consultUserToMap(consultUser,valueMap.get(consultUser.getId()),studentTags.get(consultUser.getId()));
                bulkProcessor.add(
                        new IndexRequest()
                                .index("consult_users")
                                .type("consult_user")
                                .source(map)
                                .id(consultUser.getId().toString())
                );
            }
            page.setPageNum(page.getPageNum() + 1);
            if(orgId==null) {

                consultUsers = consultUserDao.getByPage(page);
            }else {
                consultUsers=consultUserDao.getConsultUserByOrgIdAndPage(orgId,page);
            }
            bulkProcessor.flush();

        }

        bulkProcessor.close();
        log.info("import {} data costs:{}", page.getCount(), System.currentTimeMillis() - time);
    }



    @Override
    public void saveConsultToEs(Long consultUserId) {

        log.info("[ES] update consultUserId={}", consultUserId);
        TxConsultUser consultUser = consultUserDao.getById(consultUserId);

        int i = 1;
        while (consultUser == null && i <= 10) {//防止主从延迟
            try {
                Thread.sleep(i * 5 * 1000);
                consultUser = consultUserDao.getById(consultUserId);
                i++;
                log.warn("[ES] Retry count={},consultUserId={}", i, consultUserId);
            } catch (InterruptedException e) {
                log.error("[ES] InterruptedException error={}", e);
            }
        }

        if (consultUser == null) {
            log.error("[ES] consultUserId={} is not exist", consultUserId);
            return;
        }

        DeleteResponse deleteresponse = getClient()
                .prepareDelete("consult_users", "consult_user", String.valueOf(consultUserId))
                .execute()
                .actionGet();


        long time = System.currentTimeMillis();
        List<TxConsultUser> consultUsers =new ArrayList<>();
        consultUsers.add(consultUser);
        TransportClient client=getClient();
        List<Long> consultUserIds = ListUtil.toKeyList(consultUsers,"id",TxConsultUser.class);
        List<Long> userIds = ListUtil.toKeyList(consultUsers,"userId",TxConsultUser.class);
        Map<Long, List<CustomFieldValue>> valueMap = customFieldValueDao.batchGetValueMap(null,false,consultUserIds,null);
        List<TxStudentTag> tags = tagDao.getTags(consultUserId,null, StudentType.CONSULT_USER.getCode(),null);
        Map<Long,List<TxStudentTag>> studentTags = toMap(tags,StudentType.CONSULT_USER);
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        bulkRequest.add(
                        new IndexRequest()
                                .index("consult_users")
                                .type("consult_user")
                                .source(consultUserToMap(consultUser,valueMap.get(consultUser.getId()),studentTags.get(consultUser.getId())))
                                .id(consultUser.getId().toString()));
        BulkResponse bulkResponse = bulkRequest.execute().actionGet();
        if (bulkResponse.hasFailures()) {
           log.error("import fail:{}",bulkResponse.buildFailureMessage());
        }
        else {
            log.info("import data costs:{}", System.currentTimeMillis() - time);
        }
    }

    @Override
    public void fullImport() {
        importByOrgId(null);

    }

    @Override
    public void importLastFollowTime() {
        long time = System.currentTimeMillis();
        PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(3000);
        List <UserLastFollowTime>data=studentCommentDao.getLastFollowComment(page,StudentType.CONSULT_USER.getCode());
        while(data.size()>0){
            for(UserLastFollowTime user:data){
                TxConsultUser consultUser=consultUserDao.getOrgConsultUser(user.getOrgId(),user.getId());
                if(consultUser!=null) {
                    consultUser.setLastFollowTime(user.getLastFollowTime());
                    consultUserDao.update(consultUser, "lastFollowTime");
                }


            }
            page.setCount((page.getPageNum()-1)*page.getPageSize()+data.size());
            page.setPageNum(page.getPageNum()+1);
            data=studentCommentDao.getLastFollowComment(page,StudentType.CONSULT_USER.getCode());
        }
        log.info("import {} data costs:{}", page.getCount(), System.currentTimeMillis() - time);

    }

    @Override
    public void importDataLastDay(int hour){
        long time=System.currentTimeMillis();
        Calendar calendar=Calendar.getInstance();
        calendar.add(Calendar.HOUR_OF_DAY,-hour);
        Date lastDay=calendar.getTime();
        List<TxConsultUser> consultUsers=consultUserDao.getYesterdayUpdate(lastDay);
        for(TxConsultUser consultUser:consultUsers){
            saveConsultToEs(consultUser.getId());
        }
        log.info("import data costs:{}", System.currentTimeMillis() - time);

    }


    public Map<String,Object> consultUserToMap(TxConsultUser consultUser, List<CustomFieldValue> customFieldValues, List<TxStudentTag> tags){
        Map<String,Object> map = new HashMap<>();
        map.put("id", consultUser.getId());
        map.put("user_id", consultUser.getUserId());
        map.put("org_id", consultUser.getOrgId());
        map.put("name",consultUser.getName());
        map.put("school",consultUser.getSchool());
        map.put("_mobile", consultUser.getMobile());
        map.put("weixin", consultUser.getWeixin());
        map.put("consult_source",consultUser.getConsultSource());
        map.put("_parent_name",consultUser.getParentName());
        map.put("_parent_mobile",consultUser.getParentMobile());
        map.put("intension_level",consultUser.getIntensionLevel());

        map.put("consult_status",consultUser.getConsultStatus());
        map.put("student_id",consultUser.getStudentId());
        String pinyin = HanZiPinYinUtils.getLowerCasePinYin(consultUser.getName());
        if (StringUtils.isNotBlank(pinyin)) {
            char init = pinyin.charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        map.put("pinyin", pinyin);
        if(consultUser.getBirthday()!=null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(consultUser.getBirthday());
            calendar.set(Calendar.HOUR, 0);
            calendar.set(Calendar.MINUTE, 0);
            calendar.set(Calendar.SECOND, 0);
            calendar.set(Calendar.MILLISECOND, 0);
            if (GenericsUtils.notNullAndEmpty(consultUser.getBirthday())) {
                map.put("birthday", consultUser.getBirthday().getTime());
                map.put("birthDayOfMonth", calendar.get(Calendar.DAY_OF_MONTH));
                map.put("birthMonth", calendar.get(Calendar.MONTH) + 1);
                map.put("birthYear", calendar.get(Calendar.YEAR));
            } else {
                map.put("birthday", -1);
                map.put("birthDayOfMonth", -1);
                map.put("birthMonth", -1);
                map.put("birthYear", -1);
            }
        }
        if(consultUser.getLastRemindTime()!=null) {
            map.put("last_remind_time", consultUser.getLastRemindTime().getTime());
        }else {
                map.put("last_remind_time", -1);
        }
        if(consultUser.getLastFollowTime()!=null){
            map.put("last_follow_time",consultUser.getLastFollowTime().getTime());
        }
        else{
            map.put("last_follow_time",-1);
        }
        if(consultUser.getFinallyHoldTime()!=null){
            map.put("finally_hold_time",consultUser.getFinallyHoldTime().getTime());
        }else {
            map.put("finally_hold_time",-1);
        }
        map.put("qq",consultUser.getQq());
        map.put("mail",consultUser.getMail());
        map.put("relatives",consultUser.getRelatives());
        map.put("degree_class",consultUser.getDegreeClass());
        map.put("address",consultUser.getAddress());
        map.put("create_time",consultUser.getCreateTime().getTime());
        map.put("update_time",consultUser.getUpdateTime().getTime());
        map.put("del_status",consultUser.getDelStatus());
        map.put("sex",consultUser.getSex());
        map.put("cascade_id",consultUser.getCascadeId());
        map.put("is_invalid",consultUser.getIsInvalid());
        if(consultUser.getLastBrowseTime()!=null) {
            map.put("last_browse_time", consultUser.getLastBrowseTime().getTime());
        } else {
            map.put("last_browse_time",-1);
        }
        if(consultUser.getNextRemindTime()!=null) {
            map.put("next_remind_time", consultUser.getNextRemindTime().getTime());
        }else {
            map.put("next_remind_time",-1);
        }
        map.put("is_consulter",consultUser.getIsConsulter());
        Map<String,Object> customFieldMap = new HashMap<>();
        if(customFieldValues!=null) {
            for (CustomFieldValue value : customFieldValues) {
                try {
                    Map<String, Object> valueMap = JacksonUtil.str2Obj(value.getValue(),
                            new TypeReference<Map<String, Object>>() {
                            });
                    customFieldMap.put(value.getFieldId().toString(), valueMap);
                } catch (IOException e) {
                    log.error("IOException = {}",e);
                }
            }
        }
        map.put("custom_field", customFieldMap);
        String tagStr = "";
        if(tags!=null && tags.size()>0){
            StringBuilder sb = new StringBuilder();
            for (TxStudentTag tag:tags){
                sb.append(",").append(tag.getContent());
            }
            tagStr = sb.substring(1);
        }

        map.put("tag",tagStr);
        return map;
    }

}
