package com.baijia.tianxiao.sal.elastic.enums;

/**
 * 课程统计
 */
public enum LessonStatType {
    FINISHED_LESSON_COUNT(1, "kexiaoCount", "已上课次"),
    SCHEDULE_LESSON_COUNT(2, "arrangeCount", "已排课次"),
    TOTAL_LESSON_COUNT(3, "totalCount", "总课次"),
    FINISHED_LESSON_TIME(11, "kexiaoTime", "已上课时"),
    SCHEDULE_LESSON_TIME(12, "arrangeTime", "已排课时"),
    TOTAL_LESSON_TIME(13, "totalTime", "总课时"),
    COURSE_LEFT_AMOUNT(101, "leftAmount", "剩余学费"),
    ACCOUNT_LEFT_AMOUNT(102, "banlance", "学员账户余额"),;

    private int type;
    private String desc;
    private String searchKey;

    private LessonStatType(int type, String searchKey, String desc) {
        this.type = type;
        this.desc = desc;
        this.searchKey = searchKey;
    }

    public static LessonStatType getByType(Integer type) {
        if (type != null) {
            for (LessonStatType statType : LessonStatType.values()) {
                if (statType.type == type) {
                    return statType;
                }
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getSearchKey() {
        return searchKey;
    }
}
