/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.elastic.service.StudentLessonStatDataImportService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentLessonStatDataImportServiceImpl
extends AbstractEsBaseServiceImpl
implements StudentLessonStatDataImportService {
    private static final Logger log = LoggerFactory.getLogger(StudentLessonStatDataImportServiceImpl.class);
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private OrgStudentDao studentDao;

    @Override
    public void importByOrgId(Long orgId) {
        long time = System.currentTimeMillis();
        BulkProcessor bulkProcessor = this.getDefaultBulkProcessor();
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(3000));
        List students = this.studentDao.getStudents(orgId, "", Integer.valueOf(1), page, new String[]{"id", "userId"});
        while (students.size() > 0) {
            List userIds = ListUtil.toKeyList((Collection)students, (String)"userId", OrgStudent.class);
            Map statMap = this.kexiaoApiService.queryUserKexiaoStat(orgId, (Collection)userIds);
            for (OrgStudent student : students) {
                bulkProcessor.add(((IndexRequest)new IndexRequest().index("statistics")).type("lessonStat").source(this.toMap(student, (KexiaoStudentStat)statMap.get(student.getUserId()))).id(student.getId().toString()));
            }
            page.setPageNum(Integer.valueOf(page.getPageNum() + 1));
            students = this.studentDao.getByPage(page, new String[0]);
        }
        bulkProcessor.flush();
        bulkProcessor.close();
        log.info("import {} data costs:{}", (Object)page.getCount(), (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void fullImport() {
    }

    private Map<String, Object> toMap(OrgStudent student, KexiaoStudentStat stat) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("studentId", student.getId());
        if (stat != null) {
            ret.put("userId", stat.getUserId());
            ret.put("leftAmount", stat.getLeftAmount());
            ret.put("kexiaoCount", stat.getKexiaoNormalCount() + stat.getKexiaoFreeCount());
            ret.put("arrangeCount", stat.getArrangeNormalCount() + stat.getArrangeFreeCount());
            ret.put("totalCount", stat.getTotalCount());
            ret.put("kexiaoTime", stat.getKexiaoNormalTime() + stat.getKexiaoFreeTime());
            ret.put("arrangeTime", stat.getArrangeNormalTime() + stat.getArrangeFreeTime());
            ret.put("totalTime", stat.getTotalTime());
            ret.put("accountAmount", stat.getLeftAmount());
        }
        return ret;
    }
}

