/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.PCStudentOrderEnum;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.sal.elastic.enums.LessonStatType;
import com.baijia.tianxiao.sal.elastic.service.OrgStudentQueryService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgStudentQueryServiceImpl
extends AbstractEsBaseServiceImpl
implements OrgStudentQueryService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentQueryServiceImpl.class);
    @Autowired
    private OrgStudentCourseDao studentCourseDao;

    @Override
    public List<StudentDto> queryStudent(StudentQueryParam param, PageDto pageDto) {
        SearchHit[] searchHits;
        ArrayList<StudentDto> result = new ArrayList<StudentDto>();
        SearchResponse response = this.buildQuery(param, pageDto);
        if (response == null) {
            return result;
        }
        SearchHits hits = response.getHits();
        long total = hits.getTotalHits();
        pageDto.setCount(Integer.valueOf((int)total));
        log.info("[ES] query size={}", (Object)total);
        for (SearchHit s : searchHits = hits.hits()) {
            StudentDto dto = this.buildStudent(s.getSource());
            result.add(dto);
        }
        return result;
    }

    private StudentDto buildStudent(Map<String, Object> doc) {
        StudentDto stu = new StudentDto();
        stu.setName((String)doc.get("name"));
        stu.setMobile((String)doc.get("mobile"));
        stu.setWeixin((String)doc.get("weixin"));
        stu.setStuLessonStatus((Integer)doc.get("lesson_status"));
        stu.setStudentId(Long.valueOf(((Integer)doc.get("id")).longValue()));
        stu.setUserId(Long.valueOf(((Integer)doc.get("user_id")).longValue()));
        stu.setPinyin((String)doc.get("pinyin"));
        stu.setAvatar(Long.valueOf(((Integer)doc.get("avatar")).longValue()));
        return stu;
    }

    private SearchResponse buildQuery(StudentQueryParam param, PageDto page) {
        LessonStatType statType;
        TimeRange range;
        log.info("[ES] origin query param={}", (Object)param);
        BoolQueryBuilder builder = QueryBuilders.boolQuery().must((QueryBuilder)this.getMatchQuery("org_id", param.getOrgId())).must((QueryBuilder)this.getMatchQuery("del_status", 0));
        if (StringUtils.isNotBlank((CharSequence)param.getQueryStr()) && StringUtils.isNotBlank((CharSequence)param.getQueryValue())) {
            param.setQueryValue(ClientUtils.escapeQueryChars((String)param.getQueryValue()));
            if (param.getQueryStr().equals("mobile")) {
                builder.must((QueryBuilder)this.getWildcardQuery("mobile", param.getQueryValue()));
            }
            if (param.getQueryStr().equals("name")) {
                builder.must((QueryBuilder)this.getWildcardQuery("name.keyword", param.getQueryValue()));
            }
            if (param.getQueryStr().equals("parentName")) {
                builder.must((QueryBuilder)this.getWildcardQuery("parent_name.keyword", param.getQueryValue()));
            }
            if (param.getQueryStr().equals("parentMobile")) {
                builder.must((QueryBuilder)this.getWildcardQuery("parent_mobile", param.getQueryValue()));
            }
            if (param.getQueryStr().equals("tag")) {
                builder.must((QueryBuilder)this.getWildcardQuery("tag.keyword", param.getQueryValue()));
            }
            if (StringUtils.isNotBlank((CharSequence)param.getQueryStr()) && param.getQueryStr().startsWith("customField")) {
                String idStr = param.getQueryStr().replace("customField", "");
                if (StringUtils.isNotBlank((CharSequence)param.getQueryValue())) {
                    String customKey = "custom_field." + idStr + ".content.keyword";
                    builder.must((QueryBuilder)this.getWildcardQuery(customKey, param.getQueryValue()));
                } else {
                    return null;
                }
            }
        }
        if (param.getSource() != null) {
            builder.must((QueryBuilder)this.getMatchQuery("source", param.getSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSearchKey())) {
            BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
            shouldBuilder.should().add(this.getWildcardQuery("name.keyword", param.getSearchKey()));
            if (NumberUtils.isDigits((String)param.getSearchKey()) && param.getSearchKey().length() >= 3) {
                shouldBuilder.should().add(this.getWildcardQuery("mobile", param.getSearchKey()));
            }
            shouldBuilder.should().add(this.getWildcardQuery("tag.keyword", param.getSearchKey()));
            builder.must((QueryBuilder)shouldBuilder);
        }
        if (param.getGender() != null) {
            builder.must((QueryBuilder)this.getMatchQuery("gender", param.getGender()));
        }
        if (param.getScheduleStatus() != null && param.getScheduleStatus() != 0) {
            builder.must((QueryBuilder)this.getMatchQuery("scheduleStatus", param.getScheduleStatus()));
        }
        if (param.getRefundClassStatus() != null && param.getRefundClassStatus() != 0) {
            builder.must((QueryBuilder)this.getMatchQuery("refundClassStatus", param.getRefundClassStatus()));
        }
        if (param.getStuCenterBindStatus() != null && param.getStuCenterBindStatus() != 0) {
            builder.must((QueryBuilder)this.getMatchQuery("stuCenterBindStatus", param.getStuCenterBindStatus()));
        }
        if (param.getBirthYear() != null) {
            builder.must((QueryBuilder)this.getMatchQuery("birthYear", param.getBirthYear()));
        }
        if (param.getBirthMonth() != null) {
            builder.must((QueryBuilder)this.getMatchQuery("birthMonth", param.getBirthMonth()));
        }
        if (param.getBirthDayOfMonth() != null) {
            builder.must((QueryBuilder)this.getMatchQuery("birthDayOfMonth", param.getBirthDayOfMonth()));
        }
        if (param.getCreateTime() != null) {
            range = param.getCreateTime().timeRange();
            builder.must((QueryBuilder)this.getTimestampRangeQueryBuilder("create_time", range.getStartTime(), range.getEndTime()));
        }
        if (param.getEnrollTime() != null) {
            range = param.getEnrollTime().timeRange();
            List courseList = this.studentCourseDao.listByTimeRange(param.getOrgId(), null, range.getStartTime(), range.getEndTime(), new String[]{"userId", "id"});
            if (courseList == null || courseList.size() < 1) {
                return null;
            }
            List userIds = ListUtil.toKeyList((Collection)courseList, (String)"userId", OrgStudentCourse.class);
            if (param.getStudentIds() == null || param.getStudentIds().size() < 1) {
                param.setStudentIds(new HashSet(userIds));
            } else {
                param.getStudentIds().retainAll(userIds);
                if (param.getStudentIds().size() < 1) {
                    return null;
                }
            }
        }
        if (param.getDateFieldKey() != null) {
            String dateFieldKey = ClientUtils.escapeQueryChars((String)param.getDateFieldKey());
            if (StringUtils.isNotBlank((CharSequence)dateFieldKey) && dateFieldKey.startsWith("customField")) {
                String idStr = dateFieldKey.replace("customField", "");
                String customDateKey = "custom_field." + idStr + ".content";
                builder.must((QueryBuilder)this.getTimestampRangeQueryBuilder(customDateKey, param.getStart(), param.getEnd()));
            } else {
                String keyFieldName = PCStudentOrderEnum.find((String)dateFieldKey);
                builder.must((QueryBuilder)this.getTimestampRangeQueryBuilder(keyFieldName, param.getStart(), param.getEnd()));
            }
        }
        ArrayList lessonStatus = Lists.newArrayList();
        if (param.getStatus() != null && param.getStatus() != StudentLessonStatus.ALL) {
            lessonStatus.addAll(StudentLessonStatus.findSubStatus((int)param.getStatus().getStatus()));
            BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
            for (Integer status : lessonStatus) {
                shouldBuilder.should().add(this.getMatchQuery("lesson_status", status));
            }
            builder.must((QueryBuilder)shouldBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSelectFieldKey()) && StringUtils.isNotBlank((CharSequence)param.getSelectFieldValue())) {
            String selectKey = param.getSelectFieldKey().replace("customField", "");
            builder.must((QueryBuilder)this.getMatchQuery(this.getCustomFieldKey(selectKey, param.getOrgId()), param.getSelectFieldValue()));
        }
        if (param.getStudentIds() != null && param.getStudentIds().size() > 0) {
            builder.must((QueryBuilder)QueryBuilders.termsQuery((String)"user_id", (Collection)param.getStudentIds()));
        }
        if (param.getAddCascadeIds() != null && param.getAddCascadeIds().size() > 0) {
            builder.must((QueryBuilder)QueryBuilders.termsQuery((String)"add_cascade_id", (Collection)param.getAddCascadeIds()));
        }
        if (param.getLessonStatType() != null && param.getLessonStatType() > 0 && (statType = LessonStatType.getByType(param.getLessonStatType())) != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)statType.getSearchKey());
            if (param.getMinNum() != null) {
                rangeQueryBuilder.gte((Object)param.getMinNum());
            }
            if (param.getMaxNum() != null) {
                rangeQueryBuilder.lte((Object)param.getMaxNum());
            }
            builder.must((QueryBuilder)rangeQueryBuilder);
        }
        SortBuilder sortBuilder = SortBuilders.fieldSort((String)"last_remind_time").order(SortOrder.DESC);
        if (GenericsUtils.notNullAndEmpty((Object)param.getOrderName())) {
            String orderName = this.toEsField(param.getOrderName());
            if (orderName.equals("pinyin")) {
                orderName = orderName + ".keyword";
            }
            if (param.getOrderType() == 0) {
                sortBuilder = SortBuilders.fieldSort((String)orderName).order(SortOrder.ASC);
            }
            if (param.getOrderType() == 1) {
                sortBuilder = SortBuilders.fieldSort((String)orderName).order(SortOrder.DESC);
            }
        }
        log.info("[ES] query param={}", (Object)builder.toString());
        SearchResponse response = (SearchResponse)this.getClient().prepareSearch(new String[]{"students"}).setTypes(new String[]{"student"}).setQuery((QueryBuilder)builder).addSort(sortBuilder).setFrom((page.getPageNum() - 1) * page.getPageSize()).setSize(page.getPageSize().intValue()).get();
        return response;
    }

    private String toEsField(String orderName) {
        if (orderName.equals("addCascadeIdStr")) {
            return "add_cascade_id";
        }
        if ("birthdayStr".equals(orderName)) {
            return "birthday";
        }
        if ("createTimeStr".equals(orderName)) {
            return "create_time";
        }
        if ("lastRemindTimeStr".equals(orderName)) {
            return "last_remind_time";
        }
        if ("lastFollowTimeStr".equals(orderName)) {
            return "last_follow_time";
        }
        return orderName;
    }
}

