package com.baijia.tianxiao.sal.elastic.service.impl;


import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.elastic.service.StudentDataImportService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/11/17.
 */
@Service
public class StudentDataImportServiceImpl implements StudentDataImportService {

    @Autowired
    private OrgStudentDao studentDao;

    public void dataImportByOrgId(long orgId){
        PageDto page = new PageDto();
        List<OrgStudent>  students = studentDao.getStudents(orgId,"", DeleteStatus.NORMAL.getValue(),page);
        try {
            Settings settings = Settings.builder().put("cluster.name","tx_es_cluster").build();
            TransportClient client = new PreBuiltTransportClient(settings)
                    .addTransportAddress(new InetSocketTransportAddress(InetAddress.getByName("172.21.139.12"), 9300));
            for (OrgStudent student:students) {
                client.prepareIndex("students", "student")
                        .setSource(studentToMap(student))
                        .execute()
                        .actionGet();
                System.out.println(studentToMap(student));
            }
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Map<String,Object> studentToMap(OrgStudent student){
        Map<String,Object> map = new HashMap<>();
        map.put("id", student.getId());
        map.put("user_id", student.getUserId());
        map.put("org_id", student.getOrgId());
        map.put("name", student.getName());
        map.put("mobile", student.getMobile());
        map.put("weixin", student.getWeixin());
        map.put("lesson_status", student.getLessonStatus());
        map.put("add_cascade_id", student.getAddCascadeId());
        map.put("parent_name", student.getParentName());
        map.put("parent_mobile", student.getParentMobile());
        String pinyin = HanZiPinYinUtils.getLowerCasePinYin(student.getName());
        if (StringUtils.isNotBlank(pinyin)) {
            char init = pinyin.charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        map.put("pinyin", pinyin);
        map.put("gender", student.getGender());
        map.put("del_status", student.getDelStatus());
        map.put("avatar", student.getAvatar());
        map.put("create_time", student.getCreateTime().getTime());
        map.put("update_time", student.getUpdateTime().getTime());

        return map;
    }
}
