/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.display.service.impl;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.show.dao.OrgShowInfoDao;
import com.baijia.tianxiao.dal.show.po.OrgShowInfo;
import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.sal.display.dto.FieldDto;
import com.baijia.tianxiao.sal.display.service.OrgShowService;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgShowServiceImpl
implements OrgShowService {
    private static final Logger log = LoggerFactory.getLogger(OrgShowServiceImpl.class);
    @Resource
    private OrgShowInfoDao orgShowInfoDao;

    @Override
    public List<FieldDto> getCurrentHeaders(Long orgId, DataProcType queryListEnum, Class<?> cls) {
        OrgShowInfo info = this.orgShowInfoDao.getShowInfo(orgId, Integer.valueOf(queryListEnum.getType()), new String[]{"content"});
        if (info != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.getContent()})) {
            try {
                log.debug("show info:{}", (Object)info);
                return this.buildFieldDto(JacksonUtil.str2List((String)info.getContent(), FieldShow.class));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.buildFieldDto(FieldShow.getColumnShows(cls));
    }

    private List<FieldDto> buildFieldDto(List<FieldShow> shows) {
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(shows)) {
            for (FieldShow show : shows) {
                FieldDto dto = new FieldDto();
                dto.setName(show.getName());
                dto.setLock(show.getLock());
                dto.setSort(show.getOperate());
                dto.setType(show.getType());
                dto.setShowName(show.getShowName());
                dto.setHidden(show.getViewType() == 1 ? 0 : 1);
                dtos.add(dto);
            }
        }
        return dtos;
    }

    private List<FieldShow> buildFieldShow(List<FieldDto> dtos) {
        ArrayList shows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dtos)) {
            for (FieldDto dto : dtos) {
                FieldShow show = new FieldShow();
                show.setName(dto.getName());
                show.setLock(dto.getLock());
                show.setOperate(dto.getSort());
                show.setShowName(dto.getShowName());
                dto.setHidden(dto.getHidden() == 1 ? 0 : 1);
                shows.add(show);
            }
        }
        return shows;
    }

    @Override
    public List<FieldDto> getAllHeaders(Class<?> cls) {
        return this.buildFieldDto(FieldShow.getColumnShows(cls));
    }

    @Override
    public void modHeaders(Long orgId, List<FieldDto> dtos, DataProcType queryListEnum, Class<?> cls) {
        List<FieldShow> fields = this.buildFieldShow(dtos);
        Preconditions.checkArgument((boolean)FieldShow.isFieldsUsable(cls, fields), (Object)"some error with fields!");
        OrgShowInfo info = this.orgShowInfoDao.getShowInfo(orgId, Integer.valueOf(queryListEnum.getType()), new String[0]);
        if (info != null) {
            info.setContent(JacksonUtil.obj2Str(fields));
            this.orgShowInfoDao.update((Object)info, new String[]{"content"});
        } else {
            info = new OrgShowInfo();
            info.setOrgId(orgId);
            info.setType(Integer.valueOf(queryListEnum.getType()));
            info.setContent(JacksonUtil.obj2Str(fields));
            this.orgShowInfoDao.save((Object)info, Boolean.valueOf(false), new String[0]);
        }
    }
}

