/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.display.service.impl;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.show.dao.FieldShowInfoDao;
import com.baijia.tianxiao.dal.show.enums.FieldStatus;
import com.baijia.tianxiao.dal.show.enums.ShowStatus;
import com.baijia.tianxiao.dal.show.po.FieldShowInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.field.FieldOption;
import com.baijia.tianxiao.sal.display.dto.annotation.FieldProp;
import com.baijia.tianxiao.sal.display.dto.response.crm.DefaultClueField;
import com.baijia.tianxiao.sal.display.dto.response.crm.DefaultStudentField;
import com.baijia.tianxiao.sal.display.service.FieldShowInfoService;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FieldShowInfoServiceImpl
implements FieldShowInfoService {
    private static final Set<String> PUBLIC_CLUE_EXCLUDE = Sets.newHashSet((Object[])new String[]{"consultStatusStr"});
    private static final int CUSTOM_CODE = -1;
    private static final String CUSTOM_STR = "custom_";
    @Autowired
    private FieldShowInfoDao fieldShowInfoDao;
    @Autowired
    private CustomFieldDao customFieldDao;

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Map<String, Object> getShowConfig(Long orgId, DataProcType type) {
        if (orgId == null || orgId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784id\u9519\u8bef");
        }
        this.initFieldShow(orgId, type);
        ArrayList<FieldOption> all = new ArrayList<FieldOption>();
        ArrayList<FieldOption> using = new ArrayList<FieldOption>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List fieldList = this.fieldShowInfoDao.getOrgFieldShow(orgId, type.getType(), FieldStatus.NORMAL.getCode(), (Collection)Sets.newHashSet((Object[])new Integer[]{ShowStatus.SHOW.getCode(), ShowStatus.HIDDEN.getCode()}));
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            HashMap<Long, FieldShowInfo> preCurShowMap = new HashMap<Long, FieldShowInfo>();
            int checkPreNull = 0;
            for (FieldShowInfo field : fieldList) {
                if (field.getShowStatus() != ShowStatus.SHOW.getCode()) continue;
                if (field.getPreShowId() == null) {
                    if (checkPreNull > 0) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u663e\u793a\u5b57\u6bb5\u5f02\u5e38");
                    }
                    ++checkPreNull;
                }
                preCurShowMap.put(field.getPreShowId(), field);
            }
            Long preId = null;
            while (!preCurShowMap.isEmpty()) {
                FieldShowInfo info = (FieldShowInfo)preCurShowMap.remove(preId);
                if (info != null) {
                    FieldOption fieldOption = new FieldOption();
                    fieldOption.setFieldShowId(info.getId());
                    fieldOption.setLock(info.getLocked() == BizConf.TRUE.intValue());
                    fieldOption.setPreId(info.getPreShowId());
                    fieldOption.setName(info.getName());
                    fieldOption.setShowName(info.getShowName());
                    fieldOption.setHidden(false);
                    fieldOption.setSort(info.getSorted() == BizConf.TRUE.intValue());
                    fieldOption.setCustomId(info.getCustomFieldId());
                    fieldOption.setQueryProp(info.getQueryProp());
                    using.add(fieldOption);
                    all.add(fieldOption);
                    preId = info.getId();
                    continue;
                }
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u663e\u793a\u5b57\u6bb5\u5f02\u5e38");
            }
            for (FieldShowInfo po : fieldList) {
                if (po.getShowStatus() == ShowStatus.SHOW.getCode()) continue;
                FieldOption dto = new FieldOption();
                dto.setFieldShowId(po.getId());
                dto.setLock(po.getLocked() == BizConf.TRUE.intValue());
                dto.setName(po.getName());
                dto.setShowName(po.getShowName());
                dto.setPreId(po.getPreShowId());
                dto.setSort(po.getSorted() == BizConf.TRUE.intValue());
                dto.setCustomId(po.getCustomFieldId());
                dto.setQueryProp(po.getQueryProp());
                if (po.getShowStatus() == ShowStatus.NEVER_SHOW.getCode()) {
                    dto.setHidden(true);
                } else {
                    dto.setHidden(false);
                }
                all.add(dto);
            }
        }
        map.put("getTime", new Date().getTime());
        map.put("using", using);
        map.put("all", all);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void setShowConfig(Long orgId, DataProcType type, Long getTime, String content) {
        if (orgId == null || orgId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784id\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bbe\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (getTime == null || new Date(getTime).after(new Date())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u83b7\u53d6\u8bbe\u7f6e\u65f6\u95f4\u53c2\u6570\u9519\u8bef");
        }
        boolean neverUpdate = this.fieldShowInfoDao.consistencyCheck(orgId, type.getType(), new Date(getTime));
        if (!neverUpdate) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c5e\u6027\u5b57\u6bb5\u5728\u6b64\u671f\u95f4\u5df2\u88ab\u66f4\u65b0,\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        List optionList = null;
        try {
            optionList = JacksonUtil.str2List((String)content, FieldOption.class);
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bbe\u7f6e\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty((Collection)optionList)) {
            int index = 0;
            while (index < optionList.size()) {
                if (!((FieldOption)optionList.get(index)).isLock()) {
                    ((FieldOption)optionList.get(index)).setPreId(((FieldOption)optionList.get(index - 1)).getFieldShowId());
                }
                ++index;
            }
            ArrayList<FieldShowInfo> updateList = new ArrayList<FieldShowInfo>();
            List curList = this.fieldShowInfoDao.getOrgFieldShow(orgId, type.getType(), FieldStatus.NORMAL.getCode(), (Collection)Sets.newHashSet((Object[])new Integer[]{ShowStatus.SHOW.getCode(), ShowStatus.HIDDEN.getCode()}));
            Map curFieldMap = BaseUtils.listToMap((List)curList, (String)"id");
            for (FieldOption option : optionList) {
                FieldShowInfo po = (FieldShowInfo)curFieldMap.remove(option.getFieldShowId());
                if (po == null) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b57\u6bb5\u53c2\u6570\u5f02\u5e38");
                }
                if (po.getShowStatus() != ShowStatus.HIDDEN.getCode() && (po.getPreShowId() == null || po.getPreShowId().longValue() == option.getPreId().longValue())) continue;
                po.setShowStatus(ShowStatus.SHOW.getCode());
                po.setPreShowId(option.getPreId());
                po.setUpdateTime(new Date());
                updateList.add(po);
            }
            if (!curFieldMap.isEmpty()) {
                for (FieldShowInfo otherField : curFieldMap.values()) {
                    if (otherField.getShowStatus() != ShowStatus.SHOW.getCode()) continue;
                    otherField.setShowStatus(ShowStatus.HIDDEN.getCode());
                    otherField.setPreShowId(null);
                    otherField.setUpdateTime(new Date());
                    updateList.add(otherField);
                }
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                for (FieldShowInfo po : updateList) {
                    this.fieldShowInfoDao.update((Object)po, Boolean.valueOf(true), new String[]{"showStatus", "preShowId", "updateTime"});
                }
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u663e\u793a\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<FieldOption> getHeader(Long orgId, DataProcType type, Set<String> excludeProps) {
        if (orgId == null || orgId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784id\u9519\u8bef");
        }
        this.initFieldShow(orgId, type);
        List header = Lists.newArrayList();
        List result = Lists.newArrayList();
        List fieldList = this.fieldShowInfoDao.getOrgFieldShow(orgId, type.getType(), FieldStatus.NORMAL.getCode(), (Collection)Sets.newHashSet((Object[])new Integer[]{ShowStatus.SHOW.getCode(), ShowStatus.NEVER_SHOW.getCode()}));
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            HashMap<Long, FieldShowInfo> preCurShowMap = new HashMap<Long, FieldShowInfo>();
            int checkPreNull = 0;
            for (FieldShowInfo field : fieldList) {
                if (field.getShowStatus() != ShowStatus.SHOW.getCode()) continue;
                if (field.getPreShowId() == null) {
                    if (checkPreNull > 0) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u663e\u793a\u5b57\u6bb5\u5f02\u5e38");
                    }
                    ++checkPreNull;
                }
                preCurShowMap.put(field.getPreShowId(), field);
            }
            Long preId = null;
            while (!preCurShowMap.isEmpty()) {
                FieldShowInfo info = (FieldShowInfo)preCurShowMap.remove(preId);
                if (info != null) {
                    FieldOption fieldOption = new FieldOption();
                    fieldOption.setFieldShowId(info.getId());
                    fieldOption.setLock(info.getLocked() == BizConf.TRUE.intValue());
                    fieldOption.setPreId(info.getPreShowId());
                    fieldOption.setName(info.getName());
                    fieldOption.setShowName(info.getShowName());
                    fieldOption.setHidden(false);
                    fieldOption.setSort(info.getSorted() == BizConf.TRUE.intValue());
                    fieldOption.setCustomId(info.getCustomFieldId());
                    fieldOption.setQueryProp(info.getQueryProp());
                    header.add(fieldOption);
                    preId = info.getId();
                    continue;
                }
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u663e\u793a\u5b57\u6bb5\u5f02\u5e38");
            }
            for (FieldShowInfo po : fieldList) {
                if (po.getShowStatus() == ShowStatus.SHOW.getCode()) continue;
                FieldOption dto = new FieldOption();
                dto.setFieldShowId(po.getId());
                dto.setLock(po.getLocked() == BizConf.TRUE.intValue());
                dto.setName(po.getName());
                dto.setShowName(po.getShowName());
                dto.setPreId(po.getPreShowId());
                dto.setSort(po.getSorted() == BizConf.TRUE.intValue());
                dto.setHidden(true);
                dto.setCustomId(po.getCustomFieldId());
                dto.setQueryProp(po.getQueryProp());
                header.add(dto);
            }
            if (CollectionUtils.isNotEmpty((Collection)header)) {
                int index = 0;
                while (index < header.size()) {
                    String name;
                    if (CollectionUtils.isNotEmpty(excludeProps) && excludeProps.contains(name = ((FieldOption)header.get(index)).getName())) {
                        excludeProps.remove(name);
                    } else {
                        result.add((FieldOption)header.get(index));
                    }
                    ++index;
                }
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void addCustomField(Long orgId, DataProcType type, Long customFieldId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((customFieldId != null && customFieldId > 0L ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u5b57\u6bb5id\u9519\u8bef");
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, customFieldId);
        if (customField == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (customField.getSystemFieldNum() != null && customField.getSystemFieldNum() != -1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u5b57\u6bb5\u4e3a\u7cfb\u7edf\u5b57\u6bb5");
        }
        if (customField.getIsPaused() != null && customField.getIsPaused().intValue() == BizConf.TRUE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u505c\u7528\u72b6\u6001");
        }
        boolean hasInitCustom = this.initFieldShow(orgId, type);
        if (hasInitCustom) {
            return;
        }
        Long lastLockId = this.fieldShowInfoDao.getLastLockInfo(orgId, type.getType());
        if (lastLockId != null && lastLockId > 0L) {
            FieldShowInfo nextField = this.fieldShowInfoDao.getShowBehind(orgId, type.getType(), lastLockId, new String[]{"id"});
            FieldShowInfo po = new FieldShowInfo();
            po.setOrgId(orgId);
            po.setCustomFieldId(customField.getId());
            po.setName(CUSTOM_STR + customField.getId());
            po.setShowName(customField.getLabel());
            po.setFieldStatus(FieldStatus.NORMAL.getCode());
            po.setType(type.getType());
            po.setShowStatus(ShowStatus.SHOW.getCode());
            po.setPreShowId(lastLockId);
            this.fieldShowInfoDao.save((Object)po, Boolean.valueOf(false), new String[0]);
            if (nextField != null) {
                nextField.setPreShowId(po.getId());
                nextField.setUpdateTime(new Date());
                this.fieldShowInfoDao.update((Object)nextField, new String[]{"preShowId", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u9501\u5b9a\u5b57\u6bb5");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void pauseCustomField(Long orgId, DataProcType type, Long customFieldId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((customFieldId != null && customFieldId > 0L ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u5b57\u6bb5id\u9519\u8bef");
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, customFieldId);
        if (customField == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (customField.getSystemFieldNum() != null && customField.getSystemFieldNum() != -1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u5b57\u6bb5\u4e3a\u7cfb\u7edf\u5b57\u6bb5");
        }
        if (customField.getIsPaused() != null && customField.getIsPaused().intValue() == BizConf.TRUE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u505c\u7528\u72b6\u6001");
        }
        this.initFieldShow(orgId, type);
        FieldShowInfo tobePause = this.fieldShowInfoDao.getByCustomId(orgId, type.getType(), customField.getId(), new String[]{"id", "fieldStatus", "preShowId"});
        if (tobePause == null || tobePause.getFieldStatus() == FieldStatus.DELETED.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (tobePause.getFieldStatus() == FieldStatus.PAUSED.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u505c\u7528\u72b6\u6001");
        }
        FieldShowInfo nextField = this.fieldShowInfoDao.getShowBehind(orgId, type.getType(), tobePause.getId(), new String[]{"id"});
        if (nextField != null) {
            nextField.setPreShowId(tobePause.getPreShowId());
            nextField.setUpdateTime(new Date());
            this.fieldShowInfoDao.update((Object)nextField, Boolean.valueOf(false), new String[]{"preShowId", "updateTime"});
        }
        tobePause.setFieldStatus(FieldStatus.PAUSED.getCode());
        tobePause.setPreShowId(null);
        tobePause.setUpdateTime(new Date());
        this.fieldShowInfoDao.update((Object)tobePause, Boolean.valueOf(true), new String[]{"fieldStatus", "preShowId", "updateTime"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void enableCustomField(Long orgId, DataProcType type, Long customFieldId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((customFieldId != null && customFieldId > 0L ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u5b57\u6bb5id\u9519\u8bef");
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, customFieldId);
        if (customField == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (customField.getSystemFieldNum() != null && customField.getSystemFieldNum() != -1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u5b57\u6bb5\u4e3a\u7cfb\u7edf\u5b57\u6bb5");
        }
        if (customField.getIsPaused() != null && customField.getIsPaused().intValue() == BizConf.FALSE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u542f\u7528\u72b6\u6001");
        }
        this.initFieldShow(orgId, type);
        FieldShowInfo tobeEnable = this.fieldShowInfoDao.getByCustomId(orgId, type.getType(), customField.getId(), new String[]{"id", "fieldStatus"});
        if (tobeEnable == null || tobeEnable.getFieldStatus() == FieldStatus.DELETED.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (tobeEnable.getFieldStatus() == FieldStatus.NORMAL.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u542f\u7528\u72b6\u6001");
        }
        Long lastLockId = this.fieldShowInfoDao.getLastLockInfo(orgId, type.getType());
        if (lastLockId != null && lastLockId > 0L) {
            FieldShowInfo nextField = this.fieldShowInfoDao.getShowBehind(orgId, type.getType(), lastLockId, new String[]{"id"});
            tobeEnable.setShowStatus(ShowStatus.SHOW.getCode());
            tobeEnable.setFieldStatus(FieldStatus.NORMAL.getCode());
            tobeEnable.setPreShowId(lastLockId);
            tobeEnable.setUpdateTime(new Date());
            this.fieldShowInfoDao.update((Object)tobeEnable, new String[]{"showStatus", "fieldStatus", "preShowId", "updateTime"});
            if (nextField != null) {
                nextField.setPreShowId(tobeEnable.getId());
                nextField.setUpdateTime(new Date());
                this.fieldShowInfoDao.update((Object)nextField, new String[]{"preShowId", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u9501\u5b9a\u5b57\u6bb5");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void deleteCustomField(Long orgId, DataProcType type, Long customFieldId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((customFieldId != null && customFieldId > 0L ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u5b57\u6bb5id\u9519\u8bef");
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, customFieldId);
        if (customField == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (customField.getSystemFieldNum() != null && customField.getSystemFieldNum() != -1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u5b57\u6bb5\u4e3a\u7cfb\u7edf\u5b57\u6bb5");
        }
        this.initFieldShow(orgId, type);
        FieldShowInfo tobeDelete = this.fieldShowInfoDao.getByCustomId(orgId, type.getType(), customField.getId(), new String[]{"id", "fieldStatus", "preShowId"});
        if (tobeDelete == null || tobeDelete.getFieldStatus() == FieldStatus.DELETED.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        FieldShowInfo nextField = this.fieldShowInfoDao.getShowBehind(orgId, type.getType(), tobeDelete.getId(), new String[]{"id"});
        if (nextField != null) {
            nextField.setPreShowId(tobeDelete.getPreShowId());
            nextField.setUpdateTime(new Date());
            this.fieldShowInfoDao.update((Object)nextField, Boolean.valueOf(false), new String[]{"preShowId", "updateTime"});
        }
        tobeDelete.setFieldStatus(FieldStatus.DELETED.getCode());
        tobeDelete.setPreShowId(null);
        tobeDelete.setUpdateTime(new Date());
        this.fieldShowInfoDao.update((Object)tobeDelete, Boolean.valueOf(true), new String[]{"fieldStatus", "preShowId", "updateTime"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void modCustomShowName(Long orgId, DataProcType type, Long customFieldId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u9519\u8bef");
        Preconditions.checkArgument((customFieldId != null && customFieldId > 0L ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u5b57\u6bb5id\u9519\u8bef");
        CustomField customField = this.customFieldDao.getCustomFieldById(orgId, customFieldId);
        if (customField == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (customField.getSystemFieldNum() != null && customField.getSystemFieldNum() != -1) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u5b57\u6bb5\u4e3a\u7cfb\u7edf\u5b57\u6bb5");
        }
        if (customField.getIsPaused() != null && customField.getIsPaused().intValue() == BizConf.TRUE.intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u505c\u7528\u72b6\u6001");
        }
        this.initFieldShow(orgId, type);
        FieldShowInfo tobeEdit = this.fieldShowInfoDao.getByCustomId(orgId, type.getType(), customField.getId(), new String[]{"id", "fieldStatus"});
        if (tobeEdit == null || tobeEdit.getFieldStatus() == FieldStatus.DELETED.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (tobeEdit.getFieldStatus() == FieldStatus.PAUSED.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b57\u6bb5\u5df2\u5b58\u5728\u4e14\u4e3a\u505c\u7528\u72b6\u6001");
        }
        if (!customField.getLabel().equals(tobeEdit.getShowName())) {
            tobeEdit.setShowName(customField.getLabel());
            tobeEdit.setUpdateTime(new Date());
            this.fieldShowInfoDao.update((Object)tobeEdit, Boolean.valueOf(false), new String[]{"showName", "updateTime"});
        }
    }

    private boolean initFieldShow(Long orgId, DataProcType type) {
        boolean hasInit = this.fieldShowInfoDao.hasInit(orgId, type.getType());
        if (hasInit) {
            return false;
        }
        Class clazz = null;
        if (type.getType() == DataProcType.CONSULT.getType()) {
            clazz = DefaultClueField.class;
        } else if (type.getType() == DataProcType.ORG_STUDENT.getType()) {
            clazz = DefaultStudentField.class;
        }
        if (clazz != null) {
            return this.initCrmFieldShow(orgId, type, clazz);
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b");
    }

    private <T> boolean initCrmFieldShow(Long orgId, DataProcType type, Class<T> clazz) {
        List customFieldList;
        boolean hasInitCustom = false;
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            List sysShowIdList = Lists.newArrayList();
            int sysShowIndex = 0;
            int index = 0;
            while (index < fields.length) {
                FieldProp anno = fields[index].getAnnotation(FieldProp.class);
                if (anno != null) {
                    FieldShowInfo po = new FieldShowInfo();
                    po.setOrgId(orgId);
                    po.setType(type.getType());
                    po.setName(anno.name());
                    po.setShowName(anno.showName());
                    po.setQueryProp(anno.queryProp());
                    po.setFieldStatus(FieldStatus.NORMAL.getCode());
                    po.setShowStatus(anno.showStatus());
                    po.setLocked(anno.lock() ? BizConf.TRUE.intValue() : BizConf.FALSE.intValue());
                    po.setSorted(anno.sort() ? BizConf.TRUE.intValue() : BizConf.FALSE.intValue());
                    po.setIsSys(BizConf.TRUE.intValue());
                    po.setCustomFieldId(null);
                    if (anno.showStatus() == ShowStatus.SHOW.getCode()) {
                        if (sysShowIndex > 0) {
                            po.setPreShowId((Long)sysShowIdList.get(sysShowIndex - 1));
                        }
                        this.fieldShowInfoDao.save((Object)po, Boolean.valueOf(false), new String[0]);
                        sysShowIdList.add(po.getId());
                        ++sysShowIndex;
                    } else {
                        this.fieldShowInfoDao.save((Object)po, Boolean.valueOf(false), new String[0]);
                    }
                }
                ++index;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(customFieldList = this.customFieldDao.getCustomFieldList(orgId, BizConf.FALSE)))) {
            Long lastLockId = this.fieldShowInfoDao.getLastLockInfo(orgId, type.getType());
            if (lastLockId != null && lastLockId > 0L) {
                FieldShowInfo nextField = this.fieldShowInfoDao.getShowBehind(orgId, type.getType(), lastLockId, new String[]{"id"});
                List customShowIdList = Lists.newArrayList((Object[])new Long[]{lastLockId});
                int customShowIndex = 0;
                int index = 0;
                while (index < customFieldList.size()) {
                    CustomField field = (CustomField)customFieldList.get(index);
                    FieldShowInfo po = new FieldShowInfo();
                    po.setOrgId(orgId);
                    po.setCustomFieldId(field.getId());
                    po.setName(CUSTOM_STR + field.getId());
                    po.setShowName(field.getLabel());
                    po.setType(type.getType());
                    po.setIsSys(BizConf.FALSE.intValue());
                    po.setShowStatus(ShowStatus.SHOW.getCode());
                    po.setLocked(BizConf.FALSE.intValue());
                    po.setSorted(BizConf.FALSE.intValue());
                    if (field.getIsPaused() != null && field.getIsPaused().intValue() == BizConf.TRUE.intValue()) {
                        po.setFieldStatus(FieldStatus.PAUSED.getCode());
                        this.fieldShowInfoDao.save((Object)po, Boolean.valueOf(false), new String[0]);
                    } else {
                        po.setPreShowId((Long)customShowIdList.get(customShowIndex));
                        po.setFieldStatus(FieldStatus.NORMAL.getCode());
                        this.fieldShowInfoDao.save((Object)po, Boolean.valueOf(false), new String[0]);
                        customShowIdList.add(po.getId());
                        ++customShowIndex;
                    }
                    ++index;
                }
                if (nextField != null) {
                    nextField.setPreShowId((Long)customShowIdList.get(customShowIndex));
                    nextField.setUpdateTime(new Date());
                    this.fieldShowInfoDao.update((Object)nextField, Boolean.valueOf(false), new String[]{"preShowId", "updateTime"});
                }
            } else {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230\u9501\u5b9a\u5b57\u6bb5");
            }
            hasInitCustom = true;
        }
        return hasInitCustom;
    }
}

