package com.baijia.tianxiao.display.service;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.field.FieldOption;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 自定义字段显示/隐藏
 * Created by wangsixia on 2016/11/10.
 */
public interface FieldShowInfoService {

    /**
     * 获取显示设置
     * @param orgId
     * @param type
     * @return
     */
    Map<String, Object> getShowConfig(Long orgId, DataProcType type);

    /**
     * 保存显示设置
     * @param orgId 机构id
     * @param type 数据类型
     * @param getTime 获取时间,用于与FieldShowInfo最新更新时间比较,避免数据不同步
     * @param content 设置参数:显示字段json数组
     */
    void setShowConfig(Long orgId, DataProcType type, Long getTime, String content);

    /**
     * 获取线索/学员列表头部
     * @param orgId
     * @param type
     * @param excludeProps 需要过滤掉的字段属性名
     * @param filterCustom 是否要过滤掉自定义字段(导出数据时不自定义字段)
     * @return
     */
    List<FieldOption> getHeader(Long orgId, DataProcType type, Set<String> excludeProps, boolean filterCustom);

    /**
     * 获取导出表头(过滤掉自定义字段)
     * @param orgId
     * @param type
     * @return
     */

    /**
     * 添加自定义字段时,对应添加字段显示设置
     * @param orgId
     * @param type
     * @param customFieldId
     */
    void addCustomField(Long orgId, DataProcType type, Long customFieldId);

    /**
     * 停用自定义字段时,对应停用字段显示设置
     * @param orgId
     * @param type
     * @param customFieldId
     */
    void pauseCustomField(Long orgId, DataProcType type, Long customFieldId);

    /**
     * 启用自定义字段时,对应启用字段显示设置
     * @param orgId
     * @param type
     * @param customFieldId
     */
    void enableCustomField(Long orgId, DataProcType type, Long customFieldId);

    /**
     * 删除自定义字段时,对应删除字段显示设置
     * @param orgId
     * @param type
     * @param customFieldId
     */
    void deleteCustomField(Long orgId, DataProcType type, Long customFieldId);

    /**
     * 修改自定义字段label时,对应修改字段显示设置
     * @param orgId
     * @param type
     * @param customFieldId
     */
    void modCustomShowName(Long orgId, DataProcType type, Long customFieldId);
}
