
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.display.service;

import com.baijia.tianxiao.display.dto.request.QueryRequestDto;
import com.baijia.tianxiao.dto.query.ResponseListDto;

/**
 * @title FieldQueryService
 * @desc 查询指定字段的通用查询接口
 * @author cxm
 * @date 2016年3月15日
 * @version 1.0
 */
public interface FieldQueryService<T> {

    /**
     * 返回接口的查询类型
     * 
     * @return
     */
    public int getQueryEnum();

    /**
     * 通用查询服务
     * 
     * @param orgId
     * @param request request中包含参数的条件
     * @return
     */
    public ResponseListDto<T> query(Long orgId, QueryRequestDto request);
}
