package com.baijia.tianxiao.display.dto.response.crm;

import com.baijia.tianxiao.display.dto.annotation.FieldProp;
import lombok.Data;

import java.util.Date;

/**
 * 学员系统字段默认属性,剔除了一些不用的字段,如父母职业等
 * Created by wangsixia on 2016/11/11.
 */
@Data
public class DefaultStudentField{

    @FieldProp(name = "id", showName = "id", showStatus = 2)
    private Long id;

    @FieldProp(name = "name", showName = "姓名", showStatus = 0, queryProp = "name", lock = true, sort = true)
    private String name;

    @FieldProp(name = "mobile", showName = "手机号", showStatus = 0, queryProp = "mobile", lock = true, sort = true)
    private String mobile;

    private int gender;

    @FieldProp(name = "genderStr", showName = "性别", showStatus = 0, queryProp = "gender", sort = true)
    private String genderStr;

    private int source;

    @FieldProp(name = "sourceStr", showName = "来源", showStatus = 0, queryProp = "consultSource", sort = true)
    private String sourceStr;

    private long addCascadeId;

    @FieldProp(name = "addCascadeIdStr", showName = "课程顾问", showStatus = 0)
    private String addCascadeIdStr;

//    private Date nextRemindTime;
//
//    @FieldProp(name = "nextRemindTimeStr", showName = "下次跟进时间", showStatus = 0, queryProp = "nextRemindTime", sort = true)
//    private String nextRemindTimeStr;

    @FieldProp(name = "cascadeIdStr", showName = "班主任", showStatus = 0)
    private String cascadeIdStr;

    @FieldProp(name = "hasLesson", showName = "是否排课", showStatus = 0)
    private String hasLesson;

    @FieldProp(name = "lessonNum", showName = "已上课次/总课次", showStatus = 0)
    private String lessonNum;

    private Date birthday;

    @FieldProp(name = "birthdayStr", showName = "生日", showStatus = 1, queryProp = "birthday", sort = true)
    private String birthdayStr;

    private Integer relationship;

    @FieldProp(name = "relationshipStr", showName = "亲属关系", showStatus = 1, queryProp = "relationship", sort = true)
    private String relationshipStr;

    @FieldProp(name = "parentName", showName = "家长姓名", showStatus = 1, queryProp = "parentName", sort = true)
    private String parentName;

    @FieldProp(name = "parentMobile", showName = "家长手机号", showStatus = 1, queryProp = "parentMobile", sort = true)
    private String parentMobile;

    @FieldProp(name = "school", showName = "公立学校", showStatus = 1, queryProp = "school", sort = true)
    private String school;

    @FieldProp(name = "degreeClass", showName = "年级", showStatus = 1, queryProp = "degreeClass", sort = true)
    private String degreeClass;

    @FieldProp(name = "address", showName = "详细地址", showStatus = 1, queryProp = "address", sort = true)
    private String address;

    @FieldProp(name = "qq", showName = "QQ", showStatus = 1, queryProp = "qq", sort = true)
    private String qq;

    @FieldProp(name = "mail", showName = "邮箱", showStatus = 1, queryProp = "mail", sort = true)
    private String mail;

    @FieldProp(name = "tagsStr", showName = "标签", showStatus = 1)
    private String tagsStr;
}
