
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.display.service;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.display.dto.FieldDto;

import java.util.List;

/**
 * @title OrgShowService
 * @desc 列表字段展示功能
 * @author shanyu
 * @date 2016年3月14日
 * @version 1.0
 */

public interface OrgShowService {

    /**
     * 获取当前展示字段
     * 
     * @param orgId 机构id
     * @param queryListEnum 列表查询对应枚举
     * @param cls 响应信息对应dto
     * @return
     */
    List<FieldDto> getCurrentHeaders(Long orgId, DataProcType dataProcType, Class<?> cls);

    /**
     * 获取所有字段信息
     * 
     * @param orgId
     * @param queryListEnum
     * @param cls
     * @return
     */
    List<FieldDto> getAllHeaders(Class<?> cls);

    /**
     * 设置头部展示信息
     * 
     * @param orgId
     * @param queryListEnum
     * @param cls
     */
    void modHeaders(Long orgId, List<FieldDto> dtos, DataProcType dataProcType, Class<?> cls);
}
