package com.baijia.tianxiao.sal.display.dto.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 系统字段属性注解
 * Created by wangsixia on 2016/11/11.
 */
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
public @interface FieldProp {
    // 字段属性名
    public String name();

    // 字段显示名
    public String showName();

    // 字段显示状态 ShowStatus:0显示字段;1隐藏字段;2隐藏属性
    public int showStatus();

    // 用于前端排序选择属性名,lock为true时,需要指定queryProp
    public String queryProp() default "";

    // 是否锁定,用于前端设置显示/隐藏时控制不可移动
    public boolean lock() default false;

    // 是否可排序,用于列表中是否可排序字段
    public boolean sort() default false;

}
