/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sal.course.enums.LessonConflictEnum;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgLessonConflictServiceImpl
implements OrgLessonConflictService {
    private static final Logger log = LoggerFactory.getLogger(OrgLessonConflictServiceImpl.class);
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;

    @Override
    public List<OrgLessonConflict> checkTeacherConflict(Long orgId, Long teacherId, Date startTime, Date endTime, Long lessonId, PageDto pageDto) {
        this.validata(orgId, teacherId, null, startTime, endTime);
        return this.orgLessonConflictDao.queryTeacherLessonConflict(orgId, teacherId, startTime, endTime, lessonId, pageDto);
    }

    @Override
    public List<OrgLessonConflict> checkRoomConflict(Long orgId, Long roomId, Date startTime, Date endTime, Long lessonId, PageDto pageDto) {
        this.validata(orgId, null, roomId, startTime, endTime);
        return this.orgLessonConflictDao.queryRoomLessonConflict(orgId, roomId, startTime, endTime, lessonId, pageDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrgLessonConflicts(List<OrgLessonConflict> lists) {
        this.orgLessonConflictDao.saveOrgLessonConflicts(lists);
    }

    @Override
    public int queryTeacherConflictNum(Long orgId, Long teacherId, Date startTime, Date endTime, Long lessonId) {
        this.validata(orgId, teacherId, null, startTime, endTime);
        return this.orgLessonConflictDao.queryTeacherConflictNum(orgId, teacherId, startTime, endTime, lessonId);
    }

    @Override
    public int queryRoomConflictNum(Long orgId, Long roomId, Date startTime, Date endTime, Long lessonId) {
        this.validata(orgId, null, roomId, startTime, endTime);
        return this.orgLessonConflictDao.queryRoomConflictNum(orgId, roomId, startTime, endTime, lessonId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgLessonConflictForTeacherChange(OrgLessonConflict conflict) {
        HashMap condition = Maps.newHashMap();
        condition.put("org_id", conflict.getOrgId());
        condition.put("lesson_id", conflict.getLessonId());
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(1));
        List resultList = this.orgLessonConflictDao.queryByCondition((Map)condition, pageDto, new String[0]);
        if (resultList.size() > 0) {
            OrgLessonConflict conflict1 = (OrgLessonConflict)resultList.get(0);
            this.orgLessonConflictDao.delByCondition((Map)condition);
            conflict.setRoomId(conflict1.getRoomId());
            conflict.setStartTime(conflict1.getStartTime());
            conflict.setEndTime(conflict1.getEndTime());
            this.orgLessonConflictDao.save((Object)conflict, new String[0]);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgLessonConflictForTeacherChange(List<OrgLessonConflict> conflictList) {
        Set set = Sets.newHashSet();
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(1));
        for (OrgLessonConflict conflict : conflictList) {
            HashMap condition = Maps.newHashMap();
            condition.put("org_id", conflict.getOrgId());
            condition.put("lesson_id", conflict.getLessonId());
            List resultList = this.orgLessonConflictDao.queryByCondition((Map)condition, pageDto, new String[0]);
            if (resultList.size() <= 0) continue;
            if (!set.contains(conflict.getOrgId() + "_" + conflict.getLessonId())) {
                set.add(conflict.getOrgId() + "_" + conflict.getLessonId());
                this.orgLessonConflictDao.delByCondition((Map)condition);
            }
            OrgLessonConflict conflict1 = (OrgLessonConflict)resultList.get(0);
            conflict.setRoomId(conflict1.getRoomId());
            conflict.setStartTime(conflict1.getStartTime());
            conflict.setEndTime(conflict1.getEndTime());
            this.orgLessonConflictDao.save((Object)conflict, new String[0]);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgLessonConflictForRoomOrTimeChange(OrgLessonConflict conflict) {
        HashMap fields = Maps.newHashMap();
        if (conflict.getRoomId() != null && conflict.getRoomId() > 0L) {
            fields.put("room_id", conflict.getRoomId());
        }
        if (conflict.getStartTime() != null) {
            fields.put("start_time", conflict.getStartTime());
        }
        if (conflict.getEndTime() != null) {
            fields.put("end_time", conflict.getEndTime());
        }
        if (conflict.getDelStatus() != null) {
            fields.put("del_status", conflict.getDelStatus());
        }
        HashMap condition = Maps.newHashMap();
        condition.put("org_id", conflict.getOrgId());
        condition.put("lesson_id", conflict.getLessonId());
        this.orgLessonConflictDao.updateLessonConflictByCondition(conflict.getOrgId(), (Map)fields, (Map)condition);
    }

    @Override
    public LessonConflictEnum lessonConflictFlagCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto) {
        LessonConflictEnum result = LessonConflictEnum.NO_CONFLICT;
        Long teacherId = lessonConflictCheckDto.getTeacherId();
        Long roomId = lessonConflictCheckDto.getRoomId();
        Date startTime = lessonConflictCheckDto.getStartTimeDate();
        Date endTime = lessonConflictCheckDto.getEndTimeDate();
        Long lessonId = lessonConflictCheckDto.getLessonId();
        int teacherConflictNum = 0;
        int roomConflictNum = 0;
        if (teacherId != null && teacherId > 0L) {
            teacherConflictNum = this.queryTeacherConflictNum(orgId, teacherId, startTime, endTime, lessonId);
        }
        if (roomId != null && roomId > 0L) {
            roomConflictNum = this.queryRoomConflictNum(orgId, roomId, startTime, endTime, lessonId);
        }
        if (teacherConflictNum > 0 && roomConflictNum > 0) {
            result = LessonConflictEnum.TEACHER_AND_ROOM;
        } else if (teacherConflictNum > 0) {
            result = LessonConflictEnum.TEACHER;
        } else if (roomConflictNum > 0) {
            result = LessonConflictEnum.ROOM;
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByLessonIds(Long orgId, List<Long> lessonIds) {
        HashMap conditions = Maps.newHashMap();
        conditions.put("org_id", orgId);
        conditions.put("lesson_id", lessonIds);
        this.orgLessonConflictDao.delByCondition((Map)conditions);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgLessonConflictsForce(OrgLessonConflict conflict) {
        HashMap conditions = Maps.newHashMap();
        conditions.put("org_id", conflict.getOrgId());
        conditions.put("lesson_id", conflict.getLessonId());
        this.orgLessonConflictDao.delByCondition((Map)conditions);
        this.orgLessonConflictDao.save((Object)conflict, new String[0]);
    }

    private void validata(Long orgId, Long teacherId, Long roomId, Date startTime, Date endTime) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784id\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((teacherId != null && teacherId > 0L || roomId != null && roomId > 0L ? 1 : 0) != 0, (Object)"\u8001\u5e08id/\u6559\u5ba4id\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u5408\u6cd5");
    }
}

