package com.baijia.tianxiao.sal.course.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSeatDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTimeSpanDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.OrgTimeSpan;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.LessonWay;
import com.baijia.tianxiao.sal.course.constant.RestConfig;
import com.baijia.tianxiao.sal.course.dto.OrgClassLessonDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseDetailResponseDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseInfoDto;
import com.baijia.tianxiao.sal.course.dto.OrgCourseQueryResponseDto;
import com.baijia.tianxiao.sal.course.dto.request.OrgRecommendCourseRequestDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgCourseGroupDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgTimeSpanDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupRelateService;
import com.baijia.tianxiao.sal.course.service.OrgCourseGroupService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

@Slf4j
@Service
public class OrgCourseServiceImpl implements OrgCourseService {

    private final static int TOTAL_COURSE_COLOR_COUNT = 35;
    @Resource
    OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseSeatDao orgCourseSeatDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;
    @Resource
    private OrgTimeSpanDao orgTimeSpanDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private AreaDao areaDao;
    @Resource
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Resource
    private OrgCourseGroupService orgCourseGroupService;
    @Resource
    private OrgCourseGroupRelateService orgCourseGroupRelateService;
    @Resource
    private UserDao userDao;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Autowired
    private OrgCourseGroupDao orgCourseGroupDao;
    @Autowired
    private OrgCoursePhotoDao orgCoursePhotoDao;
    @Autowired
    private TxAccountPermissionService txAccountPermission;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;
    @Resource
    private TXCommonRuleService tXCommonRuleService;
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;
    @Resource
    private Environment environment;

    private static boolean checkTime(String start, String end) {

        TimeStamp startTime = TimeStamp.parse(start);
        TimeStamp endTime = TimeStamp.parse(end);
        if (startTime.getHour() > endTime.getHour()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "开始时间 大于 结束时间");
        }

        if (startTime.getMinute() % 5 != 0 || endTime.getMinute() % 5 != 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "分钟不是5的整数倍");
        }

        if (startTime.getSecond() != 0 || endTime.getSecond() != 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "秒必须为0");
        }

        return true;
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? number.longValue() : null;
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgCourseQueryResponseDto> getOrgCourses(@NonNull Long orgId, String key, PageDto pageDto) {

        Long orgNumber = this.getOrgNumber(orgId);

        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return Lists.newArrayList();
        }

        log.info("getOrgCourses orgNumber {}", orgNumber);

        List<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        List<OrgCourse> orgCourses = orgCourseDao.getCoursesByOrgNumber(orgNumber, key,
            OrgCourseStatus.IN_PROGRESS.getCode(), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, pageDto);

        Set<Long> courseIds = new HashSet<>();
        if (CollectionUtils.isNotEmpty(orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                courseIds.add(orgCourse.getId());
                // 初始化课程颜色
                if (StringUtils.isEmpty(orgCourse.getColor())) {
                    orgCourse.setColor(this.getNextRandomColor());
                    this.orgCourseDao.saveOrUpdate(orgCourse);
                }
            }
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;

    }

    @Override
    public void assign(Long orgId, List<Long> courserIds, Long cascadeId) {
        List<OrgCourse> orgCourses = orgCourseDao.getByIds(courserIds);
        OrgAccount orgAccount = orgAccountDao.getById(orgId);

        Preconditions.checkArgument(orgCourses != null && orgCourses.size() > 0, "org course is null" + courserIds);
        Preconditions.checkArgument(orgAccount != null, "org account is null" + orgId);

        log.debug("course assign = orgaccount={},orgCourses={}", orgAccount, orgCourses);
        for (OrgCourse orgCourse : orgCourses) {
            // 数据操作权限 判断
            if (orgCourse.getOrgNumber().longValue() != orgAccount.getNumber().longValue()) {
                throw new PermissionException();
            }

            orgCourse.setCascadeId(cascadeId == null ? 0 : cascadeId.intValue());
            orgCourseDao.update(orgCourse);
        }

    }

    @Override
    @Transactional(readOnly = true)
    @DataAuthority(resourceTypes = { RequestSourceDesc.COURSE_LIST })
    public List<OrgCourseQueryResponseDto> getEnrolledOrgCourses(@NonNull Long orgId, String key, PageDto pageDto) {

        Long orgNumber = this.getOrgNumber(orgId);

        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return Lists.newArrayList();
        }

        log.info("getOrgCourses orgNumber {}", orgNumber);

        // boolean isStaff = this.txAccountPermission.hasPermission(cascadeId, ApplicationType.APP,
        // TXPermissionConstant.)
        List<Long> cascadeIds = null;
        boolean canAccess = RequestSourceDesc.COURSE_LIST.canAccess("getEnrolledOrgCourses", this.getClass(),
            new Class<?>[] { Long.class, String.class, PageDto.class });
        if (!canAccess) {
            log.info("{} need dataAuthority filter ", RequestSourceDesc.COURSE_LIST.getAccountRoleType());
            cascadeIds = new ArrayList<>();
            cascadeIds.add(TianxiaoMContext.getTXCascadeId().longValue());
        }

        List<OrgCourse> orgCourses =
            orgCourseDao.getCoursesByCascadeIds(orgNumber, cascadeIds, key, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        List<OrgCourse> result = new ArrayList<>();
        if (orgCourses == null || orgCourses.isEmpty()) {
            return Collections.emptyList();
        } else {
            Map<Long, OrgCourse> courseMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap(
                orgCourses, new com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter<Long, OrgCourse>() {
                    @Override
                    public Long extract(OrgCourse orgCourse) {
                        return orgCourse.getId();
                    }
                });

            List<OrgStudentCourse> courses = orgStudentCourseDao.getOrgCourseByOrgId(orgId, courseMap.keySet(), null);

            for (OrgStudentCourse course : courses) {
                if (courseMap.get(course.getCourseId()) != null) {
                    result.add(courseMap.get(course.getCourseId()));
                }
            }
        }
        log.info("Result size=" + result.size());
        if (result.size() < 1) {
            return Collections.emptyList();
        }
        pageDto.setCount(result.size());

        Collections.sort(result, new Comparator<OrgCourse>() {
            @Override
            public int compare(OrgCourse o1, OrgCourse o2) {
                return (int) (o2.getId() - o1.getId());
            }
        });

        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int end = pageDto.getPageNum() * pageDto.getPageSize();

        result = result.subList(Math.min(start, result.size()), Math.min(end, result.size()));

        List<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();

        if (CollectionUtils.isNotEmpty(result)) {
            for (OrgCourse orgCourse : result) {
                OrgCourseQueryResponseDto courseQueryResponseDto =
                    OrgCourseQueryResponseDto.getInstanceByOrgCourse(orgCourse);
                // courseQueryResponseDto.setCoverUrl(getCoverUrl(orgCourse));
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;

    }

    private void fillCourseQueryResponseDto(Map<Long, List<String>> courseIdTeacherIdMap, OrgCourse orgCourse,
        OrgCourseQueryResponseDto courseQueryResponseDto) {
        courseQueryResponseDto.setCourseName(orgCourse.getName());
        courseQueryResponseDto.setOrgCourseId(orgCourse.getId());
        courseQueryResponseDto.setColor(orgCourse.getColor());
        courseQueryResponseDto.setOrgCourseNumber(orgCourse.getNumber());
        courseQueryResponseDto.setOriginPrice(orgCourse.getPrice());
        courseQueryResponseDto.setCoverUrl(getCoverUrl(orgCourse));
        List<String> teacherNames = courseIdTeacherIdMap.get(orgCourse.getId());
        if (CollectionUtils.isNotEmpty(teacherNames)) {
            courseQueryResponseDto.setTeacherName(StringUtils.join(teacherNames.toArray(), ','));
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Map<Long, List<String>> getCourseIdTeacherNamesMap(Collection<Long> courseIds) {
        List<OrgCourseTeacher> orgCourseTeachers = orgCourseTeacherDao.getOrgCourseTeacher(courseIds, null);

        if (CollectionUtils.isNotEmpty(orgCourseTeachers)) {
            Map<Long, List<String>> result = Maps.newHashMap();
            Set<Long> teacherIds = Sets.newHashSet();
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                teacherIds.add(orgCourseTeacher.getUserId());
            }

            Map<Long, String> teacherNames = teacherDao.getTeacherRealNameMap(teacherIds);
            for (OrgCourseTeacher orgCourseTeacher : orgCourseTeachers) {
                Long courseId = orgCourseTeacher.getOrgCourseId();
                if (!result.containsKey(courseId)) {
                    result.put(courseId, Lists.<String> newArrayList());
                }
                result.get(courseId).add(teacherNames.get(orgCourseTeacher.getUserId()));
            }
            log.debug("courseIds:{}, teacherNames:{}", courseIds, teacherNames);
            return result;
        }

        return Collections.emptyMap();

    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgCourseQueryResponseDto> getLatestOrgCourses(Long orgId, PageDto pageDto) {

        log.info("getOrgLatestCourses-->orgId {}", orgId);
        List<OrgCourseQueryResponseDto> courseQueryResponseDtos = new ArrayList<OrgCourseQueryResponseDto>();
        // 获取最近课程的IDs
        List<Long> courseIds = this.coursePurchaseDao.getLatestdPurchaseCourseIdsList(orgId);

        if (CollectionUtils.isEmpty(courseIds)) {
            log.info("get no courses id");
            return Collections.emptyList();
        }

        List<OrgCourse> orgCourses = orgCourseDao.getByIdsOrderByIn(courseIds, pageDto.getPageSize());

        if (CollectionUtils.isEmpty(orgCourses)) {
            log.info("get no courses ids={}", courseIds);
            return Collections.emptyList();
        }

        if (CollectionUtils.isNotEmpty(orgCourses)) {
            Map<Long, List<String>> courseIdTeacherIdMap = this.getCourseIdTeacherNamesMap(courseIds);
            for (OrgCourse orgCourse : orgCourses) {
                OrgCourseQueryResponseDto courseQueryResponseDto = new OrgCourseQueryResponseDto();
                fillCourseQueryResponseDto(courseIdTeacherIdMap, orgCourse, courseQueryResponseDto);
                courseQueryResponseDtos.add(courseQueryResponseDto);
            }
        }
        return courseQueryResponseDtos;
    }

    @Override
    @Transactional(readOnly = true)
    public List<String> getCourseColors() {
        // 不换存，每次读取文件
        String colors = PropertiesReader.getValueNoCache("erp.properties", "course.colors");
        String[] colorsArray = colors.split(",");
        if (colorsArray.length != TOTAL_COURSE_COLOR_COUNT) {
            log.warn("course colors count = {}", colorsArray.length);
        }
        return Lists.newArrayList(colorsArray);
    }

    /**
     * 获取下一个课程的颜色
     *
     * @return
     */
    private String getNextRandomColor() {
        List<String> colors = getCourseColors();
        Random rand = new Random();
        return colors.get(rand.nextInt(colors.size() - 1));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeCourseColor(@NonNull Long orgId, @NonNull Long courseId, @NonNull String color) {
        if (color.startsWith("#") && color.length() == 7) {
            this.orgCourseDao.changeCourseColor(this.getOrgNumber(orgId).intValue(), courseId, color);
        } else {
            log.error("color = {} 格式不对 ", color);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "wrong color format.");
        }
    }

    // 如果updateRepeate=true,始终返回false,并且设置course的id值，以便更新。
    private boolean isCourseDuplicate(OrgCourseInfoDto course, boolean updateRepeate) {
        // 判断是否重复
        if (updateRepeate) {
            // course.setCourseId(courseId);
            return false;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveOrUpdateCourse(Long orgId, OrgCourseInfoDto course, boolean doDel, boolean updateRepeate) {
        log.info("orgId={}, course={}", orgId, course);
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId illegal.");
        Preconditions.checkArgument(course != null, "course == null");
        Preconditions.checkArgument(StringUtils.isNotBlank(course.getCourseName()), "课程名不能为空!");
        Preconditions.checkArgument(course.getCoursePrice() != null && course.getCoursePrice() > 0, "课程价格必须>0");
        // Preconditions.checkArgument(course.getFreq() != null && course.getFreq() > 0, "上课次数必须>0");
        // Preconditions.checkArgument(course.getMaxStudent() != null && course.getMaxStudent() > 0, "班级人数不能为空!");

        if (isCourseDuplicate(course, updateRepeate)) {
            throw new BussinessException(CourseErrorCode.COURSE_EXSIST);
        }

        boolean isUpdate = course.getCourseId() != null && course.getCourseId() > 0;
        if(isUpdate){
            OrgCourse orgCourse = orgCourseDao.getByCourseId(course.getCourseId());
            if(orgCourse != null && orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                course.setStartTime(null);
                course.setEndTime(null);
                course.setMaxStudent(null);
                course.setFreq(null);
            }
        }
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setOrgNumber(this.getOrgNumber(orgId));
        orgCourse.setId(isUpdate ? course.getCourseId() : null);
        orgCourse.setBeginTime(course.getStartTime());
        orgCourse.setEndTime(course.getEndTime());
        orgCourse.setColor(getNextRandomColor());
        orgCourse.setCover(course.getCoverStorageId());

        orgCourse.setFreq(course.getFreq());
        orgCourse.setName(course.getCourseName());
        orgCourse.setMaxStudent(course.getMaxStudent());
        orgCourse.setNumber(System.nanoTime());
        orgCourse.setIsDel(course.getIsDel());
        orgCourse.setSubjectId(0);
        if (!isUpdate && course.getStatus() == null) {
            orgCourse.setStatus(OrgCourseStatus.OFFLINE.getCode());
        } else {
            orgCourse.setStatus(course.getStatus());
        }
        orgCourse.setVerifyStatus(AuditStatus.PASS.getValue());
        orgCourse.setAddress(course.getAddress());
        orgCourse.setLessonWay(LessonWay.STU_ACTIVE.getValue());
        Double lng = course.getLng();
        Double lat = course.getLat();
        if (lng != null && lat != null) {
            orgCourse.setOfflinePoi(lng + "," + lat);
        }

        // 原有逻辑会单独更新一次 introduction ，测试环境上，为空的时候会抛异常，但是线上环境同样的场景不会抛异常。只有强制更新introduction不为空
        if (course.getIntroduction() == null) {
            course.setIntroduction("");
        }
        if (course.getIntroduction() != null) {
            Blob intro = BaseUtils.strToBlob(course.getIntroduction(), "UTF-8");
            orgCourse.setIntroduction(intro);
        }

        orgCourse.setBranchId(-1L);
        orgCourse.setClsfyId(-1L);
        orgCourse.setRoomId(-1L);
        orgCourse.setLayoutId(-1L);
        orgCourse.setPrice(course.getCoursePrice());
        orgCourse.setLessonSummary(course.getLessonSummary());

        
        
        if(isUpdate){
            orgCourse.setCourseType(null);
        }else{
            Integer courseType = course.getCourseType();
            if(courseType == null){
                courseType = CourseTypeEnum.COURSE_TYPE_CLASS.getCode();
            }
            else{
                if(courseType>2){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程类型参数错误");
                }
            }
            Integer isCourse = null;
            Integer isClass = null;
            if(courseType == CourseTypeEnum.COURSE_TYPE_CLASS.getCode()){
                isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
                isClass = CourseTypeEnum.IS_CLASS_TRUE.getCode();
            }
            else if(courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                isCourse = CourseTypeEnum.IS_COURSE_TRUE.getCode();
                isClass = CourseTypeEnum.IS_CLASS_FALSE.getCode();
            }
            else{
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程类型参数错误");
            }
            
            orgCourse.setCourseType(courseType);
            orgCourse.setIsCourse(isCourse);
            orgCourse.setIsClass(isClass);
           
        }

        log.debug("orgCourse={}", orgCourse);
        if (isUpdate) {
            orgCourseDao.update(orgCourse, false);
            if (course.getIntroduction() == null) {
                orgCourseDao.update(orgCourse, true, "introduction");
            }
        } else {
            orgCourseDao.save(orgCourse);
        }
        
        OrgCourse newCourse = orgCourseDao.getById(orgCourse.getId());
        Integer courseType = newCourse.getCourseType();
        if (isUpdate) {
            
            if (course.getConsumeRule() != null) {
                if(courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                    if(course.getConsumeRule()==CourseConsumeRuleEnum.TIME_0.getValue()){
                        throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课不支持当前设置的课消规则");
                    }
                }
                this.orgCourseConsumeRuleService.saveOfupdate(orgId, course.getCourseId(), course.getConsumeRule());
            }
            
        } else {
            Integer courseConsumeRuleValue = course.getConsumeRule();
            if(courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                if(course.getConsumeRule()==CourseConsumeRuleEnum.TIME_0.getValue()){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课不支持当前设置的课消规则");
                }
            }
            if (courseConsumeRuleValue == null) {
                TXCommonRule commonRule = tXCommonRuleService.getByOrgId(orgId.intValue());
                if(courseType == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                    courseConsumeRuleValue = commonRule.getVipConsumeRule();
                } else {
                    courseConsumeRuleValue = commonRule.getConsumeRule();
                }
                
            }
            if (orgCourse.getId() != null && orgCourse.getId() > 0) {
                this.orgCourseConsumeRuleService.create(orgId, orgCourse.getId(), courseConsumeRuleValue);
            }

        }

        if (orgCourse.getId() != null && orgCourse.getId() > 0) {
            long number = SerialNumberUtil.generateNumber(orgCourse.getId().intValue(), SerialNumberUtil.COURSE_MAX, 4);
            orgCourse.setNumber(number);
            this.orgCourseDao.saveOrUpdate(orgCourse, "number");

            if (StringUtils.isNotBlank(course.getTeacherIds())) {
                List<Long> teacherIds = null;
                try {
                    teacherIds = JacksonUtil.str2List(course.getTeacherIds(), Long.class);
                } catch (IOException e) {
                    e.printStackTrace();
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "teacherIds 参数错误！");
                }
                log.debug("{},{}", teacherIds, course.getTeacherIds());

                List<Long> courseTeachers = orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
                if (doDel && CollectionUtils.isNotEmpty(courseTeachers)) {
                    List<Long> toDelTeacherIds = findNeedDelTeacher(teacherIds, courseTeachers);
                    if (toDelTeacherIds.size() > 0) {
                        int delResult = courseTeacherService.delTeacherFromCourseForLessonCheck(orgId,
                            orgCourse.getId(), toDelTeacherIds);
                        if (delResult == 0) {
                            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "已经排课的老师无法删除");
                        }
                    }
                }
                teacherIds.removeAll(courseTeachers);
                courseTeacherService.addTeacherToCourse(orgId, orgCourse.getId(), teacherIds);
            }

            // 课程分类
            if (StringUtils.isNotBlank(course.getGroup())) {
                List<Integer> grpIds;
                try {
                    grpIds = JacksonUtil.str2List(course.getGroup(), Integer.class);
                    editGroupsOfCourse(orgId, orgCourse.getId(), grpIds);
                } catch (IOException e) {
                    e.printStackTrace();
                    log.warn("{}", e);
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "group json format error!");
                }
            }

            // coverUrl
            if (course.getCoverStorageId() != null) {
                editCoursePhoto(orgCourse.getId(), course.getCoverStorageId().longValue());
            }

        } else {
            log.error("orgCourse={}", orgCourse);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "courseId illegal.");
        }

        return orgCourse.getId();
    }

    private List<Long> findNeedDelTeacher(List<Long> newTeacherList, List<Long> existingTeacherList) {
        List<Long> toDelTeacherIds = Lists.newArrayList(existingTeacherList);
        toDelTeacherIds.removeAll(newTeacherList);
        return toDelTeacherIds;
    }

    private List<Long> findNeedAddTeacher(List<Long> newTeacherList, List<Long> existingTeacherList) {
        List<Long> toAddTeacherIds = Lists.newArrayList(newTeacherList);
        toAddTeacherIds.removeAll(existingTeacherList);
        return toAddTeacherIds;
    }

    // 兼容以前的多张图片
    private void editCoursePhoto(Long courseId, Long storageId) {
        Preconditions.checkNotNull(courseId);
        Preconditions.checkNotNull(storageId);
        String coverUrl = this.getCoverUrl(storageId);
        /*
         * boolean exist = orgCoursePhotoDao.isPhotoExist(courseId, storageId); if (!exist) {
         *
         * }
         */
        OrgCoursePhoto photo = orgCoursePhotoDao.getLastAddPhoto(courseId);
        if (photo == null) {
            photo = new OrgCoursePhoto();
        }
        photo.setCreateTime(new Date());
        photo.setOrgCourseId(courseId);
        photo.setStorageId(storageId);
        photo.setUrl(coverUrl);
        photo.setCreateTime(new Date());

        orgCoursePhotoDao.saveOrUpdate(photo);
    }

    private void editGroupsOfCourse(Long orgId, Long courseId, List<Integer> grpIds) {
        List<Integer> orgGrpIds = this.orgCourseGroupDao.getOrgCourseGroupIdList(orgId.intValue());
        if (CollectionUtils.isEmpty(orgGrpIds) || grpIds == null || courseId == null) {
            return;
        }

        grpIds.retainAll(orgGrpIds);

        List<Integer> existGrpIds =
            orgCourseGroupRelateDao.getGroupIdByCourseId(courseId, CourseType.ORG_COURSE.getCode());
        if (CollectionUtils.isNotEmpty(existGrpIds)) {
            Collection<Integer> toDelGrpIds = Lists.newArrayList(existGrpIds);
            toDelGrpIds.removeAll(grpIds);
            orgCourseGroupRelateDao.deleteGroupOfCourse(courseId, toDelGrpIds, CourseType.ORG_COURSE.getCode());
        }

        for (Integer gid : grpIds) {
            OrgRecommendCourseRequestDto hotCourse = new OrgRecommendCourseRequestDto();
            hotCourse.setCourseId(courseId);
            hotCourse.setCourseType(CourseType.ORG_COURSE.getCode());
            orgCourseGroupRelateService.addCourse(gid, hotCourse, 0);
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    @Transactional(readOnly = true)
    public List<OrgCourseDetailResponseDto> getOrgCourseList(Long orgId, int status, PageDto pageDto) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        List<OrgCourseDetailResponseDto> data = Lists.newArrayList();
        if (account == null) {
            return data;
        }

        List<OrgCourse> courses =
            this.orgCourseDao.getAndFilterOrgCourse(account.getNumber(), null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, pageDto);
        log.debug("orgId:{}, status:{}, courses:{}", orgId, status, courses);
        if (courses != null && !courses.isEmpty()) {
            Map<Long, Storage> storageCache = this.getAndCacheStorage(courses);
            List<Long> courseIds = BaseUtils.getListFilter(courses, "id");
            Map<Long, List<String>> teacherCache = getCourseIdTeacherNamesMap(courseIds);
            OrgCourseDetailResponseDto dto = null;

            String host = PropertiesReader.getValue("wxm", "m.server");
            String imgServer = PropertiesReader.getValue("wxm", "img.server");
            for (OrgCourse course : courses) {
                dto = new OrgCourseDetailResponseDto();
                dto.setCourseType(CourseType.ORG_COURSE.getCode());
                dto.setName(course.getName());
                dto.setNumber(course.getNumber());
                dto.setPrice(course.getPrice() + "");
                dto.setCourseId(course.getId());
                if (teacherCache.containsKey(course.getId())) {
                    dto.setTeacherName(teacherCache.get(course.getId()).get(0));
                } else {
                    dto.setTeacherName("待定");
                }
                dto.setPreface(this.getImgUrl(course.getCover() == null ? 0 : course.getCover().longValue(),
                    storageCache, imgServer));
                dto.setLink(BizConf.ORG_COURSE_DETAIL.replace("{host}", host).replace("{number}",
                    course.getNumber().toString()));
                data.add(dto);
            }
        }
        log.info("getOrgCourseList.orgId:{}, status:{}, pageDto:{}, data:{}", orgId, status, pageDto, data);
        return data;
    }

    /**
     * 获取并缓存图片信息
     *
     * @param courses
     * @return
     */
    @SuppressWarnings("unchecked")
    private Map<Long, Storage> getAndCacheStorage(List<OrgCourse> courses) {
        List<Long> storageIds = BaseUtils.getListFilter(courses, "cover");
        Map<Long, Storage> cache = storageDao.getStorageMapByIds(storageIds);
        log.debug("storageIds:{}, cache:{}", storageIds, cache);
        return cache;
    }

    /**
     * 获取图片url地址
     *
     * @param storageId
     * @param cache
     * @param imgServer
     * @return
     */

    private String getImgUrl(Long storageId, Map<Long, Storage> cache, String imgServer) {
        String url = "";
        if (cache.containsKey(storageId)) {
            Storage storage = cache.get(storageId);
            if (storage != null) {
                url = this.constructUrl(storage, imgServer);
            }
        }
        return url;
    }

    /**
     * 获取cdb.storage表数据对应图片url
     *
     * @param storage
     * @return
     */
    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (StringUtils.isNotBlank(storage.getMimetype())) {
            if (storage.getMimetype().contains("/")) {
                surfix = storage.getMimetype().split("/")[1];
            } else {
                surfix = storage.getMimetype();
            }
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    @Transactional(readOnly = true)
    public OrgCourseDetailResponseDto getOrgCourseDetail(Long orgId, Long courseId) {
        OrgCourse course = this.orgCourseDao.getById(courseId);
        OrgCourseDetailResponseDto dto = null;
        if (course != null) {
            String host = PropertiesReader.getValue("wxm", "m.server");
            String imgServer = PropertiesReader.getValue("wxm", "img.server");
            List<Long> ids = Lists.newArrayList(course.getId());
            Map<Long, List<String>> cache = this.getCourseIdTeacherNamesMap(ids);

            dto = new OrgCourseDetailResponseDto();
            dto.setCourseType(CourseType.CLASS.getCode());
            dto.setName(course.getName());
            dto.setNumber(course.getNumber());
            dto.setPrice(course.getPrice() + "");
            if (cache.containsKey(course.getId())) {
                dto.setTeacherName(cache.get(course.getId()).get(0));
            } else {
                dto.setTeacherName("待定");
            }

            if (course.getCover() != null) {
                Storage storage = this.storageDao.getById(course.getCover());
                dto.setPreface(this.constructUrl(storage, imgServer));
            } else {
                dto.setPreface("http://img.gsxservice.com/10497162_byhm2qrj.png");
            }
            dto.setLink(
                BizConf.ORG_COURSE_LINK.replace("{host}", host).replace("{number}", course.getNumber().toString()));
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addOrEditOrgTimeSpan(Long orgId, List<OrgTimeSpanDto> timeSpanList) {

        log.info("timeSpanList = {}", timeSpanList);

        for (OrgTimeSpanDto dto : timeSpanList) {

            if (!checkTime(dto.getStartTime(), dto.getEndTime())) {
                return;
            }

            OrgTimeSpan orgTimeSpan = new OrgTimeSpan();
            Time endTime = Time.valueOf(dto.getEndTime());
            Time startTime = Time.valueOf(dto.getStartTime());

            orgTimeSpan.setStartTime(startTime);
            orgTimeSpan.setEndTime(endTime);
            orgTimeSpan.setOrgId(orgId);
            // id = 0 或者 null 则添加
            if (dto.getId() == null || dto.getId() == 0) {
                orgTimeSpan.setId(null);
            } else {
                orgTimeSpan.setId(dto.getId());
            }
            this.orgTimeSpanDao.saveOrUpdate(orgTimeSpan);
        }
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgTimeSpanDto> listOrgTimeSpan(Long orgId) {

        List<OrgTimeSpan> list = this.orgTimeSpanDao.listOrgTimeSpan(orgId);

        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }

        List<OrgTimeSpanDto> dtos = Lists.newArrayList();
        for (OrgTimeSpan span : list) {
            OrgTimeSpanDto dto = new OrgTimeSpanDto();
            dto.setId(span.getId());
            dto.setStartTime(buildTimeStr(span.getStartTime()));
            dto.setEndTime(buildTimeStr(span.getEndTime()));
            dtos.add(dto);
        }
        return dtos;
    }

    private String buildTimeStr(Date time) {
        String str = DateUtil.getStrByDateFormate(time, "HH:mm:ss");
        if (str.equals("00:00:00")) {
            str = "24:00:00";
        }
        return str;
    }

    @Override
    public void deleteOrgTimeSpan(@NonNull Collection<Long> ids) {

        this.orgTimeSpanDao.delByIds(ids);

    }

    @Override
    @Transactional(readOnly = true)
    public CourseListReponseDto getOrgBasicCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument(orgId != null, "orgId is not null!");
        Preconditions.checkArgument(courseId != null, "courseId is not null!");
        OrgCourse course = this.orgCourseDao.getByCourseId(courseId);
        CourseListReponseDto dto = new CourseListReponseDto();
        dto.setCourseName(course.getName());
        dto.setOrgCourseId(course.getId());
        dto.setOrgCourseNumber(course.getNumber());
        dto.setCoverUrl(getCoverUrl(course));
        return dto;
    }

    private String getCoverUrl(OrgCourse course) {
        if (course == null || course.getCover() == null) {
            return "";
        }
        return getCoverUrl(course.getCover().longValue());
    }

    private String getCoverUrl(Long storageId) {

        if (storageId == null) {
            return "";
        }
        Storage storage = this.storageDao.getById(storageId);
        if (storage == null) {
            return "";
        }
        if (StringUtils.isNotBlank(storage.getAttach_url())) {
            return storage.getAttach_url();
        }
        return StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
    }

    @Override
    @Transactional(readOnly = true)
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {

        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument(userId != null, "student not exists!");
        log.debug("orgId = {}, lessonId{}, studentId ={}, userId={}", orgId, lessonId, studentId, userId);
        OrgClassLesson lesson = this.orgClassLessonDao.getById(lessonId);
        Preconditions.checkArgument(lesson != null, "lesson not exist!");
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId());

        Map<String, Object> map = Maps.newHashMap();
        map.put("index", lesson.getNumber());
        map.put("startTime", lesson.getStartTime());
        map.put("endTime", lesson.getEndTime());
        map.put("courseName", course.getName());

        Map<Long, Long> lessonTeacherMap =
            orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, Lists.newArrayList(new Long[] { lessonId }));
        log.debug("lessonTeacherMap = {}", lessonTeacherMap);
        Long teacherId = lessonTeacherMap.get(lessonId);
        if (teacherId == null) {
            log.warn("lessonid = {}, teacherId ={}", lessonId, teacherId);
            map.put("teacherName", "");
            map.put("avatarUrl", "");
            map.put("teacherId", 0);
            return map;
            // throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节老师不存在");
        }
        Teacher teacher = this.teacherDao.getByUserId(teacherId);

        if (teacher != null) {
            map.put("teacherName", teacher.getRealName() != null ? teacher.getRealName() : teacher.getNickName());
            map.put("teacherId", teacher.getUserId());
            if (teacher.getAvatar() != null) {
                Storage storage = storageDao.getById(teacher.getAvatar());
                if (storage != null) {
                    map.put("avatarUrl",
                        StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn()));
                }
            } else {
                log.warn("老师头像不存在!");
            }

        } else {
            log.warn("lessonid = {}, teacherId ={}", lessonId, teacherId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "老师不存在");
        }

        return map;
    }

    @Override
    public OrgCourseInfoDto getOrgCourseInfo(Long orgId, Long courseId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "illegal orgId");
        Preconditions.checkArgument(courseId != null && courseId > 0, "illegal courseId");
        OrgCourseInfoDto orgCourseInfoDto = new OrgCourseInfoDto();
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue(), "areaId");
        Area area = areaDao.getById(orgInfo.getAreaId(), "name", "bname");
        // 获取百度地图对应名称
        orgCourseInfoDto.setCityName(area.getBname());

        OrgCourse course = null;
        if (courseId != null && courseId > 0) {
            course = this.orgCourseDao.getById(courseId);
            if (course != null) {
                log.debug("---------------getNumber={},getCourseType={}", course.getNumber(),course.getCourseType());
                //班课
                if(course.getCourseType()==CourseTypeEnum.COURSE_TYPE_CLASS.getCode()){
                    List<Long> studentIds = this.orgStudentCourseDao.getStudents(orgId, courseId, 0);
                    orgCourseInfoDto.setStudentNum(studentIds.size());
                }else{
                    List<Long> classIds = this.orgCourseDao.getClassIdsByParentId(courseId);
                    List<Long> list = this.orgStudentCourseDao.getStudentIdsByCourseIds(orgId,classIds);
                    orgCourseInfoDto.setStudentNum(list.size());
                }
                orgCourseInfoDto.setCourseType(course.getCourseType());
                orgCourseInfoDto.setCourseNumber(course.getNumber());
                orgCourseInfoDto.setCourseId(courseId);
                orgCourseInfoDto.setCourseName(course.getName());
                orgCourseInfoDto.setCoursePrice(course.getPrice());
                orgCourseInfoDto.setCoursePriceStr(NumberUtil.get2FromDouble(course.getPrice()));
                orgCourseInfoDto.setLessonSummary(course.getLessonSummary());
                String courseUrl = environment.getProperty(RestConfig.org_class_course_url);
                orgCourseInfoDto.setCourseUrl(courseUrl + course.getNumber());
                // 班级人数
                orgCourseInfoDto.setMaxStudent(course.getMaxStudent());
                orgCourseInfoDto.setCoverStorageId(course.getCover());
                orgCourseInfoDto.setAddress(course.getAddress());
                orgCourseInfoDto.setStartTime(course.getBeginTime());
                orgCourseInfoDto.setEndTime(course.getEndTime());
                // 计划排课次数
                orgCourseInfoDto.setFreq(course.getFreq());
                String intro = BaseUtils.blobToString(course.getIntroduction(), "UTF-8");
                orgCourseInfoDto.setIntroduction(intro);
                orgCourseInfoDto.setStatus(course.getStatus());
                orgCourseInfoDto.setIsDel(course.getIsDel());
                // 课消规则
                Integer consumeRule = orgCourseConsumeRuleService.getRuleValueByCourseId(orgId, course);
                orgCourseInfoDto.setConsumeRule(consumeRule);
                orgCourseInfoDto.setConsumeRuleStr(CourseConsumeRuleEnum.getRuleDescByValue(consumeRule));

                if (StringUtils.isNotBlank(course.getOfflinePoi())) {
                    String[] lnglat = course.getOfflinePoi().split(",");
                    log.debug("latlng={},len={}", lnglat, lnglat.length);
                    if (lnglat != null && lnglat.length >= 2) {
                        String lng = lnglat[0];
                        String lat = lnglat[1];
                        try {
                            orgCourseInfoDto.setLat(Double.parseDouble(lat));
                            orgCourseInfoDto.setLng(Double.parseDouble(lng));
                        } catch (NumberFormatException e) {
                            log.warn("lat={},lng={}", lat, lng);
                        }
                    }
                }
                orgCourseInfoDto.setCoverUrl(getCoverUrl(course));
                orgCourseInfoDto.setTeachers(this.courseTeacherService.listCourseTeacher(orgId, courseId));
                List<OrgCourseGroupDto> groups = this.orgCourseGroupService.getByCourseId(orgId, courseId);
                if (CollectionUtils.isNotEmpty(groups)) {
                    // orgCourseInfoDto.setGroup(JacksonUtil.obj2Str(groups));
                    orgCourseInfoDto.setGroups(groups);
                }

                // 根据课程id找到该课程对应所有老师的user_id
                List<Long> teacherIds = orgCourseTeacherDao.getTeacherIdsByCourseId(courseId);
                log.debug("------------------teacherIds={}", teacherIds);
                // 根据所有老师的user_id获得全部老师信息
                List<Teacher> teachers = teacherDao.getByUserIds(teacherIds);
                Map<Long, Teacher> teacherMap = Maps.newHashMap();
                if (teacherIds != null && teacherIds.size() > 0) {
                    teacherMap = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
                        @Override
                        public Long apply(Teacher input) {
                            return input.getUserId();
                        }
                    });
                }
                // 获得老师number,对应user表中的number
                List<Long> userIds = Lists.newArrayList();
                for (Teacher t : teachers) {
                    userIds.add(t.getUserId());
                }
                List<User> users = userDao.queryByUserIds(userIds);
                Map<Long, User> teacherNumberMap = CollectorUtil.collectMap(users, new Function<User, Long>() {
                    @Override
                    public Long apply(User u) {
                        return u.getId();
                    }
                });
                // 获得老师头像，copy自教师信息service
                Map<Long, Teacher> storageIds = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
                    @Override
                    public Long apply(Teacher teacher) {
                        return teacher.getAvatar();
                    }
                });
                List<Storage> storages = storageDao.getByIds(storageIds.keySet());
                Map<Long, Storage> storageMap = CollectorUtil.collectMap(storages, new Function<Storage, Long>() {
                    @Override
                    public Long apply(Storage storage) {
                        return storage.getId();
                    }
                });
                // 因为原课程详情里包括TeacherResponseDto,但没为其赋值，这里给他赋值
                List<TeacherResponseDto> list = Lists.newArrayList();
                for (Long l : teacherIds) {
                    TeacherResponseDto dto = new TeacherResponseDto();
                    Teacher teacher = teacherMap.get(l);
                    if (teacher.getOrgId() == null || teacher.getOrgId().longValue() != orgId.longValue()) {
                        continue;
                    }
                    if (teacher.getAvatar() != null) {
                        Storage storage = storageMap.get(teacher.getAvatar());
                        if (storage != null) {
                            String avatarUrl =
                                StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                            dto.setAvatar(avatarUrl);
                        }
                    }
                    dto.setBranchId(teacher.getBranchId());
                    dto.setMobile(teacher.getMobile());
                    dto.setSchoolAge(teacher.getSchoolAge());
                    dto.setTeacherId(teacher.getUserId());
                    dto.setTeacherName(teacher.getRealName());
                    dto.setTeacherNumber(teacherNumberMap.get(l).getNumber());
                    list.add(dto);
                }
                orgCourseInfoDto.setTeachers(list);
                // 已经安排课节
                Set<Long> set = Sets.newHashSet();
                set.add(courseId);
                Map<Long, Integer> map = orgClassLessonDao.getLessonCount(orgId, set, 0);
                int hasPlan = 0;
                if (map.get(courseId) != null) {
                    hasPlan = map.get(courseId);
                }
                orgCourseInfoDto.setHasPlan(hasPlan);
                // 开课日期和星期
                // 如果org_course表开始时间为空，去org_class_lesson取第一节课的时间
                Date date = course.getBeginTime();
                if (date != null) {
                    orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate(date, "yyyy年MM月dd日"));
                    orgCourseInfoDto.setStartWeek("星期" + DateUtil.getChineseWeekDay(date));
                } else {
                    List<OrgClassLesson> ll =
                        orgClassLessonDao.getLessons(set, null, orgId, DeleteStatus.NORMAL.getValue());
                    if (ll != null && ll.size() > 0) {
                        OrgClassLesson o = ll.get(0);
                        orgCourseInfoDto.setStartDay(DateUtil.getStrByDateFormate(o.getStartTime(), "yyyy年MM月dd日"));
                        orgCourseInfoDto.setStartWeek("星期" + DateUtil.getChineseWeekDay(o.getStartTime()));
                    } else {
                        orgCourseInfoDto.setStartDay("");
                        orgCourseInfoDto.setStartWeek("");
                    }
                }
                orgCourseInfoDto.setIsCourse(course.getIsCourse());
            }
        }
        return orgCourseInfoDto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteOrgCourses(Long orgId, Collection<Long> courseIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "illegal orgId!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        Preconditions.checkArgument(orgNumber != null && orgNumber > 0, "illegal orgNumber!");
        
        
        List<OrgStudentCourse> studentCourseList = orgStudentCourseDao.getOrgCourseByOrgIdAndIds(orgId,courseIds);
        Set<Long> studentUserId = Sets.newHashSet();
        for(OrgStudentCourse studentCourse:studentCourseList){
            studentUserId.add(studentCourse.getUserId());
        }
        List<OrgStudent> effectOrgStudentList = orgStudentDao.getStudentByUserIds(orgId, studentUserId);
        if(effectOrgStudentList.size()>0){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "删除班级前请先将班内学员退班");
        }
        Map<String, Object> updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", courseIds);
        updateCondtion.put("orgNumber", orgNumber);
        
       
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setIsDel(1);
        // orgCourse.setStatus(OrgCourseStatus.OFFLINE.getCode());
        this.orgCourseDao.update(updateCondtion, orgCourse, "isDel");

        // 删除班级的同时删除班级下的课节列表
        // add by zhangbing
        // cascadeDeleteCourseLessons(orgId, courseIds);

        // 20160909新增加逻辑
        // 冲突表tts.org_lesson_conflict清理
        Map<String, Object> set = Maps.newHashMap();
        set.put("del_status", DataStatus.DELETE.getValue());
        for (Long courseId : courseIds) {
            List<OrgClassLesson> list = orgClassLessonDao.getLessonByCourseIds(Arrays.asList(courseId));
            if (CollectionUtils.isNotEmpty(list)) {
                try {
                    Map<String, Object> map = Maps.newHashMap();
                    map.put("lesson_id", BaseUtils.getPropertiesList(list, "id"));
                    orgLessonConflictDao.delByCondition(map);
                    // orgLessonConflictDao.updateDelStatus(BaseUtils.getPropertiesList(list, "id"));
                } catch (Exception e) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, e.getMessage());
                }
            }
        }
    }

    /**
     * 删除课程的同时删除班级下的课节列表
     * 
     * @param orgId
     * @param courseIds
     */
    void cascadeDeleteCourseLessons(Long orgId, Collection<Long> courseIds) {
        if (CollectionUtils.isNotEmpty(courseIds)) {
            this.orgClassLessonDao.deleteByCourseIds(orgId, courseIds);
        }
    }

    @Override
    public void batchUpdateStatus(Long orgId, Collection<Long> courseIds, Integer status) {

        Preconditions.checkArgument(orgId != null && orgId > 0, "illegal orgId!");
        if (CollectionUtils.isEmpty(courseIds)) {
            return;
        }
        Long orgNumber = this.getOrgNumber(orgId);
        Preconditions.checkArgument(orgNumber != null && orgNumber > 0, "illegal orgNumber!");
        Map<String, Object> updateCondtion = Maps.newHashMap();
        updateCondtion.put("id", courseIds);
        updateCondtion.put("orgNumber", orgNumber);
        OrgCourse orgCourse = new OrgCourse();
        orgCourse.setStatus(status);
        this.orgCourseDao.update(updateCondtion, orgCourse, "status");
    }

    @Override
    public void repairNumber() {
        log.info("repairNumber");
        orgCourseDao.repairNumber();

    }

    @Override
    public OrgCourseDetailResponseDto getOrgCourseDetailByNumber(Long orgNumber, Long courseNumber) {
        OrgCourse course = this.orgCourseDao.getByCourseNumber(courseNumber);
        log.debug("-----------courseNumber={},courseType={}",courseNumber,course.getCourseType());
        OrgCourseDetailResponseDto dto = null;
        if (course != null && course.getOrgNumber().equals(orgNumber)) {
            String host = PropertiesReader.getValue("wxm", "m.server");
            String imgServer = PropertiesReader.getValue("wxm", "img.server");
            List<Long> ids = Lists.newArrayList(course.getId());
            Map<Long, List<String>> cache = this.getCourseIdTeacherNamesMap(ids);
            dto = new OrgCourseDetailResponseDto();
            dto.setCourseId(course.getId());
            dto.setCourseType(course.getCourseType());
            dto.setName(course.getName());
            dto.setNumber(course.getNumber());
            dto.setPrice(course.getPrice() + "");
            if (cache.containsKey(course.getId())) {
                dto.setTeacherName(cache.get(course.getId()).get(0));
            } else {
                dto.setTeacherName("待定");
            }

            if (course.getCover() != null) {
                dto.setPreface(getCoverUrl(course.getCover().longValue()));
            }

            dto.setLink(
                BizConf.ORG_COURSE_LINK.replace("{host}", host).replace("{number}", course.getNumber().toString()));

        }
        return dto;
    }

    @Override
    public List<OrgCourse> getAllOrgCourses(@NonNull Long orgId, String key) {

        Long orgNumber = this.getOrgNumber(orgId);

        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return Lists.newArrayList();
        }

        log.info("getOrgCourses orgNumber {}", orgNumber);

        List<OrgCourse> orgCourses =
            orgCourseDao.getCoursesByOrgNumberAndName(orgNumber, key, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, null);

        return orgCourses;

    }

    @Override
    public List<OrgCourse> getAllOrgCoursesByNames(@NonNull Long orgId, List<String> courseNames) {

        Long orgNumber = this.getOrgNumber(orgId);

        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return Lists.newArrayList();
        }

        log.info("getOrgCourses orgNumber {}", orgNumber);

        List<OrgCourse> orgCourses = orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null,
            CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_TRUE.getCode(),
            CourseTypeEnum.COURSE_TYPE_CLASS.getCode(), null);
        return orgCourses;

    }
    
    @Override
    public List<OrgCourse> getAll1V1CoursesByNames(@NonNull Long orgId, List<String> courseNames) {
        
        Long orgNumber = this.getOrgNumber(orgId);
        
        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return Lists.newArrayList();
        }
        
        log.info("getOrgCourses orgNumber {}", orgNumber);
        
        List<OrgCourse> orgCourses = orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null,
            CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_FALSE.getCode(),
            CourseTypeEnum.COURSE_TYPE_1v1.getCode(), null);
        
        return orgCourses;
        
    }

    @Override
    public List<OrgClassLessonDto> getOrgClassLessonDtoList(Long orgId, Long id) {
        Set<Long> set = Sets.newHashSet();
        set.add(id);
        List<OrgClassLesson> orgClassLesson =
            orgClassLessonDao.getLessons(set, null, orgId, DeleteStatus.NORMAL.getValue());
        List<OrgClassLessonDto> classDetail = buildOrgClassLessonDto(orgClassLesson);
        return classDetail;
    }

    private List<OrgClassLessonDto> buildOrgClassLessonDto(List<OrgClassLesson> orgClassLesson) {
        List<OrgClassLessonDto> list = Lists.newArrayList();
        for (OrgClassLesson o : orgClassLesson) {
            OrgClassLessonDto dto = new OrgClassLessonDto();
            dto.setNumber(o.getNumber());
            Date startTime = o.getStartTime();
            Date endTime = o.getEndTime();
            dto.setDate(DateUtil.getStrByDateFormate(startTime, "MM月dd日"));
            dto.setStartTime(DateUtil.getStrByDateFormate(startTime, "HH:mm"));
            dto.setEndTime(DateUtil.getStrByDateFormate(endTime, "HH:mm"));
            dto.setWeek("周" + DateUtil.getChineseWeekDay(startTime));
            list.add(dto);
        }
        return list;
    }

    @Override
    public List<Long> getCourseNumberByOrg(@NonNull Long orgNumber) {
        return orgCourseDao.getCourseNumberByOrg(orgNumber, null, null, null);
    }
    
    @Override
    public Map<String, OrgCourse> getAllOrgCoursesMapByNames_class(Long orgId, List<String> courseNames) {
        Long orgNumber = this.getOrgNumber(orgId);
        Map<String, OrgCourse> data = Maps.newHashMap();
        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return data;
        }

        log.info("getOrgCourses orgNumber {}", orgNumber);
        

        List<OrgCourse> orgCourses = orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null,
            CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_TRUE.getCode(),
            CourseTypeEnum.COURSE_TYPE_CLASS.getCode(), null);
        //去重
        for(int i = 0; i < orgCourses.size() - 1; i++) {
        	for(int j = orgCourses.size() - 1; j > i; j--) {
        		String namej = orgCourses.get(j).getName();
        		String namei = orgCourses.get(i).getName();
        		if(namej.equals(namei)) {
        			orgCourses.remove(j);
        		}
        	}
        }

        if (CollectionUtils.isNotEmpty(orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                data.put(orgCourse.getName(), orgCourse);
            }
        }
        return data;

    }

    @Override
    public Map<String, OrgCourse> getAllOrgCoursesMapByNames(Long orgId, List<String> courseNames) {
        Long orgNumber = this.getOrgNumber(orgId);
        Map<String, OrgCourse> data = Maps.newHashMap();
        if (orgNumber == null) {
            log.error("orgNumber = {}", orgNumber);
            return data;
        }

        log.info("getOrgCourses orgNumber {}", orgNumber);
        

        List<OrgCourse> orgCourses = orgCourseDao.getCoursesByOrgNumberAndNames(orgNumber, courseNames, null,
            CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_FALSE.getCode(),
            CourseTypeEnum.COURSE_TYPE_1v1.getCode(), null);
        if (CollectionUtils.isNotEmpty(orgCourses)) {
            for (OrgCourse orgCourse : orgCourses) {
                data.put(orgCourse.getName(), orgCourse);
            }
        }
        return data;

    }

    @Override
    public void saveOrgCourse(OrgCourse orgCourse) {
        orgCourseDao.save(orgCourse);
    }

    @Override
    public List<CourseDto> selectCourse(Long orgId, List<Long> teacherIds, List<Long> classRoomIds, Integer type) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "机构id非法");
        // 查询有冲突的课节
        List<Long> confictLessonIds = Lists.newArrayList();
        if (type == 1) {
            List<OrgLessonConflict> confictLessons = orgLessonConflictDao.queryConfilctByTeacherIds(orgId, teacherIds);
            confictLessonIds =
                com.baijia.commons.lang.utils.BaseUtils.getPropertyCollections(confictLessons, "lessonIds");
        }
        // 查询老师课节信息
        List<Long> teacherLessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            List<OrgTeacherLesson> orgTeacherLessons = orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds);
            teacherLessonIds =
                com.baijia.commons.lang.utils.BaseUtils.getPropertyCollections(orgTeacherLessons, "lessonIds");
        }
        // 查询满足条件的课节信息
        List<OrgClassLesson> orgClassLessons =
            orgClassLessonDao.queryForSelectCourse(orgId, classRoomIds, confictLessonIds, teacherLessonIds);
        List<Long> courseIds =
            com.baijia.commons.lang.utils.BaseUtils.getPropertyCollections(orgClassLessons, "courseId");
        List<OrgCourse> orgCourses = orgCourseDao.getByIds(courseIds);
        return CourseDto.converToDto(orgCourses);
    }

    @Override
    public ArrayListMultimap<Long, Long> getCourseClassIdMap(Long orgId, List<Long> parentIds) {
        Long orgNumber = this.getOrgNumber(orgId);
        List<OrgCourse> orgCourses = orgCourseDao.getCoursesByParentIds(orgNumber, parentIds);
        ArrayListMultimap<Long, Long> data = ArrayListMultimap.create();
        if(CollectionUtils.isNotEmpty(orgCourses)){
            for(OrgCourse orgCourse : orgCourses){
                data.put(orgCourse.getParentId(), orgCourse.getId());
            }
        }
        return data;
    }

    @Override
    public int getAllCourseNumberByOrg(@NonNull Long orgNumber) {
        return orgCourseDao.getAllCourseCountByOrg(orgNumber);
    }
}
